/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.channel.common.linker;

import cn.foxtech.channel.common.linker.LinkerMethodEntity;
import cn.foxtech.channel.common.linker.LinkerMethodTemplate;
import cn.foxtech.channel.common.properties.ChannelProperties;
import cn.foxtech.common.utils.reflect.JarLoaderUtils;
import cn.foxtech.device.protocol.RootLocation;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeDeviceType;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LinkerMethodScanner {
    private static final Logger logger = Logger.getLogger(LinkerMethodScanner.class);
    @Autowired
    private ChannelProperties channelProperties;
    @Autowired
    private LinkerMethodTemplate methodTemplate;

    public static LinkerMethodEntity scanMethod(Class<?> aClass) {
        LinkerMethodEntity linkerMethodEntity = new LinkerMethodEntity();
        try {
            Method[] methods;
            if (!aClass.isAnnotationPresent(FoxEdgeDeviceType.class)) {
                return null;
            }
            FoxEdgeDeviceType typeAnnotation = aClass.getAnnotation(FoxEdgeDeviceType.class);
            String deviceType = typeAnnotation.value();
            String manufacturer = typeAnnotation.manufacturer();
            linkerMethodEntity.setDeviceType(deviceType);
            linkerMethodEntity.setManufacturer(manufacturer);
            for (Method method : methods = aClass.getMethods()) {
                linkerMethodEntity.setMethod(method);
            }
            if (linkerMethodEntity.isNull()) {
                return null;
            }
            return linkerMethodEntity;
        }
        catch (Throwable e) {
            logger.error((Object)e);
            return null;
        }
    }

    public void loadJar() {
        try {
            Map<String, Object> encoderJars = this.channelProperties.getLinkEncoderJars();
            for (String key : encoderJars.keySet()) {
                Object value = encoderJars.get(key);
                if (value == null) continue;
                String jarFile = value.toString();
                JarLoaderUtils.loadJar((String)jarFile);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public Map<String, LinkerMethodEntity> scanMethod(String pack) {
        HashMap<String, LinkerMethodEntity> result = new HashMap<String, LinkerMethodEntity>();
        try {
            Set classSet = JarLoaderUtils.getClasses((String)pack);
            for (Class aClass : classSet) {
                LinkerMethodEntity linkerMethodEntity = LinkerMethodScanner.scanMethod(aClass);
                if (linkerMethodEntity == null) continue;
                result.put(linkerMethodEntity.getDeviceType(), linkerMethodEntity);
            }
        }
        catch (Throwable e) {
            logger.error((Object)e);
        }
        return result;
    }

    public void scanMethod() {
        Map<String, LinkerMethodEntity> methods = this.scanMethod(RootLocation.class.getPackage().getName());
        this.methodTemplate.getMap().putAll(methods);
    }
}

