/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.channel.common.linker;

import cn.foxtech.channel.common.linker.LinkerEntity;
import cn.foxtech.channel.common.linker.LinkerManager;
import cn.foxtech.common.utils.scheduler.multitask.PeriodTask;
import cn.foxtech.common.utils.scheduler.multitask.PeriodTaskType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LinkerDeleteLinkerPeriodTask
extends PeriodTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkerDeleteLinkerPeriodTask.class);

    public int getTaskType() {
        return PeriodTaskType.task_type_share;
    }

    public int getSchedulePeriod() {
        return 5;
    }

    public void execute() {
        List<LinkerEntity> entities = LinkerManager.queryEntityListByLinkStatus(true);
        if (entities.isEmpty()) {
            return;
        }
        for (LinkerEntity entity : entities) {
            this.deleteLink(entity);
        }
    }

    private void deleteLink(LinkerEntity entity) {
        if (entity.getFailActive() < 5L) {
            return;
        }
        LOGGER.info("\u94fe\u8def\u65ad\u5f00:" + entity.getChannelName());
        LinkerManager.updateEntity4LinkStatus(entity.getChannelName(), true);
    }
}

