/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.channel.common.linker;

import cn.foxtech.channel.common.api.ChannelClientAPI;
import cn.foxtech.channel.common.linker.LinkerEntity;
import cn.foxtech.channel.common.linker.LinkerManager;
import cn.foxtech.channel.common.linker.LinkerMethodEntity;
import cn.foxtech.channel.common.linker.LinkerMethodTemplate;
import cn.foxtech.channel.common.properties.ChannelProperties;
import cn.foxtech.channel.common.service.EntityManageService;
import cn.foxtech.channel.domain.ChannelRequestVO;
import cn.foxtech.channel.domain.ChannelRespondVO;
import cn.foxtech.common.entity.entity.ChannelEntity;
import cn.foxtech.common.utils.method.MethodUtils;
import cn.foxtech.common.utils.scheduler.multitask.PeriodTask;
import cn.foxtech.common.utils.scheduler.multitask.PeriodTaskType;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LinkerActiveLinkerPeriodTask
extends PeriodTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkerActiveLinkerPeriodTask.class);
    @Autowired
    private ChannelClientAPI channelService;
    @Autowired
    private EntityManageService entityManageService;
    @Autowired
    private ChannelProperties channelProperties;
    @Autowired
    private LinkerMethodTemplate methodTemplate;

    public int getTaskType() {
        return PeriodTaskType.task_type_share;
    }

    public int getSchedulePeriod() {
        return 5;
    }

    public void execute() {
        List<LinkerEntity> entities = LinkerManager.queryEntityListByLinkStatus(true);
        if (entities.isEmpty()) {
            return;
        }
        for (LinkerEntity entity : entities) {
            this.activeLink(entity.getChannelName());
        }
    }

    private void activeLink(String channelName) {
        try {
            ChannelEntity channelEntity = this.entityManageService.getChannelEntity(channelName, this.channelProperties.getChannelType());
            if (channelEntity == null) {
                return;
            }
            Object linkEncoder = channelEntity.getChannelParam().get("link-encoder");
            if (linkEncoder == null) {
                return;
            }
            LinkerMethodEntity methodEntity = this.methodTemplate.getMap().get(linkEncoder);
            if (methodEntity == null) {
                return;
            }
            Object send = methodEntity.getEncodeActiveLinkerRequest().invoke((Object)this, channelEntity.getChannelParam());
            if (MethodUtils.hasEmpty((Object[])new Object[]{send})) {
                return;
            }
            ChannelRequestVO requestVO = new ChannelRequestVO();
            requestVO.setName(channelName);
            requestVO.setUuid(UUID.randomUUID().toString());
            requestVO.setTimeout(Integer.valueOf(2000));
            requestVO.setSend(send);
            ChannelRespondVO respondVO = this.channelService.execute(requestVO);
            if (respondVO.getCode() != 200) {
                LOGGER.info("\u6fc0\u6d3b\u94fe\u8def\u5931\u8d25:" + channelName);
                LinkerManager.updateEntity4ActiveLinker(channelName, false);
                return;
            }
            if (!((Boolean)methodEntity.getDecodeActiveLinkerRespond().invoke((Object)this, channelEntity.getChannelParam(), respondVO.getRecv())).booleanValue()) {
                LOGGER.info("\u6fc0\u6d3b\u94fe\u8def\u5931\u8d25:" + channelName);
                LinkerManager.updateEntity4ActiveLinker(channelName, false);
                return;
            }
            LinkerManager.updateEntity4ActiveLinker(channelName, true);
        }
        catch (InvocationTargetException ie) {
            LOGGER.info("\u6fc0\u6d3b\u94fe\u8def\u5931\u8d25:" + channelName + ",\u539f\u56e0:" + ie.getTargetException());
        }
        catch (Exception e) {
            LOGGER.info("\u6fc0\u6d3b\u94fe\u8def\u5931\u8d25:" + channelName + ",\u539f\u56e0:" + e.getMessage());
        }
    }
}

