/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.cluster.zookeeper;

import com.google.common.collect.Lists;
import io.polaris.cluster.zookeeper.ZookeeperConfig;
import io.polaris.core.cluster.ClusterService;
import io.polaris.core.cluster.InstanceNode;
import io.polaris.core.cluster.InstanceQueryException;
import io.polaris.core.cluster.InstanceRegisterException;
import io.polaris.core.lang.TypeRef;
import io.polaris.core.service.ServiceName;
import io.polaris.core.string.Strings;
import io.polaris.json.Jacksons;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.x.discovery.ServiceCache;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value="zookeeper")
public class ZookeeperClusterService
implements ClusterService {
    private static final Logger log = LoggerFactory.getLogger(ZookeeperClusterService.class);
    private static final String DEFAULT_NAMESPACE = "/public";
    private ZookeeperConfig config;
    private CuratorFramework client;
    private ServiceDiscovery<InstanceNode> serviceDiscovery;
    private ServiceCache<InstanceNode> serviceCache;
    private volatile InstanceNode selfInstance;
    private volatile boolean started = false;

    public ZookeeperClusterService() {
        this(null);
    }

    public ZookeeperClusterService(ZookeeperConfig config) {
        this.config = config;
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
    }

    private void doStart() {
        if (!this.started) {
            this.doStop();
            if (this.config == null) {
                throw new IllegalStateException("config is null");
            }
            ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(this.config.getBaseSleepTimeMs(), this.config.getMaxRetries());
            CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().retryPolicy((RetryPolicy)retryPolicy).connectString(this.config.getHostPort());
            if (this.config.isEnableAcl()) {
                String authInfo = this.config.getAuth();
                if ("digest".equals(this.config.getSchema())) {
                    try {
                        authInfo = DigestAuthenticationProvider.generateDigest((String)authInfo);
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new IllegalStateException(e.getMessage(), e);
                    }
                } else {
                    throw new IllegalStateException("Support digest schema only.");
                }
                final ArrayList acls = Lists.newArrayList();
                acls.add(new ACL(31, new Id(this.config.getSchema(), authInfo)));
                acls.add(new ACL(1, ZooDefs.Ids.ANYONE_ID_UNSAFE));
                ACLProvider provider = new ACLProvider(){

                    public List<ACL> getDefaultAcl() {
                        return acls;
                    }

                    public List<ACL> getAclForPath(String s) {
                        return acls;
                    }
                };
                builder.aclProvider(provider);
                builder.authorization(this.config.getSchema(), this.config.getAuth().getBytes());
            }
            this.client = builder.build();
            String path = Strings.isBlank((CharSequence)this.config.getNamespace()) ? DEFAULT_NAMESPACE : this.config.getNamespace();
            this.serviceDiscovery = ServiceDiscoveryBuilder.builder(InstanceNode.class).client(this.client).basePath(path).watchInstances(true).serializer(new InstanceSerializer(){

                public byte[] serialize(ServiceInstance instance) throws Exception {
                    return Jacksons.toJsonBytes((Object)instance);
                }

                public ServiceInstance deserialize(byte[] bytes) throws Exception {
                    return (ServiceInstance)Jacksons.toJavaObject((byte[])bytes, (TypeRef)new TypeRef<ServiceInstance<InstanceNode>>(){});
                }
            }).build();
            try {
                this.client.start();
                this.client.blockUntilConnected();
                this.serviceDiscovery.start();
                this.serviceCache = this.serviceDiscovery.serviceCacheBuilder().name(this.config.getServiceName()).build();
                this.serviceCache.start();
                this.started = true;
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    private void doStop() {
        try {
            if (this.serviceCache != null) {
                this.serviceCache.close();
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
        try {
            if (this.serviceDiscovery != null) {
                this.serviceDiscovery.close();
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
        try {
            CuratorFrameworkState state;
            if (this.client != null && ((state = this.client.getState()) == null || state != CuratorFrameworkState.STOPPED)) {
                this.client.close();
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
        this.started = false;
        this.client = null;
        this.serviceDiscovery = null;
        this.serviceCache = null;
    }

    private void prepare() {
        if (!this.started) {
            this.doStart();
        }
    }

    public void start() {
        this.doStart();
    }

    public void stop() {
        this.doStop();
    }

    public synchronized void register(InstanceNode instanceNode) throws InstanceRegisterException {
        this.prepare();
        instanceNode.check();
        try {
            ServiceInstance thisInstance = ServiceInstance.builder().name(this.config.getServiceName()).id(instanceNode.getId()).address(instanceNode.getHost()).port(instanceNode.getPort()).payload((Object)instanceNode).build();
            this.serviceDiscovery.registerService(thisInstance);
            this.selfInstance = instanceNode;
        }
        catch (Throwable e) {
            throw new InstanceRegisterException(e.getMessage(), e);
        }
    }

    public List<InstanceNode> query() {
        this.prepare();
        ArrayList<InstanceNode> list = new ArrayList<InstanceNode>(20);
        try {
            List serviceInstances = this.serviceCache.getInstances();
            boolean hasSelf = false;
            for (ServiceInstance serviceInstance : serviceInstances) {
                InstanceNode instance = (InstanceNode)serviceInstance.getPayload();
                if (instance.equals((Object)this.selfInstance)) {
                    instance.setSelf(true);
                    hasSelf = true;
                } else {
                    instance.setSelf(false);
                }
                list.add(instance);
            }
            if (this.selfInstance != null && !hasSelf) {
                list.add(this.selfInstance);
            }
        }
        catch (Throwable e) {
            throw new InstanceQueryException(e.getMessage(), e);
        }
        return list;
    }

    public void setConfig(ZookeeperConfig config) {
        this.config = config;
    }

    public ZookeeperConfig getConfig() {
        return this.config;
    }
}

