/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.web.wrapper;

import io.polaris.core.io.IO;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class HttpServletRequestCacheWrapper
extends HttpServletRequestWrapper
implements HttpServletRequest {
    private static final String FORM_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final String METHOD_POST = "POST";
    public static final String ISO_8859_1 = "ISO-8859-1";
    private final ByteArrayOutputStream paramCache;
    private byte[] contentData;
    private HttpServletRequest request;
    private boolean cached = false;

    private HttpServletRequestCacheWrapper(HttpServletRequest request) {
        super(request);
        this.request = request;
        int contentLength = request.getContentLength();
        this.paramCache = new ByteArrayOutputStream(contentLength >= 0 ? contentLength : 1024);
    }

    public static HttpServletRequest wrap(HttpServletRequest request) {
        if (request instanceof HttpServletRequestCacheWrapper) {
            return (HttpServletRequestCacheWrapper)request;
        }
        return new HttpServletRequestCacheWrapper(request);
    }

    public String getParameter(String name) {
        this.cacheRequestParameters();
        return super.getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        this.cacheRequestParameters();
        return super.getParameterMap();
    }

    public Enumeration<String> getParameterNames() {
        this.cacheRequestParameters();
        return super.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        this.cacheRequestParameters();
        return super.getParameterValues(name);
    }

    private void parse(HttpServletRequest request) {
        if (this.cached) {
            return;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ServletInputStream in = request.getInputStream();
            if (in != null) {
                IO.copy((InputStream)in, (OutputStream)bos, (int)4096);
                this.contentData = bos.toByteArray();
            } else {
                this.contentData = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.cached = true;
    }

    public byte[] getContentData() {
        this.parse(this.request);
        return this.contentData == null ? this.paramCache.toByteArray() : this.contentData;
    }

    public ServletInputStream getInputStream() throws IOException {
        this.parse(this.request);
        if (this.contentData == null) {
            return null;
        }
        return new ServletInputStream(){
            ByteArrayInputStream bis;
            {
                this.bis = new ByteArrayInputStream(HttpServletRequestCacheWrapper.this.contentData);
            }

            public int read() throws IOException {
                return this.bis.read();
            }

            public boolean isReady() {
                return true;
            }

            public boolean isFinished() {
                return this.bis.available() == 0;
            }

            public void setReadListener(ReadListener listener) {
            }
        };
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.getCharacterEncoding()));
    }

    public String getCharacterEncoding() {
        String enc = super.getCharacterEncoding();
        return enc != null ? enc : ISO_8859_1;
    }

    private void cacheRequestParameters() {
        if (this.paramCache.size() == 0 && this.isFormPost()) {
            this.writeRequestParametersToCachedContent();
        }
    }

    private boolean isFormPost() {
        String contentType = this.getContentType();
        return contentType != null && contentType.contains(FORM_CONTENT_TYPE) && METHOD_POST.equalsIgnoreCase(this.getMethod());
    }

    private void writeRequestParametersToCachedContent() {
        try {
            if (this.paramCache.size() == 0) {
                String requestEncoding = this.getCharacterEncoding();
                Map form = super.getParameterMap();
                Iterator nameIterator = form.keySet().iterator();
                while (nameIterator.hasNext()) {
                    String name = (String)nameIterator.next();
                    List<Object> values = Arrays.asList((Object[])form.get(name));
                    Iterator<Object> valueIterator = values.iterator();
                    while (valueIterator.hasNext()) {
                        String value = (String)valueIterator.next();
                        this.paramCache.write(URLEncoder.encode(name, requestEncoding).getBytes());
                        if (value == null) continue;
                        this.paramCache.write(61);
                        this.paramCache.write(URLEncoder.encode(value, requestEncoding).getBytes());
                        if (!valueIterator.hasNext()) continue;
                        this.paramCache.write(38);
                    }
                    if (!nameIterator.hasNext()) continue;
                    this.paramCache.write(38);
                }
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to write request parameters to cached content", ex);
        }
    }
}

