/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.web.mock;

import io.polaris.web.mock.MockHttpServletResponse;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockRequestDispatcher
implements RequestDispatcher {
    private static final Logger log = LoggerFactory.getLogger(MockRequestDispatcher.class);
    private final String resource;

    public MockRequestDispatcher(String resource) {
        this.resource = resource;
    }

    public void forward(ServletRequest request, ServletResponse response) {
        if (response.isCommitted()) {
            throw new IllegalStateException("Cannot perform forward - response is already committed");
        }
        this.getMockHttpServletResponse(response).setForwardedUrl(this.resource);
        if (log.isDebugEnabled()) {
            log.debug("MockRequestDispatcher: forwarding to [" + this.resource + "]");
        }
    }

    public void include(ServletRequest request, ServletResponse response) {
        this.getMockHttpServletResponse(response).addIncludedUrl(this.resource);
        if (log.isDebugEnabled()) {
            log.debug("MockRequestDispatcher: including [" + this.resource + "]");
        }
    }

    protected MockHttpServletResponse getMockHttpServletResponse(ServletResponse response) {
        if (response instanceof MockHttpServletResponse) {
            return (MockHttpServletResponse)response;
        }
        if (response instanceof HttpServletResponseWrapper) {
            return this.getMockHttpServletResponse(((HttpServletResponseWrapper)response).getResponse());
        }
        throw new IllegalArgumentException("MockRequestDispatcher requires MockHttpServletResponse");
    }
}

