/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.validation.validator;

import io.polaris.core.string.Strings;
import io.polaris.validation.RuntimeValidated;
import io.polaris.validation.RuntimeValidation;
import io.polaris.validation.ValidationMessageFormatter;
import io.polaris.validation.ValidationResult;
import io.polaris.validation.Validations;
import java.util.function.Supplier;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;

public class RuntimeValidator
implements ConstraintValidator<RuntimeValidated, Object> {
    private static final ThreadLocal<RuntimeValidation> LOCAL = new ThreadLocal();
    private Class<? extends Payload>[] payload;

    public static void with(RuntimeValidation validation, Runnable runnable) {
        RuntimeValidator.bind(validation);
        try {
            runnable.run();
        }
        finally {
            RuntimeValidator.clear();
        }
    }

    public static <T> T with(RuntimeValidation validation, Supplier<T> supplier) {
        RuntimeValidator.bind(validation);
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            RuntimeValidator.clear();
        }
    }

    public static void bind(RuntimeValidation validation) {
        LOCAL.set(validation);
    }

    public static void clear() {
        LOCAL.remove();
    }

    public void initialize(RuntimeValidated constraintAnnotation) {
        this.payload = constraintAnnotation.payload();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        ValidationMessageFormatter formatter;
        ValidationResult rs;
        RuntimeValidation runtimeValidation = LOCAL.get();
        if (runtimeValidation != null && (rs = runtimeValidation.isValid(context, value, formatter = Validations::formatValidationMessage)) != null && !rs.isValid()) {
            String message = rs.getMessage();
            if (Strings.isNotBlank((CharSequence)message)) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(message).addConstraintViolation();
            }
            return false;
        }
        return true;
    }
}

