/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.validation.validator;

import io.polaris.validation.LengthRange;
import java.util.Collection;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class LengthRangeCollectionValidator
implements ConstraintValidator<LengthRange, Collection<String>> {
    private int min;
    private int max;

    public void initialize(LengthRange constraintAnnotation) {
        this.min = constraintAnnotation.min();
        this.max = constraintAnnotation.max();
    }

    public boolean isValid(Collection<String> value, ConstraintValidatorContext context) {
        if (value == null || value.size() == 0) {
            return true;
        }
        for (String s : value) {
            if (s == null || s.length() <= this.max && s.length() >= this.min) continue;
            return false;
        }
        return true;
    }
}

