/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.validation.validator;

import io.polaris.core.map.Maps;
import io.polaris.validation.InNumber;
import io.polaris.validation.Validations;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class InNumberValidator
implements ConstraintValidator<InNumber, Number> {
    private Set<Long> values;

    public void initialize(InNumber constraintAnnotation) {
        this.values = new HashSet<Long>();
        for (long l : constraintAnnotation.value()) {
            this.values.add(l);
        }
    }

    public boolean isValid(Number value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (this.values.contains(value.longValue())) {
            return true;
        }
        context.disableDefaultConstraintViolation();
        HashMap map = Maps.newHashMap();
        map.put("value", this.values.toString());
        String message = Validations.formatValidationMessage(context.getDefaultConstraintMessageTemplate(), map);
        context.buildConstraintViolationWithTemplate(message).addConstraintViolation();
        return false;
    }
}

