/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.validation.validator;

import io.polaris.core.regex.Patterns;
import io.polaris.validation.Regexp;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class RegexpCollectionValidator
implements ConstraintValidator<Regexp, Collection<String>> {
    private String value;
    private int flags;
    private Pattern pattern;

    public void initialize(Regexp constraintAnnotation) {
        this.value = constraintAnnotation.value();
        this.flags = constraintAnnotation.flags();
        this.pattern = Patterns.getPattern((String)this.value, (int)this.flags);
    }

    public boolean isValid(Collection<String> value, ConstraintValidatorContext context) {
        if (value == null || value.isEmpty()) {
            return true;
        }
        for (String s : value) {
            if (this.pattern.matcher(s).find()) continue;
            return false;
        }
        return true;
    }
}

