/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.validation.validator;

import io.polaris.validation.LengthRange;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class LengthRangeArrayValidator
implements ConstraintValidator<LengthRange, String[]> {
    private int min;
    private int max;

    public void initialize(LengthRange constraintAnnotation) {
        this.min = constraintAnnotation.min();
        this.max = constraintAnnotation.max();
    }

    public boolean isValid(String[] value, ConstraintValidatorContext context) {
        if (value == null || value.length == 0) {
            return true;
        }
        for (String s : value) {
            if (s == null || s.length() <= this.max && s.length() >= this.min) continue;
            return false;
        }
        return true;
    }
}

