/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.mybatis.util;

import io.polaris.core.assertion.Arguments;
import io.polaris.core.string.Strings;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.WithItem;

public class SqlParsers {
    public static String visitSelect(String sql, Function<Collection<Table>, String> conditionAppender) throws JSQLParserException {
        return SqlParsers.visitSelect(sql, conditionAppender, null);
    }

    public static String visitSelect(String sql, BiFunction<Table, String, Boolean> columnFilter) throws JSQLParserException {
        return SqlParsers.visitSelect(sql, null, columnFilter);
    }

    public static String visitSelect(String sql, Function<Collection<Table>, String> conditionSupplier, BiFunction<Table, String, Boolean> columnFilter) throws JSQLParserException {
        Statement stmt = CCJSqlParserUtil.parse((String)sql);
        Select select = (Select)stmt;
        SelectBody selectBody = select.getSelectBody();
        SqlParsers.visit(selectBody, conditionSupplier, columnFilter);
        return select.toString();
    }

    private static void visit(SelectBody selectBody, Function<Collection<Table>, String> conditionSupplier, BiFunction<Table, String, Boolean> columnFilter) throws JSQLParserException {
        SetOperationList operationList;
        if (selectBody instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            SqlParsers.visit(plainSelect, conditionSupplier, columnFilter);
        } else if (selectBody instanceof WithItem) {
            WithItem withItem = (WithItem)selectBody;
            if (withItem.getSubSelect() != null) {
                SqlParsers.visit(withItem.getSubSelect().getSelectBody(), conditionSupplier, columnFilter);
            }
        } else if (selectBody instanceof SetOperationList && (operationList = (SetOperationList)selectBody).getSelects() != null && operationList.getSelects().size() > 0) {
            List plainSelects = operationList.getSelects();
            for (SelectBody plainSelect : plainSelects) {
                SqlParsers.visit(plainSelect, conditionSupplier, columnFilter);
            }
        }
    }

    private static void visit(PlainSelect plainSelect, Function<Collection<Table>, String> conditionSupplier, BiFunction<Table, String, Boolean> columnFilter) throws JSQLParserException {
        String conditionSql;
        LinkedHashMap<String, Table> tables = new LinkedHashMap<String, Table>();
        FromItem fromItem = plainSelect.getFromItem();
        SqlParsers.fetchTables(tables, fromItem);
        List joins = plainSelect.getJoins();
        if (joins != null) {
            for (Join join : joins) {
                FromItem item = join.getRightItem();
                SqlParsers.fetchTables(tables, item);
            }
        }
        if (conditionSupplier != null && (conditionSql = Strings.trimToNull((String)conditionSupplier.apply(tables.values()))) != null) {
            Expression condition = CCJSqlParserUtil.parseCondExpression((String)conditionSql);
            Expression where = plainSelect.getWhere();
            if (where == null) {
                plainSelect.setWhere(condition);
            } else {
                if (!(where instanceof Parenthesis)) {
                    where = new Parenthesis(where);
                }
                if (!(condition instanceof Parenthesis)) {
                    condition = new Parenthesis(condition);
                }
                AndExpression andExpression = new AndExpression(where, condition);
                plainSelect.setWhere((Expression)andExpression);
            }
        }
        if (columnFilter != null) {
            List selectItems = plainSelect.getSelectItems();
            Iterator iter = selectItems.iterator();
            while (iter.hasNext()) {
                SelectItem selectItem = (SelectItem)iter.next();
                if (selectItem instanceof SelectExpressionItem) {
                    Boolean filtered;
                    String tableAlias;
                    Table table;
                    Table colTable;
                    ((SelectExpressionItem)selectItem).getAlias();
                    Expression expression = ((SelectExpressionItem)selectItem).getExpression();
                    if (!(expression instanceof Column) || (colTable = ((Column)expression).getTable()) == null || (table = (Table)tables.get(tableAlias = colTable.getName())) == null || !Boolean.FALSE.equals(filtered = columnFilter.apply(table, ((Column)expression).getColumnName()))) continue;
                    iter.remove();
                    continue;
                }
                if (!(selectItem instanceof AllTableColumns) && !(selectItem instanceof AllColumns)) continue;
            }
        }
    }

    private static void fetchTables(Map<String, Table> tables, FromItem fromItem) {
        if (fromItem instanceof Table) {
            Alias alias = ((Table)fromItem).getAlias();
            if (alias != null) {
                tables.put(alias.getName(), (Table)fromItem);
            } else {
                tables.put(((Table)fromItem).getName(), (Table)fromItem);
            }
        }
    }

    public static class SelectColumn {
        private final Table table;
        private final String columnName;
        private boolean skip = false;

        SelectColumn(Table table, String columnName) {
            this.table = table;
            this.columnName = Strings.trimToNull((String)columnName);
            Arguments.notNull((Object)this.columnName, (String)"column name is required");
        }

        public void skip() {
            this.skip = true;
        }

        public boolean isSkip() {
            return this.skip;
        }

        public Table getTable() {
            return this.table;
        }

        public String getColumnName() {
            return this.columnName;
        }
    }
}

