/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.mybatis.type;

import io.polaris.core.converter.Converters;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Date;
import org.apache.ibatis.type.Alias;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappedTypes(value={Time.class})
@MappedJdbcTypes(value={JdbcType.DATE, JdbcType.TIMESTAMP, JdbcType.TIME}, includeNullJdbcType=true)
@Alias(value="dynamicTimeTypeHandler")
public class DynamicTimeTypeHandler
extends BaseTypeHandler<Object> {
    private static final Logger log = LoggerFactory.getLogger(DynamicTimeTypeHandler.class);

    public void setNonNullParameter(PreparedStatement ps, int i, Object parameter, JdbcType jdbcType) throws SQLException {
        if (parameter == null) {
            ps.setNull(i, 93);
            return;
        }
        if (parameter instanceof Time) {
            ps.setTime(i, (Time)parameter);
        } else if (parameter instanceof Date) {
            ps.setTime(i, new Time(((Date)parameter).getTime()));
        } else if (parameter instanceof Number) {
            ps.setTime(i, new Time(((Number)parameter).longValue()));
        } else {
            Date date = (Date)Converters.convert(Date.class, (Object)parameter);
            ps.setTime(i, new Time(date.getTime()));
        }
    }

    public Time getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Time sqlTime = rs.getTime(columnName);
        return sqlTime;
    }

    public Time getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Time sqlTime = rs.getTime(columnIndex);
        return sqlTime;
    }

    public Time getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Time sqlTime = cs.getTime(columnIndex);
        return sqlTime;
    }
}

