/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.mybatis.type;

import io.polaris.core.converter.Converters;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.apache.ibatis.type.Alias;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappedTypes(value={Date.class})
@MappedJdbcTypes(value={JdbcType.DATE, JdbcType.TIMESTAMP, JdbcType.TIME}, includeNullJdbcType=true)
@Alias(value="dynamicDateTypeHandler")
public class DynamicDateTypeHandler
extends BaseTypeHandler<Object> {
    private static final Logger log = LoggerFactory.getLogger(DynamicDateTypeHandler.class);

    public void setNonNullParameter(PreparedStatement ps, int i, Object parameter, JdbcType jdbcType) throws SQLException {
        if (parameter == null) {
            ps.setNull(i, 93);
            return;
        }
        if (parameter instanceof Date) {
            ps.setDate(i, new java.sql.Date(((Date)parameter).getTime()));
        } else if (parameter instanceof Date) {
            ps.setDate(i, new java.sql.Date(((Date)parameter).getTime()));
        } else if (parameter instanceof Number) {
            ps.setDate(i, new java.sql.Date(((Number)parameter).longValue()));
        } else {
            Date date = (Date)Converters.convert(Date.class, (Object)parameter);
            ps.setDate(i, new java.sql.Date(date.getTime()));
        }
    }

    public Date getNullableResult(ResultSet rs, String columnName) throws SQLException {
        java.sql.Date date = rs.getDate(columnName);
        return date;
    }

    public Date getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return rs.getDate(columnIndex);
    }

    public Date getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return cs.getDate(columnIndex);
    }
}

