/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.mybatis.type;

import io.polaris.core.string.Strings;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.Alias;
import org.apache.ibatis.type.EnumTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="blankableEnumTypeHandler")
public class BlankableEnumTypeHandler<E extends Enum<E>>
extends EnumTypeHandler<E> {
    private static final Logger log = LoggerFactory.getLogger(BlankableEnumTypeHandler.class);
    private final Class<E> type;

    public BlankableEnumTypeHandler(Class<E> type) {
        super(type);
        this.type = type;
    }

    private E toEnum(String s) {
        try {
            s = Strings.trimToNull((String)s);
            return s == null ? null : (E)Enum.valueOf(this.type, s);
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setNonNullParameter(PreparedStatement ps, int i, E parameter, JdbcType jdbcType) throws SQLException {
        String name = parameter.getClass().isEnum() ? ((Enum)parameter).name() : ((Enum)parameter).toString();
        if (jdbcType == null) {
            ps.setString(i, name);
        } else {
            ps.setObject(i, (Object)name, jdbcType.TYPE_CODE);
        }
    }

    public E getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String s = rs.getString(columnName);
        return this.toEnum(s);
    }

    public E getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String s = rs.getString(columnIndex);
        return this.toEnum(s);
    }

    public E getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String s = cs.getString(columnIndex);
        return this.toEnum(s);
    }
}

