/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.mybatis.scripting;

import io.polaris.core.jdbc.sql.SqlTextParsers;
import java.util.List;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.scripting.xmltags.XMLLanguageDriver;
import org.apache.ibatis.session.Configuration;

public class TableRefResolvableDriver
extends XMLLanguageDriver {
    public SqlSource createSqlSource(Configuration configuration, XNode script, Class<?> parameterType) {
        SqlSource sqlSource = super.createSqlSource(configuration, script, parameterType);
        return new TableRefResolvableSqlSource(configuration, sqlSource);
    }

    public SqlSource createSqlSource(Configuration configuration, String script, Class<?> parameterType) {
        SqlSource sqlSource = super.createSqlSource(configuration, script, parameterType);
        return new TableRefResolvableSqlSource(configuration, sqlSource);
    }

    static class DelegateBoundSql
    extends BoundSql {
        private final BoundSql raw;
        private final String sql;

        public DelegateBoundSql(Configuration configuration, BoundSql raw) {
            super(configuration, raw.getSql(), raw.getParameterMappings(), raw.getParameterObject());
            String sql = raw.getSql();
            sql = SqlTextParsers.resolveTableRef((String)sql);
            this.raw = raw;
            this.sql = sql;
        }

        public String getSql() {
            return this.sql;
        }

        public List<ParameterMapping> getParameterMappings() {
            return this.raw.getParameterMappings();
        }

        public Object getParameterObject() {
            return this.raw.getParameterObject();
        }

        public boolean hasAdditionalParameter(String name) {
            return this.raw.hasAdditionalParameter(name);
        }

        public void setAdditionalParameter(String name, Object value) {
            this.raw.setAdditionalParameter(name, value);
        }

        public Object getAdditionalParameter(String name) {
            return this.raw.getAdditionalParameter(name);
        }
    }

    static class TableRefResolvableSqlSource
    implements SqlSource {
        private final Configuration configuration;
        private final SqlSource sqlSource;

        public TableRefResolvableSqlSource(Configuration configuration, SqlSource sqlSource) {
            this.configuration = configuration;
            this.sqlSource = sqlSource;
        }

        public BoundSql getBoundSql(Object parameterObject) {
            BoundSql boundSql = this.sqlSource.getBoundSql(parameterObject);
            return new DelegateBoundSql(this.configuration, boundSql);
        }
    }
}

