/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.mybatis.provider;

import io.polaris.core.annotation.Published;
import io.polaris.core.jdbc.sql.BindingValues;
import io.polaris.core.jdbc.sql.statement.SqlNodeBuilder;
import io.polaris.core.jdbc.sql.statement.UpdateStatement;
import io.polaris.mybatis.consts.MappingKeys;
import io.polaris.mybatis.provider.BaseProviderMethodResolver;
import java.util.Map;
import org.apache.ibatis.builder.annotation.ProviderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlUpdateProvider
extends BaseProviderMethodResolver {
    private static final Logger log = LoggerFactory.getLogger(SqlUpdateProvider.class);

    @Published
    public static String provideSql(Object parameterObject, ProviderContext context) {
        return SqlUpdateProvider.provideSql(parameterObject, context, (map, ctx) -> {
            UpdateStatement st = (UpdateStatement)map.get("_u");
            if (st == null) {
                st = (UpdateStatement)map.get("_sql");
            }
            String sql = BindingValues.asSqlWithBindings(MappingKeys.PARAMETER_MAPPING_KEYS_FILTER, (Map)map, (SqlNodeBuilder)st);
            if (log.isDebugEnabled()) {
                log.debug("<sql>\n{}\n<bindings>\n{}", (Object)sql, map);
            }
            return sql;
        });
    }
}

