/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.mybatis.provider;

import io.polaris.core.annotation.Published;
import io.polaris.core.jdbc.sql.BindingValues;
import io.polaris.core.jdbc.sql.statement.SelectStatement;
import io.polaris.mybatis.consts.MappingKeys;
import io.polaris.mybatis.provider.BaseProviderMethodResolver;
import java.util.Map;
import org.apache.ibatis.builder.annotation.ProviderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlCountProvider
extends BaseProviderMethodResolver {
    private static final Logger log = LoggerFactory.getLogger(SqlCountProvider.class);

    @Published
    public static String provideSql(Object parameterObject, ProviderContext context) {
        return SqlCountProvider.provideSql(parameterObject, context, (map, ctx) -> {
            SelectStatement st = (SelectStatement)map.get("_r");
            if (st == null) {
                st = (SelectStatement)map.get("_sql");
            }
            String sql = BindingValues.asSqlWithBindings(MappingKeys.PARAMETER_MAPPING_KEYS_FILTER, (Map)map, () -> ((SelectStatement)st).toCountSqlNode());
            if (log.isDebugEnabled()) {
                log.debug("<sql>\n{}\n<bindings>\n{}", (Object)sql, map);
            }
            return sql;
        });
    }
}

