/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.mybatis.mapper;

import io.polaris.core.annotation.Internal;
import io.polaris.core.io.IO;
import io.polaris.core.jdbc.sql.query.Criteria;
import io.polaris.core.jdbc.sql.query.OrderBy;
import io.polaris.core.jdbc.sql.statement.SelectStatement;
import io.polaris.mybatis.annotation.DynamicResultMapping;
import io.polaris.mybatis.provider.EntityExistsByAnyProvider;
import io.polaris.mybatis.provider.MapperProviders;
import io.polaris.mybatis.provider.SqlExistsProvider;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Options;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.cursor.Cursor;

public interface SelectStatementMapper<R> {
    @SelectProvider(type=MapperProviders.class, method="existsBySql")
    @Options(fetchSize=1)
    @Internal(value={"\u8003\u8651\u5230\u67e5\u8be2\u6027\u80fd\u4e0e\u5206\u9875\u5b9e\u73b0\u7684\u517c\u5bb9\u6027\uff0c\u58f0\u660e\u6b64\u6b64\u65b9\u6cd5\uff0c\u5b9e\u9645\u5f00\u53d1\u4e2d\u4e0d\u76f4\u63a5\u8c03\u7528"})
    public Cursor<Boolean> existsInnerBySql(@Param(value="_r") SelectStatement<?> var1);

    @SelectProvider(type=MapperProviders.class, method="countBySql")
    public int countBySql(@Param(value="_r") SelectStatement<?> var1);

    @DynamicResultMapping
    @SelectProvider(type=MapperProviders.class, method="selectBySql")
    public List<R> selectEntityListBySql(@Param(value="_r") SelectStatement<?> var1);

    @DynamicResultMapping
    @SelectProvider(type=MapperProviders.class, method="selectBySql")
    public List<Map<String, Object>> selectMapListBySql(@Param(value="_r") SelectStatement<?> var1);

    @DynamicResultMapping
    @SelectProvider(type=MapperProviders.class, method="selectBySql")
    public R selectEntityBySql(@Param(value="_r") SelectStatement<?> var1);

    @DynamicResultMapping
    @SelectProvider(type=MapperProviders.class, method="selectBySql")
    public Map<String, Object> selectMapBySql(@Param(value="_r") SelectStatement<?> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean existsBySql(SelectStatement<?> statement) {
        SqlExistsProvider.setQueryExistsByCount(false);
        Cursor<Boolean> cursor = null;
        try {
            cursor = this.existsInnerBySql(statement);
            Iterator iter = cursor.iterator();
            if (iter.hasNext()) {
                Boolean next = (Boolean)iter.next();
                boolean bl = Boolean.TRUE.equals(next);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            EntityExistsByAnyProvider.clearQueryExistsByCount();
            IO.close(cursor);
        }
    }

    default public boolean existsBySql(SelectStatement<?> statement, Criteria criteria) {
        if (criteria != null) {
            statement.where(criteria);
        }
        return this.existsBySql(statement);
    }

    default public int countBySql(SelectStatement<?> statement, Criteria criteria, OrderBy orderBy) {
        if (criteria != null) {
            statement.where(criteria);
        }
        if (orderBy != null) {
            statement.orderBy(orderBy);
        }
        return this.countBySql(statement);
    }

    default public List<R> selectEntityListBySql(SelectStatement<?> statement, Criteria criteria, OrderBy orderBy) {
        if (criteria != null) {
            statement.where(criteria);
        }
        if (orderBy != null) {
            statement.orderBy(orderBy);
        }
        return this.selectEntityListBySql(statement);
    }

    default public R selectEntityBySql(SelectStatement<?> statement, Criteria criteria, OrderBy orderBy) {
        if (criteria != null) {
            statement.where(criteria);
        }
        if (orderBy != null) {
            statement.orderBy(orderBy);
        }
        return this.selectEntityBySql(statement);
    }

    default public List<Map<String, Object>> selectMapListBySql(SelectStatement<?> statement, Criteria criteria, OrderBy orderBy) {
        if (criteria != null) {
            statement.where(criteria);
        }
        if (orderBy != null) {
            statement.orderBy(orderBy);
        }
        return this.selectMapListBySql(statement);
    }

    default public Map<String, Object> selectMapBySql(SelectStatement<?> statement, Criteria criteria, OrderBy orderBy) {
        if (criteria != null) {
            statement.where(criteria);
        }
        if (orderBy != null) {
            statement.orderBy(orderBy);
        }
        return this.selectMapBySql(statement);
    }
}

