/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.mybatis.interceptor;

import io.polaris.core.collection.Lists;
import io.polaris.core.jdbc.ColumnMeta;
import io.polaris.core.string.Strings;
import io.polaris.core.tuple.Ref;
import io.polaris.core.tuple.Tuple2;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementBuilder
extends MappedStatement.Builder {
    private static final Logger log = LoggerFactory.getLogger(StatementBuilder.class);
    public static final String RESOURCE_MARK = "|Generated";
    private final String id;
    private final Configuration configuration;
    private final MappedStatement statement;
    private final TypeHandlerRegistry typeHandlerRegistry;
    private static final List<Tuple2<Configuration, Map<Tuple2<Class<?>, Class<? extends TypeHandler<?>>>, Ref<TypeHandler<?>>>>> typeHandlerCache = new CopyOnWriteArrayList();

    public StatementBuilder(MappedStatement statement) {
        super(statement.getConfiguration(), statement.getId(), statement.getSqlSource(), statement.getSqlCommandType());
        this.id = statement.getId();
        this.statement = statement;
        this.configuration = statement.getConfiguration();
        this.typeHandlerRegistry = this.configuration.getTypeHandlerRegistry();
        this.resource(statement.getResource()).fetchSize(statement.getFetchSize()).timeout(statement.getTimeout()).statementType(statement.getStatementType()).keyGenerator(statement.getKeyGenerator()).keyProperty(this.joining(statement.getKeyProperties())).keyColumn(this.joining(statement.getKeyColumns())).databaseId(statement.getDatabaseId()).lang(statement.getLang()).resultOrdered(statement.isResultOrdered()).resultSets(this.joining(statement.getResultSets())).resultMaps(statement.getResultMaps()).resultSetType(statement.getResultSetType()).flushCacheRequired(statement.isFlushCacheRequired()).useCache(statement.isUseCache()).parameterMap(statement.getParameterMap()).cache(statement.getCache());
    }

    private String joining(String[] arr) {
        return arr == null ? null : String.join((CharSequence)",", arr);
    }

    public MappedStatement build() {
        this.resource(this.statement.getResource() + RESOURCE_MARK);
        return super.build();
    }

    public StatementBuilder useGeneratedKeys(List<ColumnMeta> columns, String prefix) {
        StringJoiner keyProperty = new StringJoiner(",");
        StringJoiner keyColumn = new StringJoiner(",");
        for (ColumnMeta column : columns) {
            String columnName = column.getColumnName();
            String fieldName = column.getFieldName();
            keyColumn.add(columnName);
            if (Strings.isBlank((CharSequence)prefix)) {
                keyProperty.add(fieldName);
                continue;
            }
            keyProperty.add(prefix + "." + fieldName);
        }
        this.keyProperty(keyProperty.toString());
        this.keyColumn(keyColumn.toString());
        this.keyGenerator((KeyGenerator)Jdbc3KeyGenerator.INSTANCE);
        return this;
    }

    public StatementBuilder useResultMappings(Class<?> resultType, List<ResultMapping> resultMappings) {
        List originalResultMaps = this.statement.getResultMaps();
        if (originalResultMaps != null && !originalResultMaps.isEmpty()) {
            ResultMap originalResultMap = (ResultMap)originalResultMaps.get(0);
            ArrayList<ResultMapping> filteredMappings = new ArrayList<ResultMapping>(originalResultMap.getResultMappings());
            if (!filteredMappings.isEmpty()) {
                return this;
            }
            HashSet<String> propertySet = new HashSet<String>();
            StatementBuilder.addPropertySet(originalResultMap.getResultMappings(), propertySet);
            for (ResultMapping mapping : resultMappings) {
                String property = mapping.getProperty();
                if (property != null && propertySet.contains(property)) continue;
                filteredMappings.add(mapping);
            }
            ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>(originalResultMaps);
            ResultMap resultMap = new ResultMap.Builder(this.configuration, originalResultMap.getId() + RESOURCE_MARK, resultType, filteredMappings, originalResultMap.getAutoMapping()).build();
            resultMaps.set(0, resultMap);
            this.resultMaps(resultMaps);
        } else {
            String id = this.id + "__ResultMap" + RESOURCE_MARK;
            ResultMap resultMap = new ResultMap.Builder(this.configuration, id, resultType, resultMappings, null).build();
            this.resultMaps(Lists.asList((Object[])new ResultMap[]{resultMap}));
        }
        return this;
    }

    private static void addPropertySet(List<ResultMapping> list, Set<String> propertySet) {
        if (list != null && !list.isEmpty()) {
            for (ResultMapping mapping : list) {
                String property = mapping.getProperty();
                if (property == null) continue;
                propertySet.add(property);
            }
        }
    }

    public TypeHandler<?> resolveTypeHandler(Class<?> javaType, Class<? extends TypeHandler<?>> typeHandlerType) {
        if (typeHandlerType == null) {
            return null;
        }
        Map<Tuple2<Class<?>, Class<TypeHandler<?>>>, Ref<TypeHandler<?>>> cache = StatementBuilder.getTypeHandlerCache(this.configuration);
        Ref ref = cache.computeIfAbsent(Tuple2.of(javaType, typeHandlerType), k -> {
            try {
                TypeHandler handler = this.typeHandlerRegistry.getInstance(javaType, typeHandlerType);
                return Ref.of((Object)handler);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                return Ref.of(null);
            }
        });
        if (ref != null) {
            return (TypeHandler)ref.get();
        }
        TypeHandler handler = this.typeHandlerRegistry.getMappingTypeHandler(typeHandlerType);
        if (handler == null) {
            handler = this.typeHandlerRegistry.getInstance(javaType, typeHandlerType);
        }
        return handler;
    }

    private static Map<Tuple2<Class<?>, Class<? extends TypeHandler<?>>>, Ref<TypeHandler<?>>> getTypeHandlerCache(Configuration configuration) {
        for (Tuple2<Configuration, Map<Tuple2<Class<?>, Class<? extends TypeHandler<?>>>, Ref<TypeHandler<?>>>> tuple2 : typeHandlerCache) {
            if (tuple2.getFirst() != configuration) continue;
            return (Map)tuple2.getSecond();
        }
        ConcurrentHashMap cache = new ConcurrentHashMap();
        typeHandlerCache.add(Tuple2.of((Object)configuration, cache));
        return cache;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

