/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.mybatis.interceptor;

import io.polaris.core.collection.Lists;
import io.polaris.core.jdbc.ColumnMeta;
import io.polaris.core.jdbc.TableMeta;
import io.polaris.core.jdbc.TableMetaKit;
import io.polaris.core.lang.JavaType;
import io.polaris.core.lang.Types;
import io.polaris.core.reflect.Reflects;
import io.polaris.core.string.Strings;
import io.polaris.mybatis.annotation.DynamicResultMapping;
import io.polaris.mybatis.annotation.DynamicUseGeneratedKeys;
import io.polaris.mybatis.annotation.MapperEntity;
import io.polaris.mybatis.consts.MappingKeys;
import io.polaris.mybatis.interceptor.StatementBuilder;
import io.polaris.mybatis.mapper.EntityMapper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class DynamicResultMappingInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(DynamicResultMappingInterceptor.class);
    private final Map<String, Meta> cache = new ConcurrentHashMap<String, Meta>();

    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        if (mappedStatement.getSqlCommandType() == SqlCommandType.SELECT) {
            Meta meta;
            List resultMappingMetas;
            String statementId = mappedStatement.getId();
            String resource = mappedStatement.getResource();
            if (!(resource != null && resource.contains("|Generated") || (resultMappingMetas = (meta = this.cache.computeIfAbsent(statementId, k -> this.buildMeta(statementId))).resultMappings) == null)) {
                MappedStatement newer;
                if (meta.lastStatement == mappedStatement) {
                    newer = meta.newerStatement;
                } else {
                    StatementBuilder statementBuilder = new StatementBuilder(mappedStatement);
                    ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
                    for (ResultMappingMeta resultMappingMeta : resultMappingMetas) {
                        ResultMapping.Builder builder = new ResultMapping.Builder(statementBuilder.getConfiguration(), resultMappingMeta.property);
                        if (resultMappingMeta.typeHandler != null) {
                            builder.typeHandler(resultMappingMeta.typeHandler);
                        } else if (resultMappingMeta.typeHandlerClass != null) {
                            TypeHandler<?> typeHandler = statementBuilder.resolveTypeHandler(resultMappingMeta.javaType, resultMappingMeta.typeHandlerClass);
                            resultMappingMeta.typeHandler = typeHandler;
                            builder.typeHandler(typeHandler);
                        }
                        if (resultMappingMeta.column != null) {
                            builder.column(resultMappingMeta.column);
                        }
                        if (resultMappingMeta.javaType != null) {
                            builder.javaType(resultMappingMeta.javaType);
                        }
                        if (resultMappingMeta.jdbcType != null) {
                            builder.jdbcType(resultMappingMeta.jdbcType);
                        }
                        if (resultMappingMeta.columnPrefix != null) {
                            builder.columnPrefix(resultMappingMeta.columnPrefix);
                        }
                        if (resultMappingMeta.flags != null) {
                            builder.flags(resultMappingMeta.flags);
                        }
                        resultMappings.add(builder.build());
                    }
                    statementBuilder.useResultMappings(meta.resultJavaType, resultMappings);
                    newer = statementBuilder.build();
                    meta.lastStatement = mappedStatement;
                    meta.newerStatement = newer;
                }
                invocation.getArgs()[0] = newer;
            }
        } else if (mappedStatement.getSqlCommandType() == SqlCommandType.INSERT) {
            Meta meta;
            String resource;
            String statementId = mappedStatement.getId();
            KeyGenerator keyGenerator = mappedStatement.getKeyGenerator();
            if (keyGenerator instanceof NoKeyGenerator && ((resource = mappedStatement.getResource()) == null || !resource.contains("|Generated")) && (meta = this.cache.computeIfAbsent(statementId, k -> this.buildMeta(statementId))).autoColumns != null) {
                MappedStatement newer;
                if (meta.lastStatement == mappedStatement) {
                    newer = meta.newerStatement;
                } else {
                    StatementBuilder statementBuilder = new StatementBuilder(mappedStatement);
                    statementBuilder.useGeneratedKeys(meta.autoColumns, Strings.trimToNull((String)meta.autoColumnPrefix));
                    newer = statementBuilder.build();
                    meta.lastStatement = mappedStatement;
                    meta.newerStatement = newer;
                }
                invocation.getArgs()[0] = newer;
            }
        }
        return invocation.proceed();
    }

    @Nonnull
    private Meta buildMeta(String statementId) {
        try {
            List methods;
            int idx = statementId.lastIndexOf(".");
            String mapperClassName = statementId.substring(0, idx);
            String mapperMethodName = statementId.substring(idx + 1);
            Class<?> mapperClass = Class.forName(mapperClassName);
            if (mapperClass.isInterface() && (methods = Reflects.getPublicMethods(mapperClass, m -> !m.isDefault() && !Modifier.isStatic(m.getModifiers()) && mapperMethodName.equals(m.getName()) && (m.isAnnotationPresent(DynamicUseGeneratedKeys.class) || m.isAnnotationPresent(DynamicResultMapping.class)))).size() == 1) {
                Method method = (Method)methods.get(0);
                Class<?> declaredEntityClass = null;
                DynamicUseGeneratedKeys dynamicUseGeneratedKeys = method.getAnnotation(DynamicUseGeneratedKeys.class);
                String autoColumnPrefix = "";
                List autoColumns = null;
                if (dynamicUseGeneratedKeys != null) {
                    TableMeta tableMeta;
                    autoColumnPrefix = dynamicUseGeneratedKeys.value();
                    Class<?> entityClass = dynamicUseGeneratedKeys.entity();
                    if (entityClass == Void.TYPE) {
                        declaredEntityClass = this.findDeclaredEntityClass(method, mapperClass);
                        entityClass = declaredEntityClass;
                    }
                    if ((autoColumns = (tableMeta = TableMetaKit.instance().get(entityClass)).getColumns().values().stream().filter(columnMeta -> columnMeta.isPrimaryKey() && (columnMeta.isAutoIncrement() || Strings.isNotBlank((CharSequence)columnMeta.getSeqName()) || Strings.isNotBlank((CharSequence)columnMeta.getIdSql()))).collect(Collectors.toList())).isEmpty()) {
                        autoColumns = null;
                    }
                }
                DynamicResultMapping dynamicResultMapping = method.getAnnotation(DynamicResultMapping.class);
                ArrayList<ResultMappingMeta> resultMappings = null;
                Class<?> resultJavaType = null;
                if (dynamicResultMapping != null) {
                    resultJavaType = dynamicResultMapping.entity();
                    if (resultJavaType == Void.TYPE) {
                        resultJavaType = declaredEntityClass != null ? declaredEntityClass : this.findDeclaredEntityClass(method, mapperClass);
                    }
                    boolean useColumnName = dynamicResultMapping.useColumnName();
                    String columnPrefix = dynamicResultMapping.columnPrefix();
                    TableMeta tableMeta = TableMetaKit.instance().get(resultJavaType);
                    resultMappings = new ArrayList<ResultMappingMeta>();
                    ArrayList<ColumnMeta> idCols = new ArrayList<ColumnMeta>();
                    for (ColumnMeta col : tableMeta.getColumns().values()) {
                        boolean match = col.hasProperties(MappingKeys.RESULT_MAPPING_KEYS_FILTER);
                        if (match) {
                            try {
                                String jdbcType;
                                Class<?> clazz;
                                ResultMappingMeta resultMappingMeta = new ResultMappingMeta();
                                String typeHandler = col.getProp("typeHandler");
                                if (Strings.isNotBlank((CharSequence)typeHandler) && TypeHandler.class.isAssignableFrom(clazz = Class.forName(typeHandler))) {
                                    resultMappingMeta.typeHandlerClass = clazz;
                                }
                                if (Strings.isNotBlank((CharSequence)(jdbcType = col.getProp("jdbcType")))) {
                                    resultMappingMeta.jdbcType = JdbcType.valueOf((String)jdbcType);
                                }
                                resultMappingMeta.property = col.getFieldName();
                                resultMappingMeta.column = useColumnName ? col.getColumnName() : col.getFieldName();
                                resultMappingMeta.javaType = col.getFieldType();
                                resultMappingMeta.columnPrefix = Strings.trimToNull((String)columnPrefix);
                                if (col.isPrimaryKey()) {
                                    resultMappingMeta.flags = Lists.asList((Object[])new ResultFlag[]{ResultFlag.ID});
                                }
                                resultMappings.add(resultMappingMeta);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        if (!col.isPrimaryKey()) continue;
                        idCols.add(col);
                    }
                    if (resultMappings.isEmpty()) {
                        resultMappings = null;
                    } else if (idCols.size() > 0) {
                        for (ColumnMeta col : idCols) {
                            ResultMappingMeta resultMappingMeta = new ResultMappingMeta();
                            resultMappingMeta.property = col.getFieldName();
                            resultMappingMeta.column = useColumnName ? col.getColumnName() : col.getFieldName();
                            resultMappingMeta.javaType = col.getFieldType();
                            resultMappingMeta.columnPrefix = Strings.trimToNull((String)columnPrefix);
                            if (col.isPrimaryKey()) {
                                resultMappingMeta.flags = Lists.asList((Object[])new ResultFlag[]{ResultFlag.ID});
                            }
                            resultMappings.add(resultMappingMeta);
                        }
                    }
                }
                return new Meta(autoColumns, autoColumnPrefix, resultMappings, resultJavaType);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return new Meta(null, null, null, null);
    }

    protected Class<?> findDeclaredEntityClass(Method mapperMethod, Class<?> mapperType) {
        Class entityClass = null;
        MapperEntity declared = mapperMethod.getAnnotation(MapperEntity.class);
        if (declared != null && (entityClass = declared.entity()) != null && entityClass != Object.class) {
            return entityClass;
        }
        declared = mapperType.getAnnotation(MapperEntity.class);
        if (declared != null && (entityClass = declared.entity()) != null && entityClass != Object.class) {
            return entityClass;
        }
        Class<?> declaringClass = mapperMethod.getDeclaringClass();
        if (declaringClass != mapperType && (declared = declaringClass.getAnnotation(MapperEntity.class)) != null && (entityClass = declared.entity()) != null && entityClass != Object.class) {
            return entityClass;
        }
        if (EntityMapper.class.isAssignableFrom(mapperType)) {
            Type actualType = JavaType.of(mapperType).getActualType(EntityMapper.class, 0);
            entityClass = Types.getClass((Type)actualType);
        }
        if (entityClass == null || entityClass == Object.class) {
            throw new IllegalStateException("\u672a\u77e5\u5b9e\u4f53\u7c7b\u578b\uff01");
        }
        return entityClass;
    }

    private MappedStatement cloneMappedStatement(MappedStatement ms, boolean useGeneratedKeys) {
        return null;
    }

    public Object plugin(Object target) {
        return super.plugin(target);
    }

    public void setProperties(Properties properties) {
    }

    private static class ResultMappingMeta {
        private String property;
        private String column;
        private Class<?> javaType;
        private JdbcType jdbcType;
        private Class<? extends TypeHandler<?>> typeHandlerClass;
        private TypeHandler<?> typeHandler;
        private String columnPrefix;
        public List<ResultFlag> flags;

        private ResultMappingMeta() {
        }
    }

    private static class Meta {
        private final List<ColumnMeta> autoColumns;
        private final String autoColumnPrefix;
        private final List<ResultMappingMeta> resultMappings;
        private final Class<?> resultJavaType;
        private MappedStatement lastStatement;
        private MappedStatement newerStatement;

        public Meta(List<ColumnMeta> autoColumns, String autoColumnPrefix, List<ResultMappingMeta> resultMappings, Class<?> resultJavaType) {
            this.autoColumns = autoColumns;
            this.autoColumnPrefix = autoColumnPrefix;
            this.resultMappings = resultMappings;
            this.resultJavaType = resultJavaType;
        }
    }
}

