/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.mybatis.util;

import com.github.pagehelper.ISelect;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import io.polaris.core.jdbc.sql.query.Pageable;
import java.util.List;
import java.util.function.Supplier;

public class Pages {
    static boolean hasPageHelper;

    public static boolean hasPageHelper() {
        return hasPageHelper;
    }

    public static <E> List<E> doPageQuery(Pageable pageable, Supplier<List<E>> select) {
        if (pageable == null || !hasPageHelper) {
            return select.get();
        }
        try (Page data = PageHelper.startPage((int)pageable.getPageNum(), (int)pageable.getPageSize(), (boolean)true).doSelectPage(select::get);){
            pageable.setTotal((int)data.getTotal());
            Page page = data;
            return page;
        }
    }

    public static <E> List<E> doPageQueryWithoutCount(Pageable pageable, Supplier<List<E>> select) {
        if (pageable == null || !hasPageHelper) {
            return select.get();
        }
        return PageHelper.startPage((int)pageable.getPageNum(), (int)pageable.getPageSize(), (boolean)false).doSelectPage(select::get);
    }

    public static long doPageCount(Pageable pageable, ISelect select) {
        if (!hasPageHelper) {
            return -1L;
        }
        return PageHelper.startPage((int)pageable.getPageNum(), (int)pageable.getPageSize(), (boolean)false).doCount(select);
    }

    static {
        try {
            PageHelper.class.getName();
            hasPageHelper = true;
        }
        catch (Throwable e) {
            hasPageHelper = false;
        }
    }
}

