/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.mybatis.type;

import io.polaris.core.converter.Converters;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappedTypes(value={Timestamp.class})
@MappedJdbcTypes(value={JdbcType.DATE, JdbcType.TIMESTAMP})
public class DynamicTimestampTypeHandler
extends BaseTypeHandler<Object> {
    private static final Logger log = LoggerFactory.getLogger(DynamicTimestampTypeHandler.class);

    public void setNonNullParameter(PreparedStatement ps, int i, Object parameter, JdbcType jdbcType) throws SQLException {
        if (parameter == null) {
            ps.setNull(i, 93);
            return;
        }
        if (parameter instanceof Timestamp) {
            ps.setTimestamp(i, (Timestamp)parameter);
        } else if (parameter instanceof Date) {
            ps.setTimestamp(i, new Timestamp(((Date)parameter).getTime()));
        } else if (parameter instanceof Number) {
            ps.setTimestamp(i, new Timestamp(((Number)parameter).longValue()));
        } else {
            Date date = (Date)Converters.convert(Date.class, (Object)parameter);
            ps.setTimestamp(i, new Timestamp(date.getTime()));
        }
    }

    public Timestamp getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Timestamp sqlTimestamp = rs.getTimestamp(columnName);
        return sqlTimestamp;
    }

    public Timestamp getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Timestamp sqlTimestamp = rs.getTimestamp(columnIndex);
        return sqlTimestamp;
    }

    public Timestamp getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Timestamp sqlTimestamp = cs.getTimestamp(columnIndex);
        return sqlTimestamp;
    }
}

