/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.mybatis.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.Alias;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="dynamicEnumOrdinalTypeHandler")
public class DynamicEnumOrdinalTypeHandler<E extends Enum<E>>
extends BaseTypeHandler<Object> {
    private static final Logger log = LoggerFactory.getLogger(DynamicEnumOrdinalTypeHandler.class);
    private final Class<E> type;
    private final E[] enums;

    public DynamicEnumOrdinalTypeHandler(Class<E> type) {
        this.type = type;
        this.enums = (Enum[])type.getEnumConstants();
        if (this.enums == null) {
            throw new IllegalArgumentException(type.getSimpleName() + " does not represent an enum type.");
        }
    }

    private E toEnum(int i) {
        try {
            return this.enums[i];
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setNonNullParameter(PreparedStatement ps, int i, Object parameter, JdbcType jdbcType) throws SQLException {
        int ordinal = -1;
        if (parameter != null && parameter.getClass().isEnum()) {
            ordinal = ((Enum)parameter).ordinal();
        }
        if (ordinal >= 0) {
            ps.setInt(i, ordinal);
        } else if (jdbcType == null) {
            ps.setNull(i, 12);
        } else {
            ps.setNull(i, jdbcType.TYPE_CODE);
        }
    }

    public E getNullableResult(ResultSet rs, String columnName) throws SQLException {
        int i = rs.getInt(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return this.toEnum(i);
    }

    public E getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        int i = rs.getInt(columnIndex);
        if (rs.wasNull()) {
            return null;
        }
        return this.toEnum(i);
    }

    public E getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        int i = cs.getInt(columnIndex);
        if (cs.wasNull()) {
            return null;
        }
        return this.toEnum(i);
    }
}

