/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.mybatis.type;

import java.lang.reflect.Array;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.apache.ibatis.type.Alias;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="dynamicBooleanTypeHandler")
public class DynamicBooleanTypeHandler
extends BaseTypeHandler<Object> {
    private static final Logger log = LoggerFactory.getLogger(DynamicBooleanTypeHandler.class);

    public void setNonNullParameter(PreparedStatement ps, int i, Object parameter, JdbcType jdbcType) throws SQLException {
        Boolean val = null;
        if (parameter != null) {
            if (parameter instanceof Boolean) {
                val = (Boolean)parameter;
            } else if (parameter instanceof String) {
                String s = (String)parameter;
                val = "true".equalsIgnoreCase(s) || "1".equalsIgnoreCase(s) || "yes".equalsIgnoreCase(s);
            } else if (parameter instanceof Number) {
                val = ((Number)parameter).intValue() != 0;
            } else if (parameter instanceof Collection) {
                val = ((Collection)parameter).size() > 0;
            } else if (parameter instanceof Map) {
                val = ((Map)parameter).size() > 0;
            } else if (parameter.getClass().isArray()) {
                val = Array.getLength(parameter) > 0;
            }
        }
        if (val == null) {
            ps.setNull(i, 12);
        } else {
            ps.setBoolean(i, val);
        }
    }

    public void setNonNullParameter(PreparedStatement ps, int i, Boolean parameter, JdbcType jdbcType) throws SQLException {
        ps.setBoolean(i, parameter);
    }

    public Boolean getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return rs.getBoolean(columnName);
    }

    public Boolean getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return rs.getBoolean(columnIndex);
    }

    public Boolean getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return cs.getBoolean(columnIndex);
    }
}

