/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.mybatis.provider;

import io.polaris.core.annotation.Published;
import io.polaris.core.jdbc.sql.BindingValues;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.jdbc.sql.statement.SelectStatement;
import io.polaris.mybatis.provider.BaseProviderMethodResolver;
import java.util.Map;
import org.apache.ibatis.builder.annotation.ProviderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlExistsProvider
extends BaseProviderMethodResolver {
    private static final Logger log = LoggerFactory.getLogger(SqlExistsProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Published
    public static String provideSql(Object parameterObject, ProviderContext context) {
        boolean queryByCount = SqlExistsProvider.isQueryExistsByCount();
        try {
            String string = SqlExistsProvider.provideSql(parameterObject, context, (map, ctx) -> {
                SelectStatement st = (SelectStatement)map.get("_r");
                if (st == null) {
                    st = (SelectStatement)map.get("_sql");
                }
                SqlNode sqlNode = st.toExistsSqlNode(queryByCount);
                String sql = BindingValues.asSqlWithBindings((Map)map, (SqlNode)sqlNode);
                if (log.isDebugEnabled()) {
                    log.debug("<sql>\n{}\n<bindings>\n{}", (Object)sql, map);
                }
                return sql;
            });
            return string;
        }
        finally {
            SqlExistsProvider.clearQueryExistsByCount();
        }
    }
}

