/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.mybatis.interceptor;

import io.polaris.mybatis.interceptor.PageProvider;
import io.polaris.mybatis.interceptor.PageProviders;
import java.util.function.Supplier;

public class PageSafeExecutor {
    public static void execSafely(Runnable task) {
        PageProvider<?> provider = PageProviders.getProvider();
        if (provider == null) {
            task.run();
        } else {
            Object page = provider.getCtxPage();
            try {
                provider.clearCtxPage();
                task.run();
            }
            finally {
                if (page != null) {
                    provider.setCtxPage(page);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V execSafely(Supplier<V> task) {
        PageProvider<?> provider = PageProviders.getProvider();
        if (provider == null) {
            return task.get();
        }
        Object page = provider.getCtxPage();
        try {
            provider.clearCtxPage();
            V v = task.get();
            return v;
        }
        finally {
            if (page != null) {
                provider.setCtxPage(page);
            }
        }
    }
}

