/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.mybatis.interceptor;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import io.polaris.mybatis.interceptor.PageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageProviders {
    private static final Logger log = LoggerFactory.getLogger(PageProviders.class);
    private static PageProvider<?> provider;

    public static void setProvider(PageProvider<?> provider) {
        PageProviders.provider = provider;
    }

    public static PageProvider<?> getProvider() {
        return provider;
    }

    static {
        try {
            provider = new PageHelperProvider();
        }
        catch (Throwable e) {
            log.error("", e);
            provider = new NoopProvider();
        }
    }

    static class PageHelperProvider
    extends PageHelper
    implements PageProvider<Page<?>> {
        PageHelperProvider() {
        }

        @Override
        public Page<?> getCtxPage() {
            return PageHelper.getLocalPage();
        }

        @Override
        public void clearCtxPage() {
            PageHelper.clearPage();
        }

        @Override
        public void setCtxPage(Page<?> page) {
            PageHelper.setLocalPage(page);
        }
    }

    static class NoopProvider<T>
    implements PageProvider<T> {
        NoopProvider() {
        }

        @Override
        public T getCtxPage() {
            return null;
        }

        @Override
        public void clearCtxPage() {
        }

        @Override
        public void setCtxPage(T page) {
        }
    }
}

