/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.mybatis.interceptor;

import io.polaris.core.tuple.Tuple3;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Statement;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class}), @Signature(type=StatementHandler.class, method="query", args={Statement.class, ResultHandler.class}), @Signature(type=StatementHandler.class, method="queryCursor", args={Statement.class}), @Signature(type=StatementHandler.class, method="update", args={Statement.class}), @Signature(type=StatementHandler.class, method="batch", args={Statement.class})})
public class MybatisLogInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(MybatisLogInterceptor.class);
    private final ThreadLocal<Tuple3<StatementHandler, Method, Long>> local = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        Object object;
        block8: {
            Tuple3<StatementHandler, Method, Long> tuple;
            Object target = invocation.getTarget();
            Method invocationMethod = invocation.getMethod();
            StatementHandler statementHandler = (StatementHandler)target;
            long startTime = System.currentTimeMillis();
            if ("prepare".equals(invocationMethod.getName())) {
                try {
                    Object rs = invocation.proceed();
                    this.local.set((Tuple3<StatementHandler, Method, Long>)Tuple3.of((Object)statementHandler, (Object)invocationMethod, (Object)startTime));
                    return rs;
                }
                catch (Throwable e) {
                    this.local.remove();
                    throw e;
                }
            }
            try {
                object = invocation.proceed();
                tuple = this.local.get();
                if (tuple == null) break block8;
                this.local.remove();
            }
            catch (Throwable throwable) {
                Tuple3<StatementHandler, Method, Long> tuple2 = this.local.get();
                if (tuple2 != null) {
                    this.local.remove();
                    if (tuple2.getFirst() == statementHandler && tuple2.getSecond() == invocationMethod) {
                        startTime = (Long)tuple2.getThird();
                    }
                    long time = System.currentTimeMillis() - startTime;
                    BoundSql boundSql = statementHandler.getBoundSql();
                    log.info("Sql: {}\n    parameterMappings: {}\n    parameterObject: {}\n    Time: {}ms", new Object[]{boundSql.getSql(), boundSql.getParameterMappings(), boundSql.getParameterObject(), time});
                }
                throw throwable;
            }
            if (tuple.getFirst() == statementHandler && tuple.getSecond() == invocationMethod) {
                startTime = (Long)tuple.getThird();
            }
            long time = System.currentTimeMillis() - startTime;
            BoundSql boundSql = statementHandler.getBoundSql();
            log.info("Sql: {}\n    parameterMappings: {}\n    parameterObject: {}\n    Time: {}ms", new Object[]{boundSql.getSql(), boundSql.getParameterMappings(), boundSql.getParameterObject(), time});
        }
        return object;
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }
}

