/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.json.migration;

import io.polaris.core.converter.Converters;
import io.polaris.core.lang.TypeRefs;
import io.polaris.core.lang.Types;
import io.polaris.core.lang.bean.Beans;
import io.polaris.core.time.Dates;
import io.polaris.json.Jacksons;
import io.polaris.json.migration.JSON;
import io.polaris.json.migration.JSONException;
import io.polaris.json.migration.JSONObject;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public class JSONArray
extends ArrayList<Object> {
    private static final long serialVersionUID = 1L;
    private final List<Object> raw;

    public JSONArray(ArrayList<Object> raw, boolean delegate) {
        this.raw = delegate ? raw : new Raw((Collection<?>)raw);
    }

    public JSONArray(Collection<?> c, boolean delegate) {
        this.raw = delegate && c instanceof List ? (List)c : new Raw(c);
    }

    public JSONArray(Collection<?> c) {
        this(c, false);
    }

    public JSONArray(int initialCapacity) {
        this.raw = new Raw(initialCapacity);
    }

    public JSONArray() {
        this.raw = new Raw();
    }

    public static JSONArray of(Object ... items) {
        JSONArray array = new JSONArray();
        Collections.addAll(array, items);
        return array;
    }

    public static JSONArray of(Object item) {
        JSONArray array = new JSONArray(1);
        array.add(item);
        return array;
    }

    public static JSONArray of(List<Object> collection) {
        return new JSONArray(collection, true);
    }

    public static JSONArray of(Collection collection) {
        return new JSONArray(collection, true);
    }

    public static JSONArray copyOf(Collection collection) {
        return new JSONArray(collection, false);
    }

    public static JSONArray parseArray(String text) {
        ArrayList arrayList = Jacksons.toJavaObject(text, ArrayList.class);
        return new JSONArray(arrayList, true);
    }

    public static <T> List<T> parseArray(String text, Class<T> type) {
        return (List)Jacksons.toJavaObject(text, TypeRefs.getType(List.class, (Type[])new Type[]{type}));
    }

    public static JSONArray parse(String text) {
        return JSONArray.parseArray(text);
    }

    public static JSONArray from(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        return JSONArray.parseArray(Jacksons.toJsonString(object));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JSONArray)) {
            return false;
        }
        JSONArray that = (JSONArray)o;
        return this.raw.equals(that.raw);
    }

    @Override
    public int hashCode() {
        return this.raw.hashCode();
    }

    @Override
    public Object set(int index, Object element) {
        int size = this.raw.size();
        if (index < 0) {
            if ((index += size) < 0) {
                this.raw.add(0, element);
                return null;
            }
            return this.raw.set(index, element);
        }
        if (index < size) {
            return this.raw.set(index, element);
        }
        if (index < size + 4096) {
            while (index-- != size) {
                this.raw.add(null);
            }
            this.raw.add(element);
        }
        return null;
    }

    public JSONArray getJSONArray(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof JSONArray) {
            return (JSONArray)value;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            if (str.charAt(0) != '[') {
                return JSONArray.of((Object)str);
            }
            ArrayList arrayList = Jacksons.toJavaObject(str, ArrayList.class);
            return new JSONArray(arrayList, true);
        }
        if (value instanceof Collection) {
            JSONArray array = new JSONArray((Collection)value, true);
            this.set(index, array);
            return array;
        }
        if (value instanceof Object[]) {
            return JSONArray.of((Object[])value);
        }
        Class<?> valueClass = value.getClass();
        if (valueClass.isArray()) {
            int length = Array.getLength(value);
            JSONArray jsonArray = new JSONArray(length);
            for (int i = 0; i < length; ++i) {
                Object item = Array.get(value, i);
                jsonArray.add(item);
            }
            return jsonArray;
        }
        return null;
    }

    public JSONObject getJSONObject(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof JSONObject) {
            return (JSONObject)value;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            Map map = Jacksons.toJavaObject(str, Map.class);
            return new JSONObject(map, true);
        }
        if (value instanceof Map) {
            JSONObject object = new JSONObject((Map)value, true);
            this.set(index, object);
            return object;
        }
        Class<?> valueClass = value.getClass();
        if (Beans.isBeanClass(valueClass)) {
            Map map = Jacksons.toJavaObject(Jacksons.toJsonString(value), Map.class);
            JSONObject object = new JSONObject(map, true);
            this.set(index, object);
            return object;
        }
        return null;
    }

    public String getString(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Date) {
            return Dates.formatDefault((Date)((Date)value));
        }
        if (value instanceof Boolean || value instanceof Character || value instanceof Number || value instanceof UUID || value instanceof Enum || value instanceof TemporalAccessor) {
            return value.toString();
        }
        return Jacksons.toJsonString(value);
    }

    public Double getDouble(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return Double.parseDouble(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Double");
    }

    public double getDoubleValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0.0;
            }
            return Double.parseDouble(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to double value");
    }

    public Float getFloat(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return Float.valueOf(Float.parseFloat(str));
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Float");
    }

    public float getFloatValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0.0f;
            }
            return Float.parseFloat(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to float value");
    }

    public Long getLong(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return Long.parseLong(str);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? Long.valueOf(1L) : Long.valueOf(0L);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Long");
    }

    public long getLongValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return 0L;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0L;
            }
            return Long.parseLong(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to long value");
    }

    public Integer getInteger(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return Integer.parseInt(str);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? Integer.valueOf(1) : Integer.valueOf(0);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Integer");
    }

    public int getIntValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0;
            }
            return Integer.parseInt(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to int value");
    }

    public Short getShort(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return Short.parseShort(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Short");
    }

    public short getShortValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0;
            }
            return Short.parseShort(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to short value");
    }

    public Byte getByte(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return Byte.parseByte(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Byte");
    }

    public byte getByteValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0;
            }
            return Byte.parseByte(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to byte value");
    }

    public Boolean getBoolean(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 1;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return "true".equalsIgnoreCase(str) || "1".equals(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Boolean");
    }

    public boolean getBooleanValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 1;
        }
        if (value instanceof String) {
            String str = (String)value;
            return "true".equalsIgnoreCase(str) || "1".equals(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to boolean value");
    }

    public BigInteger getBigInteger(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            if (value instanceof BigInteger) {
                return (BigInteger)value;
            }
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).toBigInteger();
            }
            long longValue = ((Number)value).longValue();
            return BigInteger.valueOf(longValue);
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return new BigInteger(str);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? BigInteger.ONE : BigInteger.ZERO;
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to BigInteger");
    }

    public BigDecimal getBigDecimal(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            if (value instanceof BigInteger) {
                return new BigDecimal((BigInteger)value);
            }
            if (value instanceof Float) {
                float floatValue = ((Float)value).floatValue();
                return new BigDecimal(floatValue);
            }
            if (value instanceof Double) {
                double doubleValue = (Double)value;
                return new BigDecimal(doubleValue);
            }
            long longValue = ((Number)value).longValue();
            return BigDecimal.valueOf(longValue);
        }
        if (value instanceof String) {
            return new BigDecimal((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to BigDecimal");
    }

    public Date getDate(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Number) {
            long millis = ((Number)value).longValue();
            if (millis == 0L) {
                return null;
            }
            return new Date(millis);
        }
        return (Date)Converters.convertQuietly(Date.class, (Object)value);
    }

    public Date getDate(int index, Date defaultValue) {
        Date date = this.getDate(index);
        if (date == null) {
            date = defaultValue;
        }
        return date;
    }

    public Instant getInstant(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof Instant) {
            return (Instant)value;
        }
        if (value instanceof Number) {
            long millis = ((Number)value).longValue();
            if (millis == 0L) {
                return null;
            }
            return Instant.ofEpochMilli(millis);
        }
        return (Instant)Converters.convertQuietly(Instant.class, (Object)value);
    }

    @Override
    public String toString() {
        return Jacksons.toJsonString(this.raw);
    }

    public String toJSONString() {
        return Jacksons.toJsonString(this.raw);
    }

    public byte[] toJSONBBytes() {
        return Jacksons.toJsonBytes(this.raw);
    }

    public <T> T to(Type type) {
        if (type == String.class) {
            return (T)this.toString();
        }
        if (type == JSON.class || type == JSONArray.class) {
            return (T)this;
        }
        return Jacksons.toJavaObject(Jacksons.toJsonString(this.raw), type);
    }

    public <T> T to(Class<T> type) {
        if (type == String.class) {
            return (T)this.toString();
        }
        if (type == JSON.class || type == JSONArray.class) {
            return (T)this;
        }
        return Jacksons.toJavaObject(Jacksons.toJsonString(this.raw), type);
    }

    @Deprecated
    public <T> T toJavaObject(Type type) {
        return this.to(type);
    }

    public <T> List<T> toList(Class<T> itemClass) {
        ArrayList<T> list = new ArrayList<T>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            Object item = this.get(i);
            Object classItem = item instanceof JSONObject ? ((JSONObject)item).to(itemClass) : (item instanceof Map ? Jacksons.toJavaObject(Jacksons.toJsonString(item), itemClass) : (item == null || itemClass.isInstance(item) ? item : (Beans.isBeanClass(itemClass) ? Jacksons.toJavaObject(Jacksons.toJsonString(item), itemClass) : Converters.convert(itemClass, (Object)item))));
            list.add(classItem);
        }
        return list;
    }

    public <T> T[] toArray(Class<T> itemClass) {
        Object[] list = (Object[])Array.newInstance(itemClass, this.size());
        for (int i = 0; i < this.size(); ++i) {
            Object item = this.get(i);
            Object classItem = item instanceof JSONObject ? ((JSONObject)item).to(itemClass) : (item instanceof Map ? Jacksons.toJavaObject(Jacksons.toJsonString(item), itemClass) : (item == null || itemClass.isInstance(item) ? item : (Beans.isBeanClass(itemClass) ? Jacksons.toJavaObject(Jacksons.toJsonString(item), itemClass) : Converters.convert(itemClass, (Object)item))));
            list[i] = classItem;
        }
        return list;
    }

    public <T> List<T> toJavaList(Class<T> clazz) {
        return this.toList(clazz);
    }

    public <T> T getObject(int index, Type type) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (type == Object.class) {
            return (T)value;
        }
        if (Types.getClass((Type)type).isInstance(value)) {
            return (T)value;
        }
        return (T)Converters.convertQuietly((Type)type, (Object)value);
    }

    public <T> T getObject(int index, Class<T> type) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        if (type == Object.class) {
            return (T)value;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        return (T)Converters.convertQuietly(type, (Object)value);
    }

    public <T> T getObject(int index, Function<JSONObject, T> creator) {
        JSONObject object = this.getJSONObject(index);
        if (object == null) {
            return null;
        }
        return creator.apply(object);
    }

    public JSONObject addObject() {
        JSONObject object = new JSONObject();
        this.add(object);
        return object;
    }

    public JSONArray addArray() {
        JSONArray array = new JSONArray();
        this.add(array);
        return array;
    }

    public JSONArray fluentAdd(Object element) {
        this.add(element);
        return this;
    }

    public JSONArray fluentClear() {
        this.clear();
        return this;
    }

    public JSONArray fluentRemove(int index) {
        this.remove(index);
        return this;
    }

    public JSONArray fluentSet(int index, Object element) {
        this.set(index, element);
        return this;
    }

    public JSONArray fluentRemove(Object o) {
        this.remove(o);
        return this;
    }

    public JSONArray fluentRemoveAll(Collection<?> c) {
        this.removeAll(c);
        return this;
    }

    public JSONArray fluentAddAll(Collection<?> c) {
        this.addAll(c);
        return this;
    }

    @Override
    public Object clone() {
        return new JSONArray(this.raw, false);
    }

    @Override
    public void trimToSize() {
        if (this.raw instanceof ArrayList) {
            ((ArrayList)this.raw).trimToSize();
        }
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        if (this.raw instanceof ArrayList) {
            ((ArrayList)this.raw).ensureCapacity(minCapacity);
        }
    }

    @Override
    public int size() {
        return this.raw.size();
    }

    @Override
    public boolean isEmpty() {
        return this.raw.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.raw.contains(o);
    }

    @Override
    public int indexOf(Object o) {
        return this.raw.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.raw.lastIndexOf(o);
    }

    @Override
    public Object[] toArray() {
        return this.raw.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.raw.toArray(a);
    }

    @Override
    public Object get(int index) {
        return this.raw.get(index);
    }

    @Override
    public boolean add(Object o) {
        return this.raw.add(o);
    }

    @Override
    public void add(int index, Object element) {
        this.raw.add(index, element);
    }

    @Override
    public Object remove(int index) {
        return this.raw.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.raw.remove(o);
    }

    @Override
    public void clear() {
        this.raw.clear();
    }

    @Override
    public boolean addAll(Collection<?> c) {
        return this.raw.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<?> c) {
        return this.raw.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.raw.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.raw.retainAll(c);
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return this.raw.listIterator(index);
    }

    @Override
    public ListIterator<Object> listIterator() {
        return this.raw.listIterator();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.raw.iterator();
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        return this.raw.subList(fromIndex, toIndex);
    }

    @Override
    public void forEach(Consumer<? super Object> action) {
        this.raw.forEach(action);
    }

    @Override
    public Spliterator<Object> spliterator() {
        return this.raw.spliterator();
    }

    @Override
    public boolean removeIf(Predicate<? super Object> filter) {
        return this.raw.removeIf(filter);
    }

    @Override
    public void replaceAll(UnaryOperator<Object> operator) {
        this.raw.replaceAll(operator);
    }

    @Override
    public void sort(Comparator<? super Object> c) {
        this.raw.sort(c);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.raw.containsAll(c);
    }

    @Override
    public Stream<Object> stream() {
        return this.raw.stream();
    }

    @Override
    public Stream<Object> parallelStream() {
        return this.raw.parallelStream();
    }

    private static class Raw
    extends ArrayList<Object> {
        private static final long serialVersionUID = 1L;

        public Raw(int initialCapacity) {
            super(initialCapacity);
        }

        public Raw() {
        }

        public Raw(Collection<?> c) {
            super(c);
        }
    }
}

