/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.json.migration;

import io.polaris.core.converter.Converters;
import io.polaris.core.io.IO;
import io.polaris.core.lang.TypeRef;
import io.polaris.core.lang.TypeRefs;
import io.polaris.core.string.Strings;
import io.polaris.json.Jacksons;
import io.polaris.json.migration.JSONArray;
import io.polaris.json.migration.JSONException;
import io.polaris.json.migration.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface JSON {
    public static Object parse(String text) {
        if ((text = Strings.trim((String)text)) == null || text.isEmpty()) {
            return null;
        }
        if (text.charAt(0) == '{') {
            return JSONObject.parse(text);
        }
        if (text.charAt(0) == '[') {
            return JSONArray.parse(text);
        }
        return Jacksons.toJavaObject(text, Object.class);
    }

    public static Object parse(String text, int offset, int length) {
        if (text == null || text.isEmpty() || length == 0) {
            return null;
        }
        return JSON.parse(text.substring(offset, length));
    }

    public static Object parse(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return JSON.parse(new String(bytes));
    }

    public static Object parse(byte[] bytes, int offset, int length) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return null;
        }
        return JSON.parse(new String(bytes, offset, length));
    }

    public static Object parse(char[] chars) {
        if (chars == null || chars.length == 0) {
            return null;
        }
        return JSON.parse(new String(chars));
    }

    public static Object parse(char[] chars, int offset, int length) {
        if (chars == null || chars.length == 0 || length == 0) {
            return null;
        }
        return JSON.parse(new String(chars, offset, length));
    }

    public static Object parse(InputStream in) {
        if (in == null) {
            return null;
        }
        try {
            String text = IO.toString((InputStream)in);
            Object object = JSON.parse(text);
            return object;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        finally {
            IO.close((AutoCloseable)in);
        }
    }

    public static JSONObject parseObject(String text) {
        return JSONObject.parseObject(text);
    }

    public static JSONObject parseObject(String text, int offset, int length) {
        if (text == null || text.isEmpty() || length == 0) {
            return null;
        }
        return JSONObject.parseObject(text.substring(offset, length));
    }

    public static JSONObject parseObject(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return JSONObject.parseObject(new String(bytes));
    }

    public static JSONObject parseObject(byte[] bytes, Charset charset) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return JSONObject.parseObject(new String(bytes, charset));
    }

    public static JSONObject parseObject(byte[] bytes, int offset, int length) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return null;
        }
        return JSONObject.parseObject(new String(bytes, offset, length));
    }

    public static JSONObject parseObject(byte[] bytes, int offset, int length, Charset charset) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return null;
        }
        return JSONObject.parseObject(new String(bytes, offset, length, charset));
    }

    public static JSONObject parseObject(char[] chars) {
        if (chars == null || chars.length == 0) {
            return null;
        }
        return JSONObject.parseObject(new String(chars));
    }

    public static JSONObject parseObject(char[] chars, int offset, int length) {
        if (chars == null || chars.length == 0 || length == 0) {
            return null;
        }
        return JSONObject.parseObject(new String(chars, offset, length));
    }

    public static JSONObject parseObject(Reader in) {
        if (in == null) {
            return null;
        }
        try {
            String text = IO.toString((Reader)in);
            JSONObject jSONObject = JSONObject.parseObject(text);
            return jSONObject;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        finally {
            IO.close((AutoCloseable)in);
        }
    }

    public static JSONObject parseObject(InputStream in) {
        if (in == null) {
            return null;
        }
        try {
            String text = IO.toString((InputStream)in);
            JSONObject jSONObject = JSONObject.parseObject(text);
            return jSONObject;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        finally {
            IO.close((AutoCloseable)in);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONObject parseObject(URL url) {
        if (url == null) {
            return null;
        }
        try (InputStream is = url.openStream();){
            JSONObject jSONObject = JSON.parseObject(is, StandardCharsets.UTF_8);
            return jSONObject;
        }
        catch (IOException e) {
            throw new JSONException("JSON#parseObject cannot parse '" + url + "'", e);
        }
    }

    public static JSONObject parseObject(InputStream in, Charset charset) {
        if (in == null) {
            return null;
        }
        try {
            String text = IO.toString((InputStream)in, (Charset)charset);
            JSONObject jSONObject = JSONObject.parseObject(text);
            return jSONObject;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        finally {
            IO.close((AutoCloseable)in);
        }
    }

    public static <T> T parseObject(String text, Class<T> clazz) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        return Jacksons.toJavaObject(text, clazz);
    }

    public static <T> T parseObject(String text, Type type) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        return Jacksons.toJavaObject(text, type);
    }

    public static <T> T parseObject(String text, TypeRef<T> type) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        return Jacksons.toJavaObject(text, type);
    }

    public static <T> T parseObject(String text, int offset, int length, Class<T> clazz) {
        if (text == null || text.isEmpty() || length == 0) {
            return null;
        }
        return Jacksons.toJavaObject(text.substring(offset, length), clazz);
    }

    public static <T> T parseObject(String text, int offset, int length, Type type) {
        if (text == null || text.isEmpty() || length == 0) {
            return null;
        }
        return Jacksons.toJavaObject(text.substring(offset, length), type);
    }

    public static <T> T parseObject(char[] chars, Class<T> clazz) {
        if (chars == null || chars.length == 0) {
            return null;
        }
        return Jacksons.toJavaObject(new String(chars), clazz);
    }

    public static <T> T parseObject(char[] chars, Type type) {
        if (chars == null || chars.length == 0) {
            return null;
        }
        return Jacksons.toJavaObject(new String(chars), type);
    }

    public static <T> T parseObject(char[] chars, int offset, int length, Class<T> clazz) {
        if (chars == null || chars.length == 0 || length == 0) {
            return null;
        }
        return Jacksons.toJavaObject(new String(chars, offset, length), clazz);
    }

    public static <T> T parseObject(char[] chars, int offset, int length, Type type) {
        if (chars == null || chars.length == 0 || length == 0) {
            return null;
        }
        return Jacksons.toJavaObject(new String(chars, offset, length), type);
    }

    public static <T> T parseObject(byte[] bytes, Class<T> clazz) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return Jacksons.toJavaObject(new String(bytes), clazz);
    }

    public static <T> T parseObject(byte[] bytes, Type type) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return Jacksons.toJavaObject(new String(bytes), type);
    }

    public static <T> T parseObject(byte[] bytes, int offset, int length, Class<T> clazz) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return null;
        }
        return Jacksons.toJavaObject(new String(bytes, offset, length), clazz);
    }

    public static <T> T parseObject(byte[] bytes, int offset, int length, Type type) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return null;
        }
        return Jacksons.toJavaObject(new String(bytes, offset, length), type);
    }

    public static <T> T parseObject(Reader input, Type type) {
        if (input == null) {
            return null;
        }
        try {
            return Jacksons.toJavaObject(IO.toString((Reader)input), type);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    public static <T> T parseObject(InputStream input, Type type) {
        if (input == null) {
            return null;
        }
        try {
            return Jacksons.toJavaObject(IO.toString((InputStream)input), type);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    public static <T> T parseObject(InputStream input, Charset charset, Type type) {
        if (input == null) {
            return null;
        }
        try {
            return Jacksons.toJavaObject(IO.toString((InputStream)input, (Charset)charset), type);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T parseObject(URL url, Type type) {
        if (url == null) {
            return null;
        }
        try (InputStream is = url.openStream();){
            Object t = Jacksons.toJavaObject(IO.toString((InputStream)is), type);
            return t;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    public static JSONArray parseArray(String text) {
        return JSONArray.parseArray(text);
    }

    public static JSONArray parseArray(String text, int offset, int length) {
        if (text == null || text.isEmpty() || length == 0) {
            return null;
        }
        return JSONArray.parseArray(text.substring(offset, length));
    }

    public static JSONArray parseArray(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return JSONArray.parseArray(new String(bytes));
    }

    public static JSONArray parseArray(byte[] bytes, Charset charset) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return JSONArray.parseArray(new String(bytes, charset));
    }

    public static JSONArray parseArray(byte[] bytes, int offset, int length) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return null;
        }
        return JSONArray.parseArray(new String(bytes, offset, length));
    }

    public static JSONArray parseArray(byte[] bytes, int offset, int length, Charset charset) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return null;
        }
        return JSONArray.parseArray(new String(bytes, offset, length, charset));
    }

    public static JSONArray parseArray(char[] chars) {
        if (chars == null || chars.length == 0) {
            return null;
        }
        return JSONArray.parseArray(new String(chars));
    }

    public static JSONArray parseArray(char[] chars, int offset, int length) {
        if (chars == null || chars.length == 0 || length == 0) {
            return null;
        }
        return JSONArray.parseArray(new String(chars, offset, length));
    }

    public static JSONArray parseArray(Reader in) {
        if (in == null) {
            return null;
        }
        try {
            String text = IO.toString((Reader)in);
            JSONArray jSONArray = JSONArray.parseArray(text);
            return jSONArray;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        finally {
            IO.close((AutoCloseable)in);
        }
    }

    public static JSONArray parseArray(InputStream in) {
        if (in == null) {
            return null;
        }
        try {
            String text = IO.toString((InputStream)in);
            JSONArray jSONArray = JSONArray.parseArray(text);
            return jSONArray;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        finally {
            IO.close((AutoCloseable)in);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONArray parseArray(URL url) {
        if (url == null) {
            return null;
        }
        try (InputStream is = url.openStream();){
            JSONArray jSONArray = JSON.parseArray(is, StandardCharsets.UTF_8);
            return jSONArray;
        }
        catch (IOException e) {
            throw new JSONException("JSON#parseArray cannot parse '" + url + "'", e);
        }
    }

    public static JSONArray parseArray(InputStream in, Charset charset) {
        if (in == null) {
            return null;
        }
        try {
            String text = IO.toString((InputStream)in, (Charset)charset);
            JSONArray jSONArray = JSONArray.parseArray(text);
            return jSONArray;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        finally {
            IO.close((AutoCloseable)in);
        }
    }

    public static <T> List<T> parseArray(String text, Class<T> clazz) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        return (List)Jacksons.toJavaObject(text, TypeRefs.getType(List.class, (Type[])new Type[]{clazz}));
    }

    public static <T> List<T> parseArray(String text, Type type) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        return (List)Jacksons.toJavaObject(text, TypeRefs.getType(List.class, (Type[])new Type[]{type}));
    }

    public static <T> List<T> parseArray(String text, TypeRef<List<T>> type) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        return Jacksons.toJavaObject(text, type);
    }

    public static <T> List<T> parseArray(String text, int offset, int length, Class<T> clazz) {
        if (text == null || text.isEmpty() || length == 0) {
            return null;
        }
        return (List)Jacksons.toJavaObject(text.substring(offset, length), TypeRefs.getType(List.class, (Type[])new Type[]{clazz}));
    }

    public static <T> List<T> parseArray(String text, int offset, int length, Type type) {
        if (text == null || text.isEmpty() || length == 0) {
            return null;
        }
        return (List)Jacksons.toJavaObject(text.substring(offset, length), TypeRefs.getType(List.class, (Type[])new Type[]{type}));
    }

    public static <T> List<T> parseArray(char[] chars, Class<T> clazz) {
        if (chars == null || chars.length == 0) {
            return null;
        }
        return (List)Jacksons.toJavaObject(new String(chars), TypeRefs.getType(List.class, (Type[])new Type[]{clazz}));
    }

    public static <T> List<T> parseArray(char[] chars, Type type) {
        if (chars == null || chars.length == 0) {
            return null;
        }
        return (List)Jacksons.toJavaObject(new String(chars), TypeRefs.getType(List.class, (Type[])new Type[]{type}));
    }

    public static <T> List<T> parseArray(char[] chars, int offset, int length, Class<T> clazz) {
        if (chars == null || chars.length == 0 || length == 0) {
            return null;
        }
        return (List)Jacksons.toJavaObject(new String(chars, offset, length), TypeRefs.getType(List.class, (Type[])new Type[]{clazz}));
    }

    public static <T> List<T> parseArray(char[] chars, int offset, int length, Type type) {
        if (chars == null || chars.length == 0 || length == 0) {
            return null;
        }
        return (List)Jacksons.toJavaObject(new String(chars, offset, length), TypeRefs.getType(List.class, (Type[])new Type[]{type}));
    }

    public static <T> List<T> parseArray(byte[] bytes, Class<T> clazz) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return (List)Jacksons.toJavaObject(new String(bytes), TypeRefs.getType(List.class, (Type[])new Type[]{clazz}));
    }

    public static <T> List<T> parseArray(byte[] bytes, Type type) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return (List)Jacksons.toJavaObject(new String(bytes), TypeRefs.getType(List.class, (Type[])new Type[]{type}));
    }

    public static <T> List<T> parseArray(byte[] bytes, int offset, int length, Class<T> clazz) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return null;
        }
        return (List)Jacksons.toJavaObject(new String(bytes, offset, length), TypeRefs.getType(List.class, (Type[])new Type[]{clazz}));
    }

    public static <T> List<T> parseArray(byte[] bytes, int offset, int length, Type type) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return null;
        }
        return (List)Jacksons.toJavaObject(new String(bytes, offset, length), TypeRefs.getType(List.class, (Type[])new Type[]{type}));
    }

    public static <T> List<T> parseArray(Reader input, Type type) {
        if (input == null) {
            return null;
        }
        try {
            return (List)Jacksons.toJavaObject(IO.toString((Reader)input), TypeRefs.getType(List.class, (Type[])new Type[]{type}));
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    public static <T> List<T> parseArray(InputStream input, Type type) {
        if (input == null) {
            return null;
        }
        try {
            return (List)Jacksons.toJavaObject(IO.toString((InputStream)input), TypeRefs.getType(List.class, (Type[])new Type[]{type}));
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    public static <T> List<T> parseArray(InputStream input, Charset charset, Type type) {
        if (input == null) {
            return null;
        }
        try {
            return (List)Jacksons.toJavaObject(IO.toString((InputStream)input, (Charset)charset), TypeRefs.getType(List.class, (Type[])new Type[]{type}));
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> List<T> parseArray(URL url, Type type) {
        if (url == null) {
            return null;
        }
        try (InputStream is = url.openStream();){
            List list = (List)Jacksons.toJavaObject(IO.toString((InputStream)is), TypeRefs.getType(List.class, (Type[])new Type[]{type}));
            return list;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    public static String toJSONString(Object object) {
        return Jacksons.toJsonString(object);
    }

    public static byte[] toJSONBytes(Object object) {
        return Jacksons.toJsonBytes(object);
    }

    public static Object toJSON(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof JSONObject || object instanceof JSONArray) {
            return object;
        }
        if (object instanceof Map) {
            return JSONObject.of((Map)object);
        }
        if (object instanceof Collection) {
            return JSONArray.of((Collection)object);
        }
        return JSON.parse(Jacksons.toJsonString(object));
    }

    public static <T> T to(Class<T> clazz, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof JSONObject) {
            return ((JSONObject)object).to(clazz);
        }
        return (T)Converters.convert(clazz, (Object)object);
    }

    public static <T> T toJavaObject(Object object, Class<T> clazz) {
        return JSON.to(clazz, object);
    }
}

