/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.json;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.polaris.core.lang.JavaType;
import io.polaris.core.lang.TypeRef;
import io.polaris.core.service.StatefulServiceLoader;
import io.polaris.json.CustomHandlerInstantiator;
import io.polaris.json.IJacksonCustomizer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jacksons {
    private static final Logger log = LoggerFactory.getLogger(Jacksons.class);
    private static final ObjectMapper MAPPER = Jacksons.buildObjectMapper();
    private static final ObjectMapper MAPPER_AUTO_TYPE = Jacksons.buildObjectMapper(mapper -> mapper.activateDefaultTypingAsProperty(mapper.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.Id.NAME.getDefaultPropertyName()));

    public static ObjectMapper defaultObjectMapper() {
        return MAPPER;
    }

    public static ObjectMapper autoTypeObjectMapper() {
        return MAPPER_AUTO_TYPE;
    }

    public static ObjectMapper buildObjectMapper(Consumer<ObjectMapper> customizer) {
        ObjectMapper mapper = Jacksons.buildObjectMapper();
        customizer.accept(mapper);
        return mapper;
    }

    public static ObjectMapper buildObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.disable(SerializationFeature.FAIL_ON_SELF_REFERENCES);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.disable(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE);
        mapper.enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL);
        mapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS});
        mapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES});
        mapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES});
        mapper.enable(new JsonParser.Feature[]{JsonParser.Feature.IGNORE_UNDEFINED});
        mapper.enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.IGNORE_UNKNOWN});
        mapper.enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN});
        mapper.setTimeZone(TimeZone.getDefault());
        mapper.setLocale(Locale.getDefault());
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(BigDecimal.class, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(BigInteger.class, (JsonSerializer)ToStringSerializer.instance);
        mapper.registerModule((Module)simpleModule);
        mapper.setHandlerInstantiator((HandlerInstantiator)new CustomHandlerInstantiator());
        for (IJacksonCustomizer customizer : StatefulServiceLoader.load(IJacksonCustomizer.class)) {
            try {
                customizer.customize(mapper);
            }
            catch (Throwable e) {
                log.error("", e);
            }
        }
        return mapper;
    }

    public static byte[] toJsonBytes(Object target) {
        return Jacksons.toJsonBytes(Jacksons.defaultObjectMapper(), target);
    }

    public static byte[] toJsonBytes(ObjectMapper mapper, Object target) {
        try {
            return mapper.writeValueAsBytes(target);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toJsonString(Object target) {
        return Jacksons.toJsonString(Jacksons.defaultObjectMapper(), target);
    }

    public static String toJsonString(ObjectMapper mapper, Object target) {
        try {
            return mapper.writeValueAsString(target);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toJsonStringOrNull(Object target) {
        return Jacksons.toJsonStringOrNull(Jacksons.defaultObjectMapper(), target);
    }

    public static String toJsonStringOrNull(ObjectMapper mapper, Object target) {
        try {
            return mapper.writeValueAsString(target);
        }
        catch (Throwable e) {
            log.error("json\u5e8f\u5217\u5316\u5931\u8d25", e);
            return null;
        }
    }

    public static String toJsonPrettyString(Object target) {
        return Jacksons.toJsonPrettyString(Jacksons.defaultObjectMapper(), target);
    }

    public static String toJsonPrettyString(ObjectMapper mapper, Object target) {
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(target);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toJsonPrettyStringOrNull(Object target) {
        return Jacksons.toJsonPrettyStringOrNull(Jacksons.defaultObjectMapper(), target);
    }

    public static String toJsonPrettyStringOrNull(ObjectMapper mapper, Object target) {
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(target);
        }
        catch (Throwable e) {
            log.error("json\u5e8f\u5217\u5316\u5931\u8d25", e);
            return null;
        }
    }

    public static String toJsonOrJavaString(Object target) {
        return Jacksons.toJsonOrJavaString(Jacksons.defaultObjectMapper(), target);
    }

    public static String toJsonOrJavaString(ObjectMapper mapper, Object target) {
        try {
            return mapper.writeValueAsString(target);
        }
        catch (Throwable e) {
            return target == null ? null : target.toString();
        }
    }

    public static JsonNode toJsonTree(Object target) {
        return Jacksons.toJsonTree(Jacksons.defaultObjectMapper(), target);
    }

    public static JsonNode toJsonTree(ObjectMapper mapper, Object target) {
        try {
            return mapper.valueToTree(target);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static JsonNode toJsonTreeOrNull(Object target) {
        return Jacksons.toJsonTreeOrNull(Jacksons.defaultObjectMapper(), target);
    }

    public static JsonNode toJsonTreeOrNull(ObjectMapper mapper, Object target) {
        try {
            return mapper.valueToTree(target);
        }
        catch (Throwable e) {
            log.error("json\u5e8f\u5217\u5316\u5931\u8d25", e);
            return null;
        }
    }

    public static <T> T toJavaObject(String json, TypeReference<T> type) {
        return Jacksons.toJavaObject(Jacksons.defaultObjectMapper(), json, type);
    }

    public static <T> T toJavaObject(ObjectMapper mapper, String json, TypeReference<T> type) {
        try {
            return (T)mapper.readValue(json, type);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T toJavaObjectOrNull(String json, TypeReference<T> type) {
        return Jacksons.toJavaObjectOrNull(Jacksons.defaultObjectMapper(), json, type);
    }

    public static <T> T toJavaObjectOrNull(ObjectMapper mapper, String json, TypeReference<T> type) {
        try {
            return (T)mapper.readValue(json, type);
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6json\u5931\u8d25,json:{}", (Object)json, (Object)e);
            return null;
        }
    }

    public static <T> T toJavaObject(String json, TypeRef<T> type) {
        return Jacksons.toJavaObject(Jacksons.defaultObjectMapper(), json, type);
    }

    public static <T> T toJavaObject(ObjectMapper mapper, String json, TypeRef<T> type) {
        return Jacksons.toJavaObject(mapper, json, type.getType());
    }

    public static <T> T toJavaObjectOrNull(String json, TypeRef<T> type) {
        return Jacksons.toJavaObjectOrNull(Jacksons.defaultObjectMapper(), json, type);
    }

    public static <T> T toJavaObjectOrNull(ObjectMapper mapper, String json, TypeRef<T> type) {
        return Jacksons.toJavaObjectOrNull(mapper, json, type.getType());
    }

    public static <T> T toJavaObject(String json, Type type) {
        return Jacksons.toJavaObject(Jacksons.defaultObjectMapper(), json, type);
    }

    public static <T> T toJavaObject(ObjectMapper mapper, String json, Type type) {
        try {
            if (type instanceof JavaType) {
                return Jacksons.toJavaObject(json, ((JavaType)type).getRawType());
            }
            return (T)mapper.readValue(json, mapper.constructType(type));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T toJavaObjectOrNull(String json, Type type) {
        return Jacksons.toJavaObjectOrNull(Jacksons.defaultObjectMapper(), json, type);
    }

    public static <T> T toJavaObjectOrNull(ObjectMapper mapper, String json, Type type) {
        try {
            if (type instanceof JavaType) {
                return Jacksons.toJavaObjectOrNull(json, ((JavaType)type).getRawType());
            }
            return (T)mapper.readValue(json, mapper.constructType(type));
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6json\u5931\u8d25,json:{}", (Object)json, (Object)e);
            return null;
        }
    }

    public static <T> T toJavaObject(String json, com.fasterxml.jackson.databind.JavaType type) {
        return Jacksons.toJavaObject(Jacksons.defaultObjectMapper(), json, type);
    }

    public static <T> T toJavaObject(ObjectMapper mapper, String json, com.fasterxml.jackson.databind.JavaType type) {
        try {
            return (T)mapper.readValue(json, type);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T toJavaObjectOrNull(String json, com.fasterxml.jackson.databind.JavaType type) {
        return Jacksons.toJavaObjectOrNull(Jacksons.defaultObjectMapper(), json, type);
    }

    public static <T> T toJavaObjectOrNull(ObjectMapper mapper, String json, com.fasterxml.jackson.databind.JavaType type) {
        try {
            return (T)mapper.readValue(json, type);
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6json\u5931\u8d25,json:{}", (Object)json, (Object)e);
            return null;
        }
    }

    public static <T> T toJavaObject(String json, Class<T> clazz) {
        return Jacksons.toJavaObject(Jacksons.defaultObjectMapper(), json, clazz);
    }

    public static <T> T toJavaObject(ObjectMapper mapper, String json, Class<T> clazz) {
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T toJavaObjectOrNull(String json, Class<T> clazz) {
        return Jacksons.toJavaObjectOrNull(Jacksons.defaultObjectMapper(), json, clazz);
    }

    public static <T> T toJavaObjectOrNull(ObjectMapper mapper, String json, Class<T> clazz) {
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6json\u5931\u8d25,json:{}", (Object)json, (Object)e);
            return null;
        }
    }

    public static <T> T toJavaObject(byte[] json, TypeReference<T> type) {
        return Jacksons.toJavaObject(Jacksons.defaultObjectMapper(), json, type);
    }

    public static <T> T toJavaObject(ObjectMapper mapper, byte[] json, TypeReference<T> type) {
        try {
            return (T)mapper.readValue(json, type);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T toJavaObjectOrNull(byte[] json, TypeReference<T> type) {
        return Jacksons.toJavaObjectOrNull(Jacksons.defaultObjectMapper(), json, type);
    }

    public static <T> T toJavaObjectOrNull(ObjectMapper mapper, byte[] json, TypeReference<T> type) {
        try {
            return (T)mapper.readValue(json, type);
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6json\u5931\u8d25,json:{}", (Object)json, (Object)e);
            return null;
        }
    }

    public static <T> T toJavaObject(byte[] json, TypeRef<T> type) {
        return Jacksons.toJavaObject(Jacksons.defaultObjectMapper(), json, type);
    }

    public static <T> T toJavaObject(ObjectMapper mapper, byte[] json, TypeRef<T> type) {
        return Jacksons.toJavaObject(mapper, json, type.getType());
    }

    public static <T> T toJavaObjectOrNull(byte[] json, TypeRef<T> type) {
        return Jacksons.toJavaObjectOrNull(Jacksons.defaultObjectMapper(), json, type);
    }

    public static <T> T toJavaObjectOrNull(ObjectMapper mapper, byte[] json, TypeRef<T> type) {
        return Jacksons.toJavaObjectOrNull(mapper, json, type.getType());
    }

    public static <T> T toJavaObject(byte[] json, Type type) {
        return Jacksons.toJavaObject(Jacksons.defaultObjectMapper(), json, type);
    }

    public static <T> T toJavaObject(ObjectMapper mapper, byte[] json, Type type) {
        try {
            if (type instanceof JavaType) {
                return Jacksons.toJavaObject(json, ((JavaType)type).getRawType());
            }
            return (T)mapper.readValue(json, mapper.constructType(type));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T toJavaObjectOrNull(byte[] json, Type type) {
        return Jacksons.toJavaObjectOrNull(Jacksons.defaultObjectMapper(), json, type);
    }

    public static <T> T toJavaObjectOrNull(ObjectMapper mapper, byte[] json, Type type) {
        try {
            if (type instanceof JavaType) {
                return Jacksons.toJavaObjectOrNull(json, ((JavaType)type).getRawType());
            }
            return (T)mapper.readValue(json, mapper.constructType(type));
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6json\u5931\u8d25,json:{}", (Object)json, (Object)e);
            return null;
        }
    }

    public static <T> T toJavaObject(byte[] bytes, Class<T> clazz) {
        return Jacksons.toJavaObject(Jacksons.defaultObjectMapper(), bytes, clazz);
    }

    public static <T> T toJavaObject(ObjectMapper mapper, byte[] bytes, Class<T> clazz) {
        try {
            return (T)mapper.readValue(bytes, clazz);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T toJavaObjectOrNull(byte[] bytes, Class<T> clazz) {
        return Jacksons.toJavaObjectOrNull(Jacksons.defaultObjectMapper(), bytes, clazz);
    }

    public static <T> T toJavaObjectOrNull(ObjectMapper mapper, byte[] bytes, Class<T> clazz) {
        try {
            return (T)mapper.readValue(bytes, clazz);
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6json\u5931\u8d25,json:{}", (Object)new String(bytes), (Object)e);
            return null;
        }
    }

    public static <T> T toJavaObject(byte[] bytes, com.fasterxml.jackson.databind.JavaType javaType) {
        return Jacksons.toJavaObject(Jacksons.defaultObjectMapper(), bytes, javaType);
    }

    public static <T> T toJavaObject(ObjectMapper mapper, byte[] bytes, com.fasterxml.jackson.databind.JavaType javaType) {
        try {
            return (T)mapper.readValue(bytes, javaType);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T toJavaObjectOrNull(byte[] bytes, com.fasterxml.jackson.databind.JavaType javaType) {
        return Jacksons.toJavaObjectOrNull(Jacksons.defaultObjectMapper(), bytes, javaType);
    }

    public static <T> T toJavaObjectOrNull(ObjectMapper mapper, byte[] bytes, com.fasterxml.jackson.databind.JavaType javaType) {
        try {
            return (T)mapper.readValue(bytes, javaType);
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6json\u5931\u8d25,json:{}", (Object)new String(bytes), (Object)e);
            return null;
        }
    }

    public static JsonNode toJsonTree(String json) {
        return Jacksons.toJsonTree(Jacksons.defaultObjectMapper(), json);
    }

    public static JsonNode toJsonTree(ObjectMapper mapper, String json) {
        try {
            return mapper.readTree(json);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static JsonNode toJsonTreeOrNull(String json) {
        return Jacksons.toJsonTreeOrNull(Jacksons.defaultObjectMapper(), json);
    }

    public static JsonNode toJsonTreeOrNull(ObjectMapper mapper, String json) {
        try {
            return mapper.readTree(json);
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6json\u5931\u8d25,json:{}", (Object)json, (Object)e);
            return null;
        }
    }

    public static JsonNode toJsonTree(byte[] bytes) {
        return Jacksons.toJsonTree(Jacksons.defaultObjectMapper(), bytes);
    }

    public static JsonNode toJsonTree(ObjectMapper mapper, byte[] bytes) {
        try {
            return mapper.readTree(bytes);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static JsonNode toJsonTreeOrNull(byte[] bytes) {
        return Jacksons.toJsonTreeOrNull(Jacksons.defaultObjectMapper(), bytes);
    }

    public static JsonNode toJsonTreeOrNull(ObjectMapper mapper, byte[] bytes) {
        try {
            return mapper.readTree(bytes);
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6json\u5931\u8d25,json:{}", (Object)new String(bytes), (Object)e);
            return null;
        }
    }

    public static <T> Type toType(TypeReference<T> type) {
        return type.getType();
    }
}

