/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.json;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.TypeReference;
import io.polaris.core.lang.JavaType;
import io.polaris.core.lang.TypeRef;
import io.polaris.core.service.StatefulServiceLoader;
import io.polaris.json.IFastjsonCustomizer;
import java.lang.reflect.Type;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fastjsons {
    private static final Logger log = LoggerFactory.getLogger(Fastjsons.class);
    private static final JSONReader.Feature[] readerFeatures = new JSONReader.Feature[]{JSONReader.Feature.SupportSmartMatch, JSONReader.Feature.AllowUnQuotedFieldNames, JSONReader.Feature.NonZeroNumberCastToBooleanAsTrue};
    private static final JSONWriter.Feature[] writerFeatures = new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.IgnoreErrorGetter, JSONWriter.Feature.WriteLongAsString, JSONWriter.Feature.WriteBigDecimalAsPlain, JSONWriter.Feature.WriteEnumsUsingName};
    private static final JSONWriter.Feature[] writerPrettyFeatures = new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.IgnoreErrorGetter, JSONWriter.Feature.WriteLongAsString, JSONWriter.Feature.WriteBigDecimalAsPlain, JSONWriter.Feature.WriteEnumsUsingName, JSONWriter.Feature.PrettyFormat};

    public static JSONReader.Feature[] getDefaultReaderFeatures() {
        return readerFeatures;
    }

    public static JSONWriter.Feature[] getDefaultWriterFeatures() {
        return writerFeatures;
    }

    public static byte[] toJsonBytes(Object target) {
        try {
            return JSON.toJSONBytes((Object)target, (JSONWriter.Feature[])writerFeatures);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toJsonString(Object target) {
        try {
            return JSON.toJSONString((Object)target, (JSONWriter.Feature[])writerFeatures);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toJsonStringOrNull(Object target) {
        try {
            return JSON.toJSONString((Object)target, (JSONWriter.Feature[])writerFeatures);
        }
        catch (Throwable e) {
            log.error("json\u5e8f\u5217\u5316\u5931\u8d25", e);
            return null;
        }
    }

    public static String toJsonPrettyString(Object target) {
        try {
            return JSON.toJSONString((Object)target, (JSONWriter.Feature[])writerPrettyFeatures);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toJsonPrettyStringOrNull(Object target) {
        try {
            return JSON.toJSONString((Object)target, (JSONWriter.Feature[])writerPrettyFeatures);
        }
        catch (Throwable e) {
            log.error("json\u5e8f\u5217\u5316\u5931\u8d25", e);
            return null;
        }
    }

    public static String toJsonOrJavaString(Object target) {
        try {
            return JSON.toJSONString((Object)target, (JSONWriter.Feature[])writerFeatures);
        }
        catch (Throwable e) {
            return target == null ? null : target.toString();
        }
    }

    public static Object toJsonObject(Object obj) {
        return JSON.toJSON((Object)obj, (JSONWriter.Feature[])writerFeatures);
    }

    public static Object toJson(String text) {
        return JSON.parse((String)text, (JSONReader.Feature[])readerFeatures);
    }

    public static JSONObject toJsonObject(String text) {
        return JSON.parseObject((String)text, (JSONReader.Feature[])readerFeatures);
    }

    public static JSONArray toJsonList(String text) {
        return JSON.parseArray((String)text, (JSONReader.Feature[])readerFeatures);
    }

    public static <T> T toJavaObject(String json, TypeRef<T> type) {
        return Fastjsons.toJavaObject(json, type.getType());
    }

    public static <T> T toJavaObject(String text, Type type) {
        if (type instanceof JavaType) {
            return Fastjsons.toJavaObject(text, ((JavaType)type).getRawType());
        }
        return (T)JSON.parseObject((String)text, (Type)type, (JSONReader.Feature[])readerFeatures);
    }

    public static <T> T toJavaObject(String text, Class<T> clazz) {
        return (T)JSON.parseObject((String)text, clazz, (JSONReader.Feature[])readerFeatures);
    }

    public static <T> T toJavaObject(String text, TypeReference<T> clazz) {
        return (T)JSON.parseObject((String)text, clazz, (JSONReader.Feature[])readerFeatures);
    }

    public static <T> List<T> toJavaList(String text, Type type) {
        if (type instanceof JavaType) {
            return Fastjsons.toJavaList(text, ((JavaType)type).getRawType());
        }
        return JSON.parseArray((String)text, (Type)type, (JSONReader.Feature[])readerFeatures);
    }

    public static <T> List<T> toJavaList(String text, Class<T> clazz) {
        return JSON.parseArray((String)text, clazz, (JSONReader.Feature[])readerFeatures);
    }

    public static <T> Type toType(TypeReference<T> type) {
        return type.getType();
    }

    static {
        for (IFastjsonCustomizer customizer : StatefulServiceLoader.load(IFastjsonCustomizer.class)) {
            try {
                customizer.customize();
            }
            catch (Throwable e) {
                log.error("", e);
            }
        }
    }
}

