/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.image.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.GlobalHistogramBinarizer;
import com.google.zxing.common.HybridBinarizer;
import io.polaris.core.codec.Base64;
import io.polaris.core.io.Filenames;
import io.polaris.core.io.IO;
import io.polaris.core.io.ansi.AnsiColors;
import io.polaris.core.io.ansi.AnsiElement;
import io.polaris.core.io.ansi.AnsiEncoder;
import io.polaris.core.io.ansi.ForeOrBack;
import io.polaris.core.io.image.ImageEditor;
import io.polaris.core.io.image.Images;
import io.polaris.core.string.Strings;
import io.polaris.image.qrcode.QrConfig;
import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class QrCodes {
    public static final String QR_TYPE_SVG = "svg";
    public static final String QR_TYPE_TXT = "txt";
    private static final AnsiColors ansiColors = new AnsiColors(AnsiColors.BitDepth.EIGHT);

    public static String generateAsBase64(String content, QrConfig qrConfig, String targetType, String logoBase64) throws IOException {
        return QrCodes.generateAsBase64(content, qrConfig, targetType, Base64.decode((String)logoBase64));
    }

    public static String generateAsBase64(String content, QrConfig qrConfig, String targetType, byte[] logo) throws IOException {
        return QrCodes.generateAsBase64(content, qrConfig, targetType, Images.toImage((byte[])logo));
    }

    public static String generateAsBase64(String content, QrConfig qrConfig, String targetType, Image logo) throws IOException {
        qrConfig.setImg(logo);
        return QrCodes.generateAsBase64(content, qrConfig, targetType);
    }

    public static String generateAsBase64(String content, QrConfig qrConfig, String targetType) throws IOException {
        String result;
        switch (targetType) {
            case "svg": {
                String svg = QrCodes.generateAsSvg(content, qrConfig);
                result = QrCodes.svgToBase64(svg);
                break;
            }
            case "txt": {
                String txt = QrCodes.generateAsAsciiArt(content, qrConfig);
                result = QrCodes.txtToBase64(txt);
                break;
            }
            default: {
                BufferedImage img = QrCodes.generate(content, qrConfig);
                result = Images.toBase64DataUri((Image)img, (String)targetType);
            }
        }
        return result;
    }

    private static String txtToBase64(String txt) {
        return Images.toBase64DataUri((String)"text/plain", (String)Base64.encodeToString((byte[])txt.getBytes(StandardCharsets.UTF_8)));
    }

    private static String svgToBase64(String svg) {
        return Images.toBase64DataUri((String)"image/svg+xml", (String)Base64.encodeToString((byte[])svg.getBytes(StandardCharsets.UTF_8)));
    }

    public static String generateAsSvg(String content, QrConfig qrConfig) throws IOException {
        BitMatrix bitMatrix = QrCodes.encode(content, qrConfig);
        return QrCodes.toSVG(bitMatrix, qrConfig);
    }

    public static String generateAsAsciiArt(String content) throws IOException {
        return QrCodes.generateAsAsciiArt(content, 0, 0, 1);
    }

    public static String generateAsAsciiArt(String content, QrConfig qrConfig) throws IOException {
        BitMatrix bitMatrix = QrCodes.encode(content, qrConfig);
        return QrCodes.toAsciiArt(bitMatrix, qrConfig);
    }

    public static String generateAsAsciiArt(String content, int width, int height, int margin) throws IOException {
        QrConfig qrConfig = new QrConfig(width, height).setMargin(margin);
        return QrCodes.generateAsAsciiArt(content, qrConfig);
    }

    public static byte[] generatePng(String content, int width, int height) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QrCodes.generate(content, width, height, "png", out);
        return out.toByteArray();
    }

    public static byte[] generatePng(String content, QrConfig config) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QrCodes.generate(content, config, "png", out);
        return out.toByteArray();
    }

    public static File generate(String content, int width, int height, File targetFile) throws IOException {
        String extName;
        switch (extName = Filenames.extName((File)targetFile)) {
            case "svg": {
                String svg = QrCodes.generateAsSvg(content, new QrConfig(width, height));
                IO.writeString((File)targetFile, (Charset)StandardCharsets.UTF_8, (String)svg);
                break;
            }
            case "txt": {
                String txt = QrCodes.generateAsAsciiArt(content, new QrConfig(width, height));
                IO.writeString((File)targetFile, (Charset)StandardCharsets.UTF_8, (String)txt);
                break;
            }
            default: {
                BufferedImage image = QrCodes.generate(content, width, height);
                Images.write((Image)image, (File)targetFile);
            }
        }
        return targetFile;
    }

    public static File generate(String content, QrConfig config, File targetFile) throws IOException {
        String extName;
        switch (extName = Filenames.extName((File)targetFile)) {
            case "svg": {
                String svg = QrCodes.generateAsSvg(content, config);
                IO.writeString((File)targetFile, (Charset)StandardCharsets.UTF_8, (String)svg);
                break;
            }
            case "txt": {
                String txt = QrCodes.generateAsAsciiArt(content, config);
                IO.writeString((File)targetFile, (Charset)StandardCharsets.UTF_8, (String)txt);
                break;
            }
            default: {
                BufferedImage image = QrCodes.generate(content, config);
                Images.write((Image)image, (File)targetFile);
            }
        }
        return targetFile;
    }

    public static void generate(String content, int width, int height, String targetType, OutputStream out) throws IOException {
        switch (targetType) {
            case "svg": {
                String svg = QrCodes.generateAsSvg(content, new QrConfig(width, height));
                IO.writeString((OutputStream)out, (Charset)StandardCharsets.UTF_8, (String[])new String[]{svg});
                break;
            }
            case "txt": {
                String txt = QrCodes.generateAsAsciiArt(content, new QrConfig(width, height));
                IO.writeString((OutputStream)out, (Charset)StandardCharsets.UTF_8, (String[])new String[]{txt});
                break;
            }
            default: {
                BufferedImage image = QrCodes.generate(content, width, height);
                Images.write((Image)image, (String)targetType, (OutputStream)out);
            }
        }
    }

    public static void generate(String content, QrConfig config, String targetType, OutputStream out) throws IOException {
        switch (targetType) {
            case "svg": {
                String svg = QrCodes.generateAsSvg(content, config);
                IO.writeString((OutputStream)out, (Charset)StandardCharsets.UTF_8, (String[])new String[]{svg});
                break;
            }
            case "txt": {
                String txt = QrCodes.generateAsAsciiArt(content, config);
                IO.writeString((OutputStream)out, (Charset)StandardCharsets.UTF_8, (String[])new String[]{txt});
                break;
            }
            default: {
                BufferedImage image = QrCodes.generate(content, config);
                Images.write((Image)image, (String)targetType, (OutputStream)out);
            }
        }
    }

    public static BufferedImage generate(String content, int width, int height) throws IOException {
        return QrCodes.generate(content, new QrConfig(width, height));
    }

    public static BufferedImage generate(String content, BarcodeFormat format, int width, int height) throws IOException {
        return QrCodes.generate(content, format, new QrConfig(width, height));
    }

    public static BufferedImage generate(String content, QrConfig config) throws IOException {
        return QrCodes.generate(content, BarcodeFormat.QR_CODE, config);
    }

    public static BufferedImage generate(String content, BarcodeFormat format, QrConfig config) throws IOException {
        BitMatrix bitMatrix = QrCodes.encode(content, format, config);
        BufferedImage image = QrCodes.toImage(bitMatrix, config.foreColor != null ? config.foreColor.intValue() : Color.BLACK.getRGB(), config.backColor);
        Image logoImg = config.img;
        if (null != logoImg && BarcodeFormat.QR_CODE == format) {
            int height;
            int width;
            int qrHeight;
            int qrWidth = image.getWidth();
            if (qrWidth < (qrHeight = image.getHeight())) {
                width = qrWidth / config.ratio;
                height = logoImg.getHeight(null) * width / logoImg.getWidth(null);
            } else {
                height = qrHeight / config.ratio;
                width = logoImg.getWidth(null) * height / logoImg.getHeight(null);
            }
            ImageEditor.from((Image)image).pressImage(ImageEditor.from((Image)logoImg).round(0.3).getImg(), new Rectangle(width, height), 1.0f);
        }
        return image;
    }

    public static BitMatrix encode(String content, int width, int height) throws IOException {
        return QrCodes.encode(content, BarcodeFormat.QR_CODE, width, height);
    }

    public static BitMatrix encode(String content, QrConfig config) throws IOException {
        return QrCodes.encode(content, BarcodeFormat.QR_CODE, config);
    }

    public static BitMatrix encode(String content, BarcodeFormat format, int width, int height) throws IOException {
        return QrCodes.encode(content, format, new QrConfig(width, height));
    }

    public static BitMatrix encode(String content, BarcodeFormat format, QrConfig config) throws IOException {
        BitMatrix bitMatrix;
        MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
        if (null == config) {
            config = new QrConfig();
        }
        try {
            bitMatrix = multiFormatWriter.encode(content, format, config.width, config.height, config.toHints(format));
        }
        catch (WriterException e) {
            throw new IOException(e);
        }
        return bitMatrix;
    }

    public static String decode(InputStream qrCodeInputStream) throws IOException {
        return QrCodes.decode(Images.read((InputStream)qrCodeInputStream));
    }

    public static String decode(File qrCodeFile) throws IOException {
        return QrCodes.decode(Images.read((File)qrCodeFile));
    }

    public static String decode(Image image) {
        return QrCodes.decode(image, true, false);
    }

    public static String decode(Image image, boolean isTryHarder, boolean isPureBarcode) {
        return QrCodes.decode(image, QrCodes.buildHints(isTryHarder, isPureBarcode));
    }

    public static String decode(Image image, Map<DecodeHintType, Object> hints) {
        MultiFormatReader formatReader = new MultiFormatReader();
        formatReader.setHints(hints);
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(Images.toBufferedImage((Image)image));
        Result result = QrCodes._decode(formatReader, (Binarizer)new HybridBinarizer((LuminanceSource)source));
        if (null == result) {
            result = QrCodes._decode(formatReader, (Binarizer)new GlobalHistogramBinarizer((LuminanceSource)source));
        }
        return null != result ? result.getText() : null;
    }

    public static BufferedImage toImage(BitMatrix matrix, int foreColor, Integer backColor) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, null == backColor ? 2 : 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (matrix.get(x, y)) {
                    image.setRGB(x, y, foreColor);
                    continue;
                }
                if (null == backColor) continue;
                image.setRGB(x, y, backColor);
            }
        }
        return image;
    }

    public static String toSVG(BitMatrix matrix, QrConfig qrConfig) throws IOException {
        return QrCodes.toSVG(matrix, qrConfig.foreColor, qrConfig.backColor, qrConfig.img, qrConfig.getRatio());
    }

    public static String toSVG(BitMatrix matrix, Integer foreColor, Integer backColor, Image logoImg, int ratio) throws IOException {
        StringBuilder sb = new StringBuilder();
        int qrWidth = matrix.getWidth();
        int qrHeight = matrix.getHeight();
        int moduleHeight = qrHeight == 1 ? qrWidth / 2 : 1;
        for (int y = 0; y < qrHeight; ++y) {
            for (int x = 0; x < qrWidth; ++x) {
                if (!matrix.get(x, y)) continue;
                sb.append(" M").append(x).append(",").append(y).append("h1v").append(moduleHeight).append("h-1z");
            }
        }
        qrHeight *= moduleHeight;
        String logoBase64 = "";
        int logoWidth = 0;
        int logoHeight = 0;
        int logoX = 0;
        int logoY = 0;
        if (logoImg != null) {
            logoBase64 = Images.toBase64DataUri((Image)logoImg, (String)"png");
            if (qrWidth < qrHeight) {
                logoWidth = qrWidth / ratio;
                logoHeight = logoImg.getHeight(null) * logoWidth / logoImg.getWidth(null);
            } else {
                logoHeight = qrHeight / ratio;
                logoWidth = logoImg.getWidth(null) * logoHeight / logoImg.getHeight(null);
            }
            logoX = (qrWidth - logoWidth) / 2;
            logoY = (qrHeight - logoHeight) / 2;
        }
        StringBuilder result = new StringBuilder();
        result.append("<svg width=\"").append(qrWidth).append("\" height=\"").append(qrHeight).append("\" \n");
        if (backColor != null) {
            Color back = new Color(backColor, true);
            result.append("style=\"background-color:rgba(").append(back.getRed()).append(",").append(back.getGreen()).append(",").append(back.getBlue()).append(",").append(back.getAlpha()).append(")\"\n");
        }
        result.append("viewBox=\"0 0 ").append(qrWidth).append(" ").append(qrHeight).append("\" \n");
        result.append("xmlns=\"http://www.w3.org/2000/svg\" \n");
        result.append("xmlns:xlink=\"http://www.w3.org/1999/xlink\" >\n");
        result.append("<path d=\"").append((CharSequence)sb).append("\" ");
        if (foreColor != null) {
            Color fore = new Color(foreColor, true);
            result.append("stroke=\"rgba(").append(fore.getRed()).append(",").append(fore.getGreen()).append(",").append(fore.getBlue()).append(",").append(fore.getAlpha()).append(")\"");
        }
        result.append(" /> \n");
        if (Strings.isNotBlank((CharSequence)logoBase64)) {
            result.append("<image xlink:href=\"").append(logoBase64).append("\" height=\"").append(logoHeight).append("\" width=\"").append(logoWidth).append("\" y=\"").append(logoY).append("\" x=\"").append(logoX).append("\" />\n");
        }
        result.append("</svg>");
        return result.toString();
    }

    public static String toAsciiArt(BitMatrix bitMatrix, QrConfig qrConfig) {
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        AnsiElement foreground = qrConfig.foreColor == null ? null : QrCodes.rgbToAnsi8BitElement(qrConfig.foreColor, ForeOrBack.FORE);
        AnsiElement background = qrConfig.backColor == null ? null : QrCodes.rgbToAnsi8BitElement(qrConfig.backColor, ForeOrBack.BACK);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i <= height; i += 2) {
            StringBuilder rowBuilder = new StringBuilder();
            for (int j = 0; j < width; ++j) {
                boolean bt;
                boolean tp = bitMatrix.get(i, j);
                boolean bl = bt = i + 1 >= height || bitMatrix.get(i + 1, j);
                if (tp && bt) {
                    rowBuilder.append(' ');
                    continue;
                }
                if (tp) {
                    rowBuilder.append('\u2584');
                    continue;
                }
                if (bt) {
                    rowBuilder.append('\u2580');
                    continue;
                }
                rowBuilder.append('\u2588');
            }
            builder.append(AnsiEncoder.encode((Object[])new Object[]{foreground, background, rowBuilder})).append('\n');
        }
        return builder.toString();
    }

    private static AnsiElement rgbToAnsi8BitElement(int rgb, ForeOrBack foreOrBack) {
        return ansiColors.findClosest(new Color(rgb)).toAnsiElement(foreOrBack);
    }

    private static Map<DecodeHintType, Object> buildHints(boolean isTryHarder, boolean isPureBarcode) {
        HashMap<DecodeHintType, Object> hints = new HashMap<DecodeHintType, Object>();
        hints.put(DecodeHintType.CHARACTER_SET, StandardCharsets.UTF_8);
        if (isTryHarder) {
            hints.put(DecodeHintType.TRY_HARDER, true);
        }
        if (isPureBarcode) {
            hints.put(DecodeHintType.PURE_BARCODE, true);
        }
        return hints;
    }

    private static Result _decode(MultiFormatReader formatReader, Binarizer binarizer) {
        try {
            return formatReader.decodeWithState(new BinaryBitmap(binarizer));
        }
        catch (NotFoundException e) {
            return null;
        }
    }
}

