/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.crypto;

import io.polaris.core.crypto.CryptoKeys;
import io.polaris.core.io.IO;
import io.polaris.core.string.Strings;
import io.polaris.crypto.ECKeys;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;

public class PemKeys {
    public static PrivateKey readPemPrivateKey(InputStream pemStream) throws GeneralSecurityException, IOException {
        return (PrivateKey)PemKeys.readPemKey(pemStream);
    }

    public static PublicKey readPemPublicKey(InputStream pemStream) throws GeneralSecurityException, IOException {
        return (PublicKey)PemKeys.readPemKey(pemStream);
    }

    public static Key readPemKey(InputStream keyStream) throws GeneralSecurityException, IOException {
        PemObject object = PemKeys.readPemObject(keyStream);
        String type = object.getType();
        if (Strings.isNotBlank((CharSequence)type)) {
            if (type.endsWith("EC PRIVATE KEY")) {
                try {
                    return CryptoKeys.generatePrivateKey((String)"EC", (byte[])object.getContent());
                }
                catch (Exception e) {
                    return CryptoKeys.generatePrivateKey((String)"EC", (KeySpec)ECKeys.createOpenSSHPrivateKeySpec(object.getContent()));
                }
            }
            if (type.endsWith("PRIVATE KEY")) {
                return CryptoKeys.generateRSAPrivateKey((byte[])object.getContent());
            }
            if (type.endsWith("EC PUBLIC KEY")) {
                try {
                    return CryptoKeys.generatePublicKey((String)"EC", (byte[])object.getContent());
                }
                catch (Exception e) {
                    return CryptoKeys.generatePublicKey((String)"EC", (KeySpec)ECKeys.createOpenSSHPublicKeySpec(object.getContent()));
                }
            }
            if (type.endsWith("PUBLIC KEY")) {
                return CryptoKeys.generateRSAPublicKey((byte[])object.getContent());
            }
            if (type.endsWith("CERTIFICATE")) {
                return CryptoKeys.readPublicKeyByX509((InputStream)new ByteArrayInputStream(object.getContent()));
            }
        }
        return null;
    }

    public static byte[] readPem(InputStream keyStream) throws IOException {
        PemObject pemObject = PemKeys.readPemObject(keyStream);
        if (null != pemObject) {
            return pemObject.getContent();
        }
        return null;
    }

    public static PemObject readPemObject(InputStream keyStream) throws IOException {
        return PemKeys.readPemObject(IO.toBufferedReader((InputStream)keyStream, (Charset)StandardCharsets.UTF_8));
    }

    public static PemObject readPemObject(Reader reader) throws IOException {
        PemObject pemObject;
        PemReader pemReader = null;
        try {
            pemReader = new PemReader(reader);
            pemObject = pemReader.readPemObject();
        }
        catch (Throwable throwable) {
            IO.close(pemReader);
            throw throwable;
        }
        IO.close((AutoCloseable)pemReader);
        return pemObject;
    }

    @Deprecated
    public static PrivateKey readSm2PemPrivateKey(InputStream keyStream) throws GeneralSecurityException, IOException {
        return PemKeys.readPemPrivateKey(keyStream);
    }

    public static String toPem(String type, byte[] content) throws IOException {
        StringWriter stringWriter = new StringWriter();
        PemKeys.writePemObject(type, content, stringWriter);
        return stringWriter.toString();
    }

    public static void writePemObject(String type, byte[] content, OutputStream keyStream) throws IOException {
        PemKeys.writePemObject((PemObjectGenerator)new PemObject(type, content), keyStream);
    }

    public static void writePemObject(String type, byte[] content, Writer writer) throws IOException {
        PemKeys.writePemObject((PemObjectGenerator)new PemObject(type, content), writer);
    }

    public static void writePemObject(PemObjectGenerator pemObject, OutputStream keyStream) throws IOException {
        PemKeys.writePemObject(pemObject, IO.getWriter((OutputStream)keyStream, (Charset)StandardCharsets.UTF_8));
    }

    public static void writePemObject(PemObjectGenerator pemObject, Writer writer) throws IOException {
        PemWriter pemWriter = new PemWriter(writer);
        try {
            pemWriter.writeObject(pemObject);
        }
        finally {
            IO.close((AutoCloseable)pemWriter);
        }
    }
}

