/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.crypto;

import io.polaris.core.crypto.CryptoKeys;
import io.polaris.core.crypto.asymmetric.AsymmetricAlgorithm;
import io.polaris.crypto.SmUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import java.util.Base64;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jcajce.spec.OpenSSHPrivateKeySpec;
import org.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.util.BigIntegers;

public class ECKeys {
    public static AsymmetricKeyParameter toParams(Key key) throws InvalidKeyException {
        if (key instanceof PrivateKey) {
            return ECKeys.toPrivateParams((PrivateKey)key);
        }
        if (key instanceof PublicKey) {
            return ECKeys.toPublicParams((PublicKey)key);
        }
        return null;
    }

    public static ECPublicKeyParameters getPublicParams(ECPrivateKeyParameters privateKeyParameters) {
        ECDomainParameters domainParameters = privateKeyParameters.getParameters();
        ECPoint q = new FixedPointCombMultiplier().multiply(domainParameters.getG(), privateKeyParameters.getD());
        return new ECPublicKeyParameters(q, domainParameters);
    }

    public static ECPublicKeyParameters toSm2PublicParams(byte[] q) {
        return ECKeys.toPublicParams(q, SmUtils.SM2_DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters toSm2PublicParams(String q) {
        return ECKeys.toPublicParams(q, SmUtils.SM2_DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters toSm2PublicParams(String x, String y) {
        return ECKeys.toPublicParams(x, y, SmUtils.SM2_DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters toSm2PublicParams(byte[] xBytes, byte[] yBytes) {
        return ECKeys.toPublicParams(xBytes, yBytes, SmUtils.SM2_DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters toPublicParams(String x, String y, ECDomainParameters domainParameters) {
        return ECKeys.toPublicParams(Base64.getDecoder().decode(x), Base64.getDecoder().decode(y), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(byte[] xBytes, byte[] yBytes, ECDomainParameters domainParameters) {
        if (null == xBytes || null == yBytes) {
            return null;
        }
        return ECKeys.toPublicParams(BigIntegers.fromUnsignedByteArray((byte[])xBytes), BigIntegers.fromUnsignedByteArray((byte[])yBytes), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(BigInteger x, BigInteger y, ECDomainParameters domainParameters) {
        if (null == x || null == y) {
            return null;
        }
        ECCurve curve = domainParameters.getCurve();
        return ECKeys.toPublicParams(curve.createPoint(x, y), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(String pointEncoded, ECDomainParameters domainParameters) {
        ECCurve curve = domainParameters.getCurve();
        return ECKeys.toPublicParams(curve.decodePoint(Base64.getDecoder().decode(pointEncoded)), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(byte[] pointEncoded, ECDomainParameters domainParameters) {
        ECCurve curve = domainParameters.getCurve();
        return ECKeys.toPublicParams(curve.decodePoint(pointEncoded), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(ECPoint point, ECDomainParameters domainParameters) {
        return new ECPublicKeyParameters(point, domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(PublicKey publicKey) throws InvalidKeyException {
        if (null == publicKey) {
            return null;
        }
        return (ECPublicKeyParameters)ECUtil.generatePublicKeyParameter((PublicKey)publicKey);
    }

    public static ECPrivateKeyParameters toSm2PrivateParams(String d) {
        return ECKeys.toPrivateParams(d, SmUtils.SM2_DOMAIN_PARAMS);
    }

    public static ECPrivateKeyParameters toSm2PrivateParams(byte[] d) {
        return ECKeys.toPrivateParams(d, SmUtils.SM2_DOMAIN_PARAMS);
    }

    public static ECPrivateKeyParameters toSm2PrivateParams(BigInteger d) {
        return ECKeys.toPrivateParams(d, SmUtils.SM2_DOMAIN_PARAMS);
    }

    public static ECPrivateKeyParameters toPrivateParams(String d, ECDomainParameters domainParameters) {
        if (null == d) {
            return null;
        }
        return ECKeys.toPrivateParams(BigIntegers.fromUnsignedByteArray((byte[])Base64.getDecoder().decode(d)), domainParameters);
    }

    public static ECPrivateKeyParameters toPrivateParams(byte[] d, ECDomainParameters domainParameters) {
        return ECKeys.toPrivateParams(BigIntegers.fromUnsignedByteArray((byte[])d), domainParameters);
    }

    public static ECPrivateKeyParameters toPrivateParams(BigInteger d, ECDomainParameters domainParameters) {
        if (null == d) {
            return null;
        }
        return new ECPrivateKeyParameters(d, domainParameters);
    }

    public static ECPrivateKeyParameters toPrivateParams(PrivateKey privateKey) throws InvalidKeyException {
        if (null == privateKey) {
            return null;
        }
        return (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)privateKey);
    }

    public static PrivateKey toSm2PrivateKey(ECPrivateKey privateKey) throws IOException, GeneralSecurityException {
        PrivateKeyInfo info = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)SmUtils.ID_SM2_PUBLIC_KEY_PARAM), (ASN1Encodable)privateKey);
        return CryptoKeys.generatePrivateKey((String)AsymmetricAlgorithm.SM2.code(), (byte[])info.getEncoded());
    }

    public static KeySpec createOpenSSHPrivateKeySpec(byte[] key) {
        return new OpenSSHPrivateKeySpec(key);
    }

    public static KeySpec createOpenSSHPublicKeySpec(byte[] key) {
        return new OpenSSHPublicKeySpec(key);
    }

    public static ECPrivateKeyParameters decodePrivateKeyParams(byte[] privateKeyBytes) throws GeneralSecurityException {
        try {
            return ECKeys.toSm2PrivateParams(privateKeyBytes);
        }
        catch (Exception exception) {
            PrivateKey privateKey;
            try {
                privateKey = CryptoKeys.generatePrivateKey((String)"sm2", (byte[])privateKeyBytes);
            }
            catch (Exception ignore) {
                privateKey = CryptoKeys.generatePrivateKey((String)"sm2", (KeySpec)ECKeys.createOpenSSHPrivateKeySpec(privateKeyBytes));
            }
            return ECKeys.toPrivateParams(privateKey);
        }
    }

    public static ECPublicKeyParameters decodePublicKeyParams(byte[] publicKeyBytes) throws GeneralSecurityException {
        try {
            return ECKeys.toSm2PublicParams(publicKeyBytes);
        }
        catch (Exception exception) {
            PublicKey publicKey;
            try {
                publicKey = CryptoKeys.generatePublicKey((String)"sm2", (byte[])publicKeyBytes);
            }
            catch (Exception ignore) {
                publicKey = CryptoKeys.generatePublicKey((String)"sm2", (KeySpec)ECKeys.createOpenSSHPublicKeySpec(publicKeyBytes));
            }
            return ECKeys.toPublicParams(publicKey);
        }
    }
}

