/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.crypto.asymmetric;

import io.polaris.crypto.ECKeys;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.DSAEncoding;
import org.bouncycastle.crypto.signers.PlainDSAEncoding;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.crypto.signers.StandardDSAEncoding;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.util.BigIntegers;

public class SM2 {
    private final Lock lock = new ReentrantLock();
    private DSAEncoding encoding = StandardDSAEncoding.INSTANCE;
    private Digest digest = new SM3Digest();
    private SM2Engine.Mode mode = SM2Engine.Mode.C1C3C2;
    private SM2Engine engine;
    private SM2Signer signer;
    private ECPrivateKeyParameters privateKeyParams;
    private ECPublicKeyParameters publicKeyParams;

    public SM2(ECPrivateKeyParameters privateKeyParams, ECPublicKeyParameters publicKeyParams) {
        this.privateKeyParams = privateKeyParams;
        this.publicKeyParams = publicKeyParams;
    }

    public SM2(PrivateKey privateKey, PublicKey publicKey) throws InvalidKeyException {
        this((ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)privateKey), (ECPublicKeyParameters)ECUtil.generatePublicKeyParameter((PublicKey)publicKey));
    }

    public SM2(byte[] privateKey, byte[] publicKey) throws GeneralSecurityException {
        this(ECKeys.decodePrivateKeyParams(privateKey), ECKeys.decodePublicKeyParams(publicKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encrypt(byte[] data) throws CryptoException {
        this.lock.lock();
        try {
            SM2Engine engine = this.getEngine();
            engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)this.publicKeyParams));
            byte[] byArray = engine.processBlock(data, 0, data.length);
            return byArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(byte[] data) throws CryptoException {
        this.lock.lock();
        try {
            SM2Engine engine = this.getEngine();
            engine.init(false, (CipherParameters)this.privateKeyParams);
            byte[] byArray = engine.processBlock(data, 0, data.length);
            return byArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    public byte[] sign(byte[] data) throws CryptoException {
        return this.sign(data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sign(byte[] data, byte[] id) throws CryptoException {
        this.lock.lock();
        try {
            SM2Signer signer = this.getSigner();
            ParametersWithRandom param = new ParametersWithRandom((CipherParameters)this.privateKeyParams);
            if (id != null) {
                param = new ParametersWithID((CipherParameters)param, id);
            }
            signer.init(true, (CipherParameters)param);
            signer.update(data, 0, data.length);
            byte[] byArray = signer.generateSignature();
            return byArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean verify(byte[] data, byte[] sign) {
        return this.verify(data, sign, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(byte[] data, byte[] sign, byte[] id) {
        this.lock.lock();
        try {
            SM2Signer signer = this.getSigner();
            ECPublicKeyParameters param = this.publicKeyParams;
            if (id != null) {
                param = new ParametersWithID((CipherParameters)param, id);
            }
            signer.init(false, (CipherParameters)param);
            signer.update(data, 0, data.length);
            boolean bl = signer.verifySignature(sign);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private SM2Engine getEngine() {
        if (null == this.engine) {
            this.engine = new SM2Engine(this.digest, this.mode);
        }
        this.digest.reset();
        return this.engine;
    }

    private SM2Signer getSigner() {
        if (null == this.signer) {
            this.signer = new SM2Signer(this.encoding, this.digest);
        }
        this.digest.reset();
        return this.signer;
    }

    public SM2 setMode(SM2Engine.Mode mode) {
        this.mode = mode;
        this.engine = null;
        return this;
    }

    public SM2 setDigest(Digest digest) {
        this.digest = digest;
        this.engine = null;
        this.signer = null;
        return this;
    }

    public SM2 setEncoding(DSAEncoding encoding) {
        this.encoding = encoding;
        this.signer = null;
        return this;
    }

    public SM2 usePlainEncoding() {
        return this.setEncoding((DSAEncoding)PlainDSAEncoding.INSTANCE);
    }

    public byte[] getD() {
        return BigIntegers.asUnsignedByteArray((int)32, (BigInteger)this.getDBigInteger());
    }

    public BigInteger getDBigInteger() {
        return this.privateKeyParams.getD();
    }

    public byte[] getQ(boolean isCompressed) {
        return this.publicKeyParams.getQ().getEncoded(isCompressed);
    }
}

