/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.crypto;

import io.polaris.core.crypto.CryptoKeys;
import io.polaris.core.crypto.asymmetric.AsymmetricAlgorithm;
import io.polaris.crypto.BCKeys;
import io.polaris.crypto.asymmetric.SM2;
import io.polaris.crypto.digest.SM3;
import io.polaris.crypto.symmetric.SM4;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.signers.StandardDSAEncoding;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class SmUtils {
    public static final String SM2_CURVE_NAME = "sm2p256v1";
    public static final ECDomainParameters SM2_DOMAIN_PARAMS = BCKeys.toDomainParams(GMNamedCurves.getByName((String)"sm2p256v1"));
    public static final ASN1ObjectIdentifier ID_SM2_PUBLIC_KEY_PARAM = new ASN1ObjectIdentifier("1.2.156.10197.1.301");
    private static final int RS_LEN = 32;

    public static SM2 sm2() throws GeneralSecurityException {
        KeyPair keyPair = CryptoKeys.generateKeyPair((String)AsymmetricAlgorithm.SM2.code());
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        return new SM2(privateKey, publicKey);
    }

    public static SM2 sm2(byte[] privateKey, byte[] publicKey) throws GeneralSecurityException {
        return new SM2(CryptoKeys.generatePrivateKey((String)AsymmetricAlgorithm.SM2.code(), (byte[])privateKey), CryptoKeys.generatePublicKey((String)AsymmetricAlgorithm.SM2.code(), (byte[])publicKey));
    }

    public static SM2 sm2(PrivateKey privateKey, PublicKey publicKey) throws GeneralSecurityException {
        return new SM2(privateKey, publicKey);
    }

    public static SM3 sm3() throws NoSuchAlgorithmException {
        return new SM3();
    }

    public static SM4 sm4() throws NoSuchAlgorithmException {
        return new SM4();
    }

    public static SM4 sm4(Key key) {
        return new SM4(key);
    }

    private static byte[] bigIntToFixedLengthBytes(BigInteger rOrS) {
        byte[] rs = rOrS.toByteArray();
        if (rs.length == 32) {
            return rs;
        }
        if (rs.length == 33 && rs[0] == 0) {
            return Arrays.copyOfRange((byte[])rs, (int)1, (int)33);
        }
        if (rs.length < 32) {
            byte[] result = new byte[32];
            Arrays.fill((byte[])result, (byte)0);
            System.arraycopy(rs, 0, result, 32 - rs.length, rs.length);
            return result;
        }
        throw new IllegalArgumentException("Error rs: " + Hex.toHexString((byte[])rs));
    }

    public static byte[] rsAsn1ToPlain(byte[] rsDer) throws IOException {
        BigInteger[] decode = StandardDSAEncoding.INSTANCE.decode(SM2_DOMAIN_PARAMS.getN(), rsDer);
        byte[] r = SmUtils.bigIntToFixedLengthBytes(decode[0]);
        byte[] s = SmUtils.bigIntToFixedLengthBytes(decode[1]);
        return Arrays.concatenate((byte[])r, (byte[])s);
    }

    public static byte[] rsPlainToAsn1(byte[] sign) throws IOException {
        if (sign.length != 64) {
            throw new IllegalArgumentException("err rs. ");
        }
        BigInteger r = new BigInteger(1, Arrays.copyOfRange((byte[])sign, (int)0, (int)32));
        BigInteger s = new BigInteger(1, Arrays.copyOfRange((byte[])sign, (int)32, (int)64));
        return StandardDSAEncoding.INSTANCE.encode(SM2_DOMAIN_PARAMS.getN(), r, s);
    }

    public static byte[] changeC1C2C3ToC1C3C2(byte[] c1c2c3, ECDomainParameters ecDomainParameters) {
        int c1Len = (ecDomainParameters.getCurve().getFieldSize() + 7) / 8 * 2 + 1;
        int c3Len = 32;
        byte[] result = new byte[c1c2c3.length];
        System.arraycopy(c1c2c3, 0, result, 0, c1Len);
        System.arraycopy(c1c2c3, c1c2c3.length - 32, result, c1Len, 32);
        System.arraycopy(c1c2c3, c1Len, result, c1Len + 32, c1c2c3.length - c1Len - 32);
        return result;
    }

    public static byte[] changeC1C3C2ToC1C2C3(byte[] c1c3c2, ECDomainParameters ecDomainParameters) {
        int c1Len = (ecDomainParameters.getCurve().getFieldSize() + 7) / 8 * 2 + 1;
        int c3Len = 32;
        byte[] result = new byte[c1c3c2.length];
        System.arraycopy(c1c3c2, 0, result, 0, c1Len);
        System.arraycopy(c1c3c2, c1Len + 32, result, c1Len, c1c3c2.length - c1Len - 32);
        System.arraycopy(c1c3c2, c1Len, result, c1c3c2.length - 32, 32);
        return result;
    }
}

