/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.annotation.processing;

import io.polaris.core.annotation.processing.BaseProcessor;
import io.polaris.core.javapoet.ClassName;
import io.polaris.core.javapoet.CodeBlock;
import io.polaris.core.javapoet.FieldSpec;
import io.polaris.core.javapoet.JavaFile;
import io.polaris.core.javapoet.MethodSpec;
import io.polaris.core.javapoet.ParameterSpec;
import io.polaris.core.javapoet.ParameterizedTypeName;
import io.polaris.core.javapoet.TypeName;
import io.polaris.core.javapoet.TypeSpec;
import io.polaris.core.javapoet.TypeVariableName;
import io.polaris.core.javapoet.WildcardTypeName;
import io.polaris.core.jdbc.ColumnMeta;
import io.polaris.core.jdbc.EntityMeta;
import io.polaris.core.jdbc.ExpressionMeta;
import io.polaris.core.jdbc.annotation.Table;
import io.polaris.core.jdbc.annotation.processing.JdbcBeanInfo;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"io.polaris.core.jdbc.annotation.Table"})
public class JdbcAnnotationProcessor
extends BaseProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(Table.class);
        set.forEach(element -> {
            if (!(element instanceof TypeElement)) {
                return;
            }
            JdbcBeanInfo beanInfo = new JdbcBeanInfo((TypeElement)element);
            this.generateMetaClass(beanInfo);
            this.generateSqlClass(beanInfo);
        });
        return true;
    }

    private void generateMetaClass(JdbcBeanInfo beanInfo) {
        ClassName className = beanInfo.getMetaClassName();
        ClassName entityMetaClassName = ClassName.get(EntityMeta.class);
        ClassName columnMetaClassName = ClassName.get(ColumnMeta.class);
        ClassName expressionMetaClassName = ClassName.get(ExpressionMeta.class);
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder(className).addModifiers(Modifier.PUBLIC).addSuperinterface(entityMetaClassName);
        ClassName fieldsClassName = className.nestedClass("FieldName");
        TypeSpec.Builder fieldsClassBuilder = TypeSpec.classBuilder(fieldsClassName).addModifiers(Modifier.PUBLIC, Modifier.STATIC);
        for (JdbcBeanInfo.FieldInfo fieldInfo : beanInfo.getFields()) {
            fieldsClassBuilder.addField(FieldSpec.builder(ClassName.get(String.class), fieldInfo.getFieldName(), Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL).initializer("$S", fieldInfo.getFieldName()).build());
        }
        for (JdbcBeanInfo.ExpressionInfo expressionInfo : beanInfo.getExpressions()) {
            fieldsClassBuilder.addField(FieldSpec.builder(ClassName.get(String.class), expressionInfo.getFieldName(), Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL).initializer("$S", expressionInfo.getFieldName()).build());
        }
        classBuilder.addType(fieldsClassBuilder.build());
        ClassName columnsClassName = className.nestedClass("ColumnName");
        TypeSpec.Builder columnsClassBuilder = TypeSpec.classBuilder(columnsClassName).addModifiers(Modifier.PUBLIC, Modifier.STATIC);
        for (JdbcBeanInfo.FieldInfo fieldInfo : beanInfo.getFields()) {
            columnsClassBuilder.addField(FieldSpec.builder(ClassName.get(String.class), fieldInfo.getFieldName(), Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL).initializer("$S", fieldInfo.getColumnName()).build());
        }
        for (JdbcBeanInfo.ExpressionInfo expressionInfo : beanInfo.getExpressions()) {
            columnsClassBuilder.addField(FieldSpec.builder(ClassName.get(String.class), expressionInfo.getFieldName(), Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL).initializer("$S", expressionInfo.getExpression()).build());
        }
        classBuilder.addType(columnsClassBuilder.build());
        ParameterizedTypeName columnMetaMapTypeName = ParameterizedTypeName.get(ClassName.get(Map.class), ClassName.get(String.class), columnMetaClassName);
        ParameterizedTypeName expressionMetaMapTypeName = ParameterizedTypeName.get(ClassName.get(Map.class), ClassName.get(String.class), expressionMetaClassName);
        classBuilder.addField(FieldSpec.builder(ClassName.get(String.class), "SCHEMA", Modifier.FINAL, Modifier.PUBLIC, Modifier.STATIC).initializer("$S", beanInfo.getTableSchema()).build());
        classBuilder.addField(FieldSpec.builder(ClassName.get(String.class), "CATALOG", Modifier.FINAL, Modifier.PUBLIC, Modifier.STATIC).initializer("$S", beanInfo.getTableCatalog()).build());
        classBuilder.addField(FieldSpec.builder(ClassName.get(String.class), "TABLE", Modifier.FINAL, Modifier.PUBLIC, Modifier.STATIC).initializer("$S", beanInfo.getTableName()).build());
        classBuilder.addField(FieldSpec.builder(ClassName.get(String.class), "ALIAS", Modifier.FINAL, Modifier.PUBLIC, Modifier.STATIC).initializer("$S", beanInfo.getTableAlias()).build());
        classBuilder.addField(FieldSpec.builder(columnMetaMapTypeName, "COLUMNS", Modifier.FINAL, Modifier.PUBLIC, Modifier.STATIC).build());
        classBuilder.addField(FieldSpec.builder(expressionMetaMapTypeName, "EXPRESSIONS", Modifier.FINAL, Modifier.PUBLIC, Modifier.STATIC).build());
        CodeBlock.Builder codeBlock = CodeBlock.builder().addStatement("$T map = new $T<>()", columnMetaMapTypeName, ClassName.get(LinkedHashMap.class));
        for (JdbcBeanInfo.FieldInfo fieldInfo : beanInfo.getFields()) {
            codeBlock.addStatement("map.put($S,$T.builder().schema($S).catalog($S).tableName($S).fieldName($S).fieldType($T.class).columnName($S).jdbcType($S).jdbcTypeValue($L).updateDefault($S).insertDefault($S).nullable($L).insertable($L).updatable($L).version($L).logicDeleted($L).createTime($L).updateTime($L).primaryKey($L).autoIncrement($L).seqName($S).build())", fieldInfo.getFieldName(), columnMetaClassName, beanInfo.getTableSchema(), beanInfo.getTableCatalog(), beanInfo.getTableName(), fieldInfo.getFieldName(), fieldInfo.getFieldRawTypeName(), fieldInfo.getColumnName(), fieldInfo.getJdbcTypeName(), fieldInfo.getJdbcTypeValue(), fieldInfo.getUpdateDefault(), fieldInfo.getInsertDefault(), fieldInfo.isNullable(), fieldInfo.isInsertable(), fieldInfo.isUpdatable(), fieldInfo.isVersion(), fieldInfo.isLogicDeleted(), fieldInfo.isCreateTime(), fieldInfo.isUpdateTime(), fieldInfo.isId(), fieldInfo.isAutoIncrement(), fieldInfo.getSeqName());
        }
        classBuilder.addStaticBlock(codeBlock.addStatement("COLUMNS = $T.unmodifiableMap(map)", ClassName.get(Collections.class)).build());
        codeBlock = CodeBlock.builder().addStatement("$T map = new $T<>()", expressionMetaMapTypeName, ClassName.get(LinkedHashMap.class));
        for (JdbcBeanInfo.ExpressionInfo expressionInfo : beanInfo.getExpressions()) {
            codeBlock.addStatement("map.put($S,$T.builder().schema($S).catalog($S).tableName($S).fieldName($S).fieldType($T.class).expression($S).jdbcType($S).jdbcTypeValue($L).tableAliasPlaceholder($S).selectable($L).build())", expressionInfo.getFieldName(), expressionMetaClassName, beanInfo.getTableSchema(), beanInfo.getTableCatalog(), beanInfo.getTableName(), expressionInfo.getFieldName(), expressionInfo.getFieldRawTypeName(), expressionInfo.getExpression(), expressionInfo.getJdbcTypeName(), expressionInfo.getJdbcTypeValue(), expressionInfo.getTableAliasPlaceholder(), expressionInfo.isSelectable());
        }
        classBuilder.addStaticBlock(codeBlock.addStatement("EXPRESSIONS = $T.unmodifiableMap(map)", ClassName.get(Collections.class)).build());
        JavaFile javaFile = JavaFile.builder(className.packageName(), classBuilder.build()).build();
        try {
            javaFile.writeTo(this.filer);
        }
        catch (IOException iOException) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, iOException.toString());
            iOException.printStackTrace();
        }
    }

    private void generateSqlClass(JdbcBeanInfo beanInfo) {
        String fieldName;
        String fieldName2;
        if (!beanInfo.isSqlGenerated()) {
            return;
        }
        TypeName beanTypeName = beanInfo.getBeanTypeName();
        ClassName beanClassName = beanInfo.getBeanClassName();
        ClassName sqlClassName = beanInfo.getSqlClassName();
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder(sqlClassName).addModifiers(Modifier.PUBLIC);
        ClassName classNameTextNode = ClassName.get("io.polaris.core.jdbc.sql.node", "TextNode", new String[0]);
        ClassName classNameBaseSelect = ClassName.get("io.polaris.core.jdbc.sql.statement", "SelectStatement", new String[0]);
        ClassName classNameBaseInsert = ClassName.get("io.polaris.core.jdbc.sql.statement", "InsertStatement", new String[0]);
        ClassName classNameBaseUpdate = ClassName.get("io.polaris.core.jdbc.sql.statement", "UpdateStatement", new String[0]);
        ClassName classNameBaseDelete = ClassName.get("io.polaris.core.jdbc.sql.statement", "DeleteStatement", new String[0]);
        ClassName classNameSegment = ClassName.get("io.polaris.core.jdbc.sql.statement", "Segment", new String[0]);
        ClassName classNameBaseCol = ClassName.get("io.polaris.core.jdbc.sql.statement.segment", "SelectSegment", new String[0]);
        ClassName classNameBaseTable = ClassName.get("io.polaris.core.jdbc.sql.statement.segment", "TableSegment", new String[0]);
        ClassName classNameBaseJoin = ClassName.get("io.polaris.core.jdbc.sql.statement.segment", "JoinSegment", new String[0]);
        ClassName classNameBaseGroupBy = ClassName.get("io.polaris.core.jdbc.sql.statement.segment", "GroupBySegment", new String[0]);
        ClassName classNameBaseOrderBy = ClassName.get("io.polaris.core.jdbc.sql.statement.segment", "OrderBySegment", new String[0]);
        ClassName classNameBaseAnd = ClassName.get("io.polaris.core.jdbc.sql.statement.segment", "AndSegment", new String[0]);
        ClassName classNameBaseOr = ClassName.get("io.polaris.core.jdbc.sql.statement.segment", "OrSegment", new String[0]);
        ClassName classNameBaseCriterion = ClassName.get("io.polaris.core.jdbc.sql.statement.segment", "CriterionSegment", new String[0]);
        ClassName classNameJoinBuilder = ClassName.get("io.polaris.core.jdbc.sql.statement.segment", "JoinBuilder", new String[0]);
        ClassName classNameColumnSegment = ClassName.get("io.polaris.core.jdbc.sql.statement.segment", "ColumnSegment", new String[0]);
        ClassName classNameSelect = sqlClassName.nestedClass("Select");
        ClassName classNameInsert = sqlClassName.nestedClass("Insert");
        ClassName classNameUpdate = sqlClassName.nestedClass("Update");
        ClassName classNameDelete = sqlClassName.nestedClass("Delete");
        ClassName classNameSelectCol = sqlClassName.nestedClass("SelectCol");
        ClassName classNameJoin = sqlClassName.nestedClass("Join");
        ClassName classNameGroupBy = sqlClassName.nestedClass("GroupBy");
        ClassName classNameOrderBy = sqlClassName.nestedClass("OrderBy");
        ClassName classNameAnd = sqlClassName.nestedClass("And");
        ClassName classNameOr = sqlClassName.nestedClass("Or");
        TypeSpec.Builder nestedBuilder = TypeSpec.classBuilder(classNameSelect).addModifiers(Modifier.PUBLIC, Modifier.STATIC).superclass(ParameterizedTypeName.get(classNameBaseSelect, classNameSelect));
        nestedBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addStatement("super($T.class)", beanClassName).build());
        nestedBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(ParameterSpec.builder(ClassName.get(String.class), "alias", new Modifier[0]).build()).addStatement("super($T.class, alias)", beanClassName).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder("buildSelect").addAnnotation(Override.class).addModifiers(Modifier.PROTECTED).returns(ParameterizedTypeName.get(classNameSelectCol, classNameSelect)).addStatement("return new $T<>(getThis(), getTable())", classNameSelectCol).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder("buildWhere").addAnnotation(Override.class).addModifiers(Modifier.PROTECTED).returns(ParameterizedTypeName.get(classNameAnd, classNameSelect)).addStatement("return new $T<>(getThis(), getTable())", classNameAnd).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder("buildGroupBy").addAnnotation(Override.class).addModifiers(Modifier.PROTECTED).returns(ParameterizedTypeName.get(classNameGroupBy, classNameSelect)).addStatement("return new $T<>(getThis(), getTable())", classNameGroupBy).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder("buildOrderBy").addAnnotation(Override.class).addModifiers(Modifier.PROTECTED).returns(ParameterizedTypeName.get(classNameOrderBy, classNameSelect)).addStatement("return new $T<>(getThis(), getTable())", classNameOrderBy).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder("select").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameSelectCol, classNameSelect)).addStatement("return super.select()", new Object[0]).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder("where").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameAnd, classNameSelect)).addStatement("return super.where()", new Object[0]).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder("groupBy").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameGroupBy, classNameSelect)).addStatement("return super.groupBy()", new Object[0]).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder("having").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameAnd, classNameSelect)).addStatement("return super.having()", new Object[0]).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder("orderBy").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameOrderBy, classNameSelect)).addStatement("return super.orderBy()", new Object[0]).build());
        for (JdbcBeanInfo.FieldInfo field : beanInfo.getFields()) {
            fieldName2 = field.getFieldName();
            nestedBuilder.addMethod(MethodSpec.methodBuilder(fieldName2).addModifiers(Modifier.PUBLIC).returns(classNameSelect).addStatement("return select($S)", fieldName2).build());
            nestedBuilder.addMethod(MethodSpec.methodBuilder(fieldName2).addModifiers(Modifier.PUBLIC).returns(classNameSelect).addParameter(ParameterSpec.builder(ClassName.get(String.class), "alias", new Modifier[0]).build()).addStatement("return select($S, alias)", fieldName2).build());
        }
        for (JdbcBeanInfo.ExpressionInfo expression : beanInfo.getExpressions()) {
            fieldName2 = expression.getFieldName();
            nestedBuilder.addMethod(MethodSpec.methodBuilder(fieldName2).addModifiers(Modifier.PUBLIC).returns(classNameSelect).addStatement("return select($S)", fieldName2).build());
            nestedBuilder.addMethod(MethodSpec.methodBuilder(fieldName2).addModifiers(Modifier.PUBLIC).returns(classNameSelect).addParameter(ParameterSpec.builder(ClassName.get(String.class), "alias", new Modifier[0]).build()).addStatement("return select($S, alias)", fieldName2).build());
        }
        classBuilder.addType(nestedBuilder.build());
        nestedBuilder = TypeSpec.classBuilder(classNameInsert).addModifiers(Modifier.PUBLIC, Modifier.STATIC).superclass(ParameterizedTypeName.get(classNameBaseInsert, classNameInsert));
        nestedBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addStatement("super($T.class)", beanClassName).build());
        nestedBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(ParameterSpec.builder(ClassName.get(String.class), "alias", new Modifier[0]).build()).addStatement("super($T.class, alias)", beanClassName).build());
        for (JdbcBeanInfo.FieldInfo field : beanInfo.getFields()) {
            fieldName2 = field.getFieldName();
            nestedBuilder.addMethod(MethodSpec.methodBuilder(fieldName2).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameColumnSegment, classNameInsert, WildcardTypeName.subtypeOf(TypeName.OBJECT))).addStatement("return column($S)", fieldName2).build());
            nestedBuilder.addMethod(MethodSpec.methodBuilder(fieldName2).addModifiers(Modifier.PUBLIC).returns(classNameInsert).addParameter(ParameterSpec.builder(TypeName.OBJECT, "value", new Modifier[0]).build()).addStatement("return column($S, value)", fieldName2).build());
            nestedBuilder.addMethod(MethodSpec.methodBuilder(fieldName2).addModifiers(Modifier.PUBLIC).returns(classNameInsert).addParameter(ParameterSpec.builder(TypeName.OBJECT, "value", new Modifier[0]).build()).addParameter(ParameterSpec.builder(ParameterizedTypeName.get(ClassName.get(BiPredicate.class), ClassName.get(String.class), TypeName.OBJECT), "predicate", new Modifier[0]).build()).addStatement("return column($S, value, predicate)", fieldName2).build());
            nestedBuilder.addMethod(MethodSpec.methodBuilder(fieldName2).addModifiers(Modifier.PUBLIC).returns(classNameInsert).addParameter(ParameterSpec.builder(TypeName.OBJECT, "value", new Modifier[0]).build()).addParameter(ParameterSpec.builder(ParameterizedTypeName.get(ClassName.get(Supplier.class), ClassName.get(Boolean.class)), "predicate", new Modifier[0]).build()).addStatement("return column($S, value, predicate)", fieldName2).build());
        }
        classBuilder.addType(nestedBuilder.build());
        nestedBuilder = TypeSpec.classBuilder(classNameUpdate).addModifiers(Modifier.PUBLIC, Modifier.STATIC).superclass(ParameterizedTypeName.get(classNameBaseUpdate, classNameUpdate));
        nestedBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addStatement("super($T.class)", beanClassName).build());
        nestedBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(ParameterSpec.builder(ClassName.get(String.class), "alias", new Modifier[0]).build()).addStatement("super($T.class, alias)", beanClassName).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder("buildWhere").addAnnotation(Override.class).addModifiers(Modifier.PROTECTED).returns(ParameterizedTypeName.get(classNameAnd, classNameUpdate)).addStatement("return new $T<>(getThis(), getTable())", classNameAnd).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder("where").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameAnd, classNameUpdate)).addStatement("return super.where()", new Object[0]).build());
        for (JdbcBeanInfo.FieldInfo field : beanInfo.getFields()) {
            fieldName2 = field.getFieldName();
            nestedBuilder.addMethod(MethodSpec.methodBuilder(fieldName2).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameColumnSegment, classNameUpdate, WildcardTypeName.subtypeOf(TypeName.OBJECT))).addStatement("return column($S)", fieldName2).build());
            nestedBuilder.addMethod(MethodSpec.methodBuilder(fieldName2).addModifiers(Modifier.PUBLIC).returns(classNameUpdate).addParameter(ParameterSpec.builder(TypeName.OBJECT, "value", new Modifier[0]).build()).addStatement("return column($S, value)", fieldName2).build());
            nestedBuilder.addMethod(MethodSpec.methodBuilder(fieldName2).addModifiers(Modifier.PUBLIC).returns(classNameUpdate).addParameter(ParameterSpec.builder(TypeName.OBJECT, "value", new Modifier[0]).build()).addParameter(ParameterSpec.builder(ParameterizedTypeName.get(ClassName.get(BiPredicate.class), ClassName.get(String.class), TypeName.OBJECT), "predicate", new Modifier[0]).build()).addStatement("return column($S, value, predicate)", fieldName2).build());
            nestedBuilder.addMethod(MethodSpec.methodBuilder(fieldName2).addModifiers(Modifier.PUBLIC).returns(classNameUpdate).addParameter(ParameterSpec.builder(TypeName.OBJECT, "value", new Modifier[0]).build()).addParameter(ParameterSpec.builder(ParameterizedTypeName.get(ClassName.get(Supplier.class), ClassName.get(Boolean.class)), "predicate", new Modifier[0]).build()).addStatement("return column($S, value, predicate)", fieldName2).build());
        }
        classBuilder.addType(nestedBuilder.build());
        nestedBuilder = TypeSpec.classBuilder(classNameDelete).addModifiers(Modifier.PUBLIC, Modifier.STATIC).superclass(ParameterizedTypeName.get(classNameBaseDelete, classNameDelete));
        nestedBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addStatement("super($T.class)", beanClassName).build());
        nestedBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(ParameterSpec.builder(ClassName.get(String.class), "alias", new Modifier[0]).build()).addStatement("super($T.class, alias)", beanClassName).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder("buildWhere").addAnnotation(Override.class).addModifiers(Modifier.PROTECTED).returns(ParameterizedTypeName.get(classNameAnd, classNameDelete)).addStatement("return new $T<>(getThis(), getTable())", classNameAnd).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder("where").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameAnd, classNameDelete)).addStatement("return super.where()", new Object[0]).build());
        classBuilder.addType(nestedBuilder.build());
        nestedBuilder = TypeSpec.classBuilder(classNameSelectCol).addModifiers(Modifier.PUBLIC, Modifier.STATIC).addTypeVariable(TypeVariableName.get("O", ParameterizedTypeName.get(classNameSegment, TypeVariableName.get("O")))).superclass(ParameterizedTypeName.get(classNameBaseCol, TypeVariableName.get("O"), ParameterizedTypeName.get(classNameSelectCol, TypeVariableName.get("O"))));
        nestedBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(ParameterSpec.builder(TypeVariableName.get("O"), "owner", new Modifier[0]).build()).addParameter(ParameterSpec.builder(ParameterizedTypeName.get(classNameBaseTable, WildcardTypeName.subtypeOf(ParameterizedTypeName.get(classNameBaseTable, WildcardTypeName.subtypeOf(TypeName.OBJECT)))), "table", new Modifier[0]).build()).addStatement("super(owner, table)", new Object[0]).build());
        for (JdbcBeanInfo.FieldInfo field : beanInfo.getFields()) {
            fieldName2 = field.getFieldName();
            nestedBuilder.addMethod(MethodSpec.methodBuilder(fieldName2).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameSelectCol, TypeVariableName.get("O"))).addStatement("return column($S)", fieldName2).build());
        }
        for (JdbcBeanInfo.ExpressionInfo expression : beanInfo.getExpressions()) {
            fieldName2 = expression.getFieldName();
            nestedBuilder.addMethod(MethodSpec.methodBuilder(fieldName2).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameSelectCol, TypeVariableName.get("O"))).addStatement("return column($S)", fieldName2).build());
        }
        classBuilder.addType(nestedBuilder.build());
        nestedBuilder = TypeSpec.classBuilder(classNameJoin).addModifiers(Modifier.PUBLIC, Modifier.STATIC).addTypeVariable(TypeVariableName.get("O", ParameterizedTypeName.get(classNameBaseSelect, TypeVariableName.get("O")))).superclass(ParameterizedTypeName.get(classNameBaseJoin, TypeVariableName.get("O"), ParameterizedTypeName.get(classNameJoin, TypeVariableName.get("O"))));
        nestedBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(ParameterSpec.builder(TypeVariableName.get("O"), "owner", new Modifier[0]).build()).addParameter(ParameterSpec.builder(classNameTextNode, "conj", new Modifier[0]).build()).addParameter(ParameterSpec.builder(ParameterizedTypeName.get(ClassName.get(Class.class), WildcardTypeName.subtypeOf(TypeName.OBJECT)), "entityClass", new Modifier[0]).build()).addParameter(ParameterSpec.builder(ClassName.get(String.class), "alias", new Modifier[0]).build()).addStatement("super(owner, conj, entityClass, alias)", new Object[0]).build());
        nestedBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(ParameterSpec.builder(TypeVariableName.get("O"), "owner", new Modifier[0]).build()).addParameter(ParameterSpec.builder(classNameTextNode, "conj", new Modifier[0]).build()).addParameter(ParameterSpec.builder(ParameterizedTypeName.get(classNameBaseSelect, WildcardTypeName.subtypeOf(TypeName.OBJECT)), "select", new Modifier[0]).build()).addParameter(ParameterSpec.builder(ClassName.get(String.class), "alias", new Modifier[0]).build()).addStatement("super(owner, conj, select, alias)", new Object[0]).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder("builder").addModifiers(Modifier.PUBLIC, Modifier.STATIC).addTypeVariable(TypeVariableName.get("O", ParameterizedTypeName.get(classNameBaseSelect, TypeVariableName.get("O")))).returns(ParameterizedTypeName.get(classNameJoinBuilder, TypeVariableName.get("O"), ParameterizedTypeName.get(classNameJoin, TypeVariableName.get("O")))).addStatement("return (statement, conj, alias) -> new $T<>(statement, conj, $T.class, alias)", classNameJoin, beanClassName).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder("buildSelect").addAnnotation(Override.class).addModifiers(Modifier.PROTECTED).returns(ParameterizedTypeName.get(classNameSelectCol, ParameterizedTypeName.get(classNameJoin, TypeVariableName.get("O")))).addStatement("return new $T<>(getThis(), getTable())", classNameSelectCol).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder("buildWhere").addAnnotation(Override.class).addModifiers(Modifier.PROTECTED).returns(ParameterizedTypeName.get(classNameAnd, ParameterizedTypeName.get(classNameJoin, TypeVariableName.get("O")))).addStatement("return new $T<>(getThis(), getTable())", classNameAnd).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder("buildGroupBy").addAnnotation(Override.class).addModifiers(Modifier.PROTECTED).returns(ParameterizedTypeName.get(classNameGroupBy, ParameterizedTypeName.get(classNameJoin, TypeVariableName.get("O")))).addStatement("return new $T<>(getThis(), getTable())", classNameGroupBy).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder("buildOrderBy").addAnnotation(Override.class).addModifiers(Modifier.PROTECTED).returns(ParameterizedTypeName.get(classNameOrderBy, ParameterizedTypeName.get(classNameJoin, TypeVariableName.get("O")))).addStatement("return new $T<>(getThis(), getTable())", classNameOrderBy).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder("on").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameAnd, ParameterizedTypeName.get(classNameJoin, TypeVariableName.get("O")))).addStatement("return super.on()", new Object[0]).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder("where").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameAnd, ParameterizedTypeName.get(classNameJoin, TypeVariableName.get("O")))).addStatement("return super.where()", new Object[0]).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder("select").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameSelectCol, ParameterizedTypeName.get(classNameJoin, TypeVariableName.get("O")))).addStatement("return super.select()", new Object[0]).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder("groupBy").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameGroupBy, ParameterizedTypeName.get(classNameJoin, TypeVariableName.get("O")))).addStatement("return super.groupBy()", new Object[0]).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder("having").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameAnd, ParameterizedTypeName.get(classNameJoin, TypeVariableName.get("O")))).addStatement("return super.having()", new Object[0]).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder("orderBy").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameOrderBy, ParameterizedTypeName.get(classNameJoin, TypeVariableName.get("O")))).addStatement("return super.orderBy()", new Object[0]).build());
        for (JdbcBeanInfo.FieldInfo field : beanInfo.getFields()) {
            fieldName2 = field.getFieldName();
            nestedBuilder.addMethod(MethodSpec.methodBuilder(fieldName2).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameJoin, TypeVariableName.get("O"))).addStatement("return select($S)", fieldName2).build());
            nestedBuilder.addMethod(MethodSpec.methodBuilder(fieldName2).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameJoin, TypeVariableName.get("O"))).addParameter(ParameterSpec.builder(ClassName.get(String.class), "alias", new Modifier[0]).build()).addStatement("return select($S, alias)", fieldName2).build());
        }
        for (JdbcBeanInfo.ExpressionInfo expression : beanInfo.getExpressions()) {
            fieldName2 = expression.getFieldName();
            nestedBuilder.addMethod(MethodSpec.methodBuilder(fieldName2).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameJoin, TypeVariableName.get("O"))).addStatement("return select($S)", fieldName2).build());
            nestedBuilder.addMethod(MethodSpec.methodBuilder(fieldName2).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameJoin, TypeVariableName.get("O"))).addParameter(ParameterSpec.builder(ClassName.get(String.class), "alias", new Modifier[0]).build()).addStatement("return select($S, alias)", fieldName2).build());
        }
        classBuilder.addType(nestedBuilder.build());
        nestedBuilder = TypeSpec.classBuilder(classNameGroupBy).addModifiers(Modifier.PUBLIC, Modifier.STATIC).addTypeVariable(TypeVariableName.get("O", ParameterizedTypeName.get(classNameSegment, TypeVariableName.get("O")))).superclass(ParameterizedTypeName.get(classNameBaseGroupBy, TypeVariableName.get("O"), ParameterizedTypeName.get(classNameGroupBy, TypeVariableName.get("O"))));
        nestedBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(ParameterSpec.builder(TypeVariableName.get("O"), "owner", new Modifier[0]).build()).addParameter(ParameterSpec.builder(ParameterizedTypeName.get(classNameBaseTable, WildcardTypeName.subtypeOf(TypeName.OBJECT)), "table", new Modifier[0]).build()).addStatement("super(owner, table)", new Object[0]).build());
        for (JdbcBeanInfo.FieldInfo field : beanInfo.getFields()) {
            fieldName2 = field.getFieldName();
            nestedBuilder.addMethod(MethodSpec.methodBuilder(fieldName2).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameGroupBy, TypeVariableName.get("O"))).addStatement("return column($S)", fieldName2).build());
        }
        for (JdbcBeanInfo.ExpressionInfo expression : beanInfo.getExpressions()) {
            fieldName2 = expression.getFieldName();
            nestedBuilder.addMethod(MethodSpec.methodBuilder(fieldName2).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameGroupBy, TypeVariableName.get("O"))).addStatement("return column($S)", fieldName2).build());
        }
        classBuilder.addType(nestedBuilder.build());
        nestedBuilder = TypeSpec.classBuilder(classNameOrderBy).addModifiers(Modifier.PUBLIC, Modifier.STATIC).addTypeVariable(TypeVariableName.get("O", ParameterizedTypeName.get(classNameSegment, TypeVariableName.get("O")))).superclass(ParameterizedTypeName.get(classNameBaseOrderBy, TypeVariableName.get("O"), ParameterizedTypeName.get(classNameOrderBy, TypeVariableName.get("O"))));
        nestedBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(ParameterSpec.builder(TypeVariableName.get("O"), "owner", new Modifier[0]).build()).addParameter(ParameterSpec.builder(ParameterizedTypeName.get(classNameBaseTable, WildcardTypeName.subtypeOf(TypeName.OBJECT)), "table", new Modifier[0]).build()).addStatement("super(owner, table)", new Object[0]).build());
        for (JdbcBeanInfo.FieldInfo field : beanInfo.getFields()) {
            fieldName2 = field.getFieldName();
            nestedBuilder.addMethod(MethodSpec.methodBuilder(fieldName2).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameOrderBy, TypeVariableName.get("O"))).addStatement("return column($S)", fieldName2).build());
        }
        for (JdbcBeanInfo.ExpressionInfo expression : beanInfo.getExpressions()) {
            fieldName2 = expression.getFieldName();
            nestedBuilder.addMethod(MethodSpec.methodBuilder(fieldName2).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameOrderBy, TypeVariableName.get("O"))).addStatement("return column($S)", fieldName2).build());
        }
        classBuilder.addType(nestedBuilder.build());
        ParameterizedTypeName andWithO = ParameterizedTypeName.get(classNameAnd, TypeVariableName.get("O"));
        TypeSpec.Builder nestedBuilder2 = TypeSpec.classBuilder(classNameAnd).addModifiers(Modifier.PUBLIC, Modifier.STATIC).addTypeVariable(TypeVariableName.get("O", ParameterizedTypeName.get(classNameSegment, TypeVariableName.get("O")))).superclass(ParameterizedTypeName.get(classNameBaseAnd, TypeVariableName.get("O"), andWithO));
        nestedBuilder2.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addTypeVariable(TypeVariableName.get("T", ParameterizedTypeName.get(classNameBaseTable, WildcardTypeName.subtypeOf(TypeName.OBJECT)))).addParameter(ParameterSpec.builder(TypeVariableName.get("O"), "owner", new Modifier[0]).build()).addParameter(ParameterSpec.builder(TypeVariableName.get("T"), "table", new Modifier[0]).build()).addStatement("super(owner, table)", new Object[0]).build());
        nestedBuilder2.addMethod(MethodSpec.methodBuilder("and").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameAnd, andWithO)).addStatement("$T x = new $T<>(getThis(), getTable())", ParameterizedTypeName.get(classNameAnd, andWithO), classNameAnd).addStatement("addCriterion(new $T<>(getThis(), x))", classNameBaseCriterion).addStatement("return x", new Object[0]).build());
        nestedBuilder2.addMethod(MethodSpec.methodBuilder("or").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameOr, andWithO)).addStatement("$T x = new $T<>(getThis(), getTable())", ParameterizedTypeName.get(classNameOr, andWithO), classNameOr).addStatement("addCriterion(new $T<>(getThis(), x))", classNameBaseCriterion).addStatement("return x", new Object[0]).build());
        for (JdbcBeanInfo.FieldInfo field : beanInfo.getFields()) {
            fieldName = field.getFieldName();
            nestedBuilder2.addMethod(MethodSpec.methodBuilder(fieldName).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameBaseCriterion, andWithO, WildcardTypeName.subtypeOf(TypeName.OBJECT))).addStatement("return column($S)", fieldName).build());
        }
        for (JdbcBeanInfo.ExpressionInfo expression : beanInfo.getExpressions()) {
            fieldName = expression.getFieldName();
            nestedBuilder2.addMethod(MethodSpec.methodBuilder(fieldName).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameBaseCriterion, andWithO, WildcardTypeName.subtypeOf(TypeName.OBJECT))).addStatement("return column($S)", fieldName).build());
        }
        classBuilder.addType(nestedBuilder2.build());
        ParameterizedTypeName orWithO = ParameterizedTypeName.get(classNameOr, TypeVariableName.get("O"));
        nestedBuilder2 = TypeSpec.classBuilder(classNameOr).addModifiers(Modifier.PUBLIC, Modifier.STATIC).addTypeVariable(TypeVariableName.get("O", ParameterizedTypeName.get(classNameSegment, TypeVariableName.get("O")))).superclass(ParameterizedTypeName.get(classNameBaseOr, TypeVariableName.get("O"), orWithO));
        nestedBuilder2.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addTypeVariable(TypeVariableName.get("T", ParameterizedTypeName.get(classNameBaseTable, WildcardTypeName.subtypeOf(TypeName.OBJECT)))).addParameter(ParameterSpec.builder(TypeVariableName.get("O"), "owner", new Modifier[0]).build()).addParameter(ParameterSpec.builder(TypeVariableName.get("T"), "table", new Modifier[0]).build()).addStatement("super(owner, table)", new Object[0]).build());
        nestedBuilder2.addMethod(MethodSpec.methodBuilder("and").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameAnd, orWithO)).addStatement("$T x = new $T<>(getThis(), getTable())", ParameterizedTypeName.get(classNameAnd, orWithO), classNameAnd).addStatement("addCriterion(new $T<>(getThis(), x))", classNameBaseCriterion).addStatement("return x", new Object[0]).build());
        nestedBuilder2.addMethod(MethodSpec.methodBuilder("or").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameOr, orWithO)).addStatement("$T x = new $T<>(getThis(), getTable())", ParameterizedTypeName.get(classNameOr, orWithO), classNameOr).addStatement("addCriterion(new $T<>(getThis(), x))", classNameBaseCriterion).addStatement("return x", new Object[0]).build());
        for (JdbcBeanInfo.FieldInfo field : beanInfo.getFields()) {
            fieldName = field.getFieldName();
            nestedBuilder2.addMethod(MethodSpec.methodBuilder(fieldName).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameBaseCriterion, orWithO, WildcardTypeName.subtypeOf(TypeName.OBJECT))).addStatement("return column($S)", fieldName).build());
        }
        for (JdbcBeanInfo.ExpressionInfo expression : beanInfo.getExpressions()) {
            fieldName = expression.getFieldName();
            nestedBuilder2.addMethod(MethodSpec.methodBuilder(fieldName).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(classNameBaseCriterion, orWithO, WildcardTypeName.subtypeOf(TypeName.OBJECT))).addStatement("return column($S)", fieldName).build());
        }
        classBuilder.addType(nestedBuilder2.build());
        classBuilder.addMethod(MethodSpec.methodBuilder("join").addModifiers(Modifier.PUBLIC, Modifier.STATIC).addTypeVariable(TypeVariableName.get("O", ParameterizedTypeName.get(classNameBaseSelect, TypeVariableName.get("O")))).returns(ParameterizedTypeName.get(classNameJoinBuilder, TypeVariableName.get("O"), ParameterizedTypeName.get(classNameJoin, TypeVariableName.get("O")))).addStatement("return $T.builder()", classNameJoin).build());
        classBuilder.addMethod(MethodSpec.methodBuilder("select").addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(classNameSelect).addStatement("return new $T()", classNameSelect).build());
        classBuilder.addMethod(MethodSpec.methodBuilder("select").addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(classNameSelect).addParameter(ClassName.get(String.class), "alias", new Modifier[0]).addStatement("return new $T(alias)", classNameSelect).build());
        classBuilder.addMethod(MethodSpec.methodBuilder("insert").addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(classNameInsert).addStatement("return new $T()", classNameInsert).build());
        classBuilder.addMethod(MethodSpec.methodBuilder("insert").addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(classNameInsert).addParameter(ClassName.get(String.class), "alias", new Modifier[0]).addStatement("return new $T(alias)", classNameInsert).build());
        classBuilder.addMethod(MethodSpec.methodBuilder("update").addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(classNameUpdate).addStatement("return new $T()", classNameUpdate).build());
        classBuilder.addMethod(MethodSpec.methodBuilder("update").addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(classNameUpdate).addParameter(ClassName.get(String.class), "alias", new Modifier[0]).addStatement("return new $T(alias)", classNameUpdate).build());
        classBuilder.addMethod(MethodSpec.methodBuilder("delete").addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(classNameDelete).addStatement("return new $T()", classNameDelete).build());
        classBuilder.addMethod(MethodSpec.methodBuilder("delete").addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(classNameDelete).addParameter(ClassName.get(String.class), "alias", new Modifier[0]).addStatement("return new $T(alias)", classNameDelete).build());
        JavaFile javaFile = JavaFile.builder(sqlClassName.packageName(), classBuilder.build()).build();
        try {
            javaFile.writeTo(this.filer);
        }
        catch (IOException t) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, t.toString());
            t.printStackTrace();
        }
    }
}

