/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.javapoet;

import io.polaris.core.javapoet.AnnotationSpec;
import io.polaris.core.javapoet.ArrayTypeName;
import io.polaris.core.javapoet.ClassName;
import io.polaris.core.javapoet.CodeWriter;
import io.polaris.core.javapoet.ParameterizedTypeName;
import io.polaris.core.javapoet.TypeVariableName;
import io.polaris.core.javapoet.Util;
import io.polaris.core.javapoet.WildcardTypeName;
import java.io.IOException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor8;

public class TypeName {
    public static final TypeName VOID = new TypeName("void");
    public static final TypeName BOOLEAN = new TypeName("boolean");
    public static final TypeName BYTE = new TypeName("byte");
    public static final TypeName SHORT = new TypeName("short");
    public static final TypeName INT = new TypeName("int");
    public static final TypeName LONG = new TypeName("long");
    public static final TypeName CHAR = new TypeName("char");
    public static final TypeName FLOAT = new TypeName("float");
    public static final TypeName DOUBLE = new TypeName("double");
    public static final ClassName OBJECT = ClassName.get("java.lang", "Object", new String[0]);
    private static final ClassName BOXED_VOID = ClassName.get("java.lang", "Void", new String[0]);
    private static final ClassName BOXED_BOOLEAN = ClassName.get("java.lang", "Boolean", new String[0]);
    private static final ClassName BOXED_BYTE = ClassName.get("java.lang", "Byte", new String[0]);
    private static final ClassName BOXED_SHORT = ClassName.get("java.lang", "Short", new String[0]);
    private static final ClassName BOXED_INT = ClassName.get("java.lang", "Integer", new String[0]);
    private static final ClassName BOXED_LONG = ClassName.get("java.lang", "Long", new String[0]);
    private static final ClassName BOXED_CHAR = ClassName.get("java.lang", "Character", new String[0]);
    private static final ClassName BOXED_FLOAT = ClassName.get("java.lang", "Float", new String[0]);
    private static final ClassName BOXED_DOUBLE = ClassName.get("java.lang", "Double", new String[0]);
    private final String keyword;
    public final List<AnnotationSpec> annotations;
    private String cachedString;

    private TypeName(String keyword) {
        this(keyword, new ArrayList<AnnotationSpec>());
    }

    private TypeName(String keyword, List<AnnotationSpec> annotations) {
        this.keyword = keyword;
        this.annotations = Util.immutableList(annotations);
    }

    TypeName(List<AnnotationSpec> annotations) {
        this(null, annotations);
    }

    public final TypeName annotated(AnnotationSpec ... annotations) {
        return this.annotated(Arrays.asList(annotations));
    }

    public TypeName annotated(List<AnnotationSpec> annotations) {
        Util.checkNotNull(annotations, "annotations == null", new Object[0]);
        return new TypeName(this.keyword, this.concatAnnotations(annotations));
    }

    public TypeName withoutAnnotations() {
        if (this.annotations.isEmpty()) {
            return this;
        }
        return new TypeName(this.keyword);
    }

    protected final List<AnnotationSpec> concatAnnotations(List<AnnotationSpec> annotations) {
        ArrayList<AnnotationSpec> allAnnotations = new ArrayList<AnnotationSpec>(this.annotations);
        allAnnotations.addAll(annotations);
        return allAnnotations;
    }

    public boolean isAnnotated() {
        return !this.annotations.isEmpty();
    }

    public boolean isPrimitive() {
        return this.keyword != null && this != VOID;
    }

    public boolean isBoxedPrimitive() {
        TypeName thisWithoutAnnotations = this.withoutAnnotations();
        return thisWithoutAnnotations.equals(BOXED_BOOLEAN) || thisWithoutAnnotations.equals(BOXED_BYTE) || thisWithoutAnnotations.equals(BOXED_SHORT) || thisWithoutAnnotations.equals(BOXED_INT) || thisWithoutAnnotations.equals(BOXED_LONG) || thisWithoutAnnotations.equals(BOXED_CHAR) || thisWithoutAnnotations.equals(BOXED_FLOAT) || thisWithoutAnnotations.equals(BOXED_DOUBLE);
    }

    public TypeName box() {
        if (this.keyword == null) {
            return this;
        }
        ClassName boxed = null;
        if (this.keyword.equals(TypeName.VOID.keyword)) {
            boxed = BOXED_VOID;
        } else if (this.keyword.equals(TypeName.BOOLEAN.keyword)) {
            boxed = BOXED_BOOLEAN;
        } else if (this.keyword.equals(TypeName.BYTE.keyword)) {
            boxed = BOXED_BYTE;
        } else if (this.keyword.equals(TypeName.SHORT.keyword)) {
            boxed = BOXED_SHORT;
        } else if (this.keyword.equals(TypeName.INT.keyword)) {
            boxed = BOXED_INT;
        } else if (this.keyword.equals(TypeName.LONG.keyword)) {
            boxed = BOXED_LONG;
        } else if (this.keyword.equals(TypeName.CHAR.keyword)) {
            boxed = BOXED_CHAR;
        } else if (this.keyword.equals(TypeName.FLOAT.keyword)) {
            boxed = BOXED_FLOAT;
        } else if (this.keyword.equals(TypeName.DOUBLE.keyword)) {
            boxed = BOXED_DOUBLE;
        } else {
            throw new AssertionError((Object)this.keyword);
        }
        return this.annotations.isEmpty() ? boxed : ((TypeName)boxed).annotated(this.annotations);
    }

    public TypeName unbox() {
        if (this.keyword != null) {
            return this;
        }
        TypeName thisWithoutAnnotations = this.withoutAnnotations();
        TypeName unboxed = null;
        if (thisWithoutAnnotations.equals(BOXED_VOID)) {
            unboxed = VOID;
        } else if (thisWithoutAnnotations.equals(BOXED_BOOLEAN)) {
            unboxed = BOOLEAN;
        } else if (thisWithoutAnnotations.equals(BOXED_BYTE)) {
            unboxed = BYTE;
        } else if (thisWithoutAnnotations.equals(BOXED_SHORT)) {
            unboxed = SHORT;
        } else if (thisWithoutAnnotations.equals(BOXED_INT)) {
            unboxed = INT;
        } else if (thisWithoutAnnotations.equals(BOXED_LONG)) {
            unboxed = LONG;
        } else if (thisWithoutAnnotations.equals(BOXED_CHAR)) {
            unboxed = CHAR;
        } else if (thisWithoutAnnotations.equals(BOXED_FLOAT)) {
            unboxed = FLOAT;
        } else if (thisWithoutAnnotations.equals(BOXED_DOUBLE)) {
            unboxed = DOUBLE;
        } else {
            throw new UnsupportedOperationException("cannot unbox " + this);
        }
        return this.annotations.isEmpty() ? unboxed : unboxed.annotated(this.annotations);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public final String toString() {
        String result = this.cachedString;
        if (result == null) {
            try {
                StringBuilder resultBuilder = new StringBuilder();
                CodeWriter codeWriter = new CodeWriter(resultBuilder);
                this.emit(codeWriter);
                this.cachedString = result = resultBuilder.toString();
            }
            catch (IOException e) {
                throw new AssertionError();
            }
        }
        return result;
    }

    CodeWriter emit(CodeWriter out) throws IOException {
        if (this.keyword == null) {
            throw new AssertionError();
        }
        if (this.isAnnotated()) {
            out.emit("");
            this.emitAnnotations(out);
        }
        return out.emitAndIndent(this.keyword);
    }

    CodeWriter emitAnnotations(CodeWriter out) throws IOException {
        for (AnnotationSpec annotation : this.annotations) {
            annotation.emit(out, true);
            out.emit(" ");
        }
        return out;
    }

    public static TypeName get(TypeMirror mirror) {
        return TypeName.get(mirror, new LinkedHashMap<TypeParameterElement, TypeVariableName>());
    }

    static TypeName get(TypeMirror mirror, final Map<TypeParameterElement, TypeVariableName> typeVariables) {
        return mirror.accept(new SimpleTypeVisitor8<TypeName, Void>(){

            @Override
            public TypeName visitPrimitive(PrimitiveType t, Void p) {
                switch (t.getKind()) {
                    case BOOLEAN: {
                        return BOOLEAN;
                    }
                    case BYTE: {
                        return BYTE;
                    }
                    case SHORT: {
                        return SHORT;
                    }
                    case INT: {
                        return INT;
                    }
                    case LONG: {
                        return LONG;
                    }
                    case CHAR: {
                        return CHAR;
                    }
                    case FLOAT: {
                        return FLOAT;
                    }
                    case DOUBLE: {
                        return DOUBLE;
                    }
                }
                throw new AssertionError();
            }

            @Override
            public TypeName visitDeclared(DeclaredType t, Void p) {
                TypeName enclosing;
                ClassName rawType = ClassName.get((TypeElement)t.asElement());
                TypeMirror enclosingType = t.getEnclosingType();
                TypeName typeName = enclosing = enclosingType.getKind() != TypeKind.NONE && !t.asElement().getModifiers().contains((Object)Modifier.STATIC) ? enclosingType.accept(this, null) : null;
                if (t.getTypeArguments().isEmpty() && !(enclosing instanceof ParameterizedTypeName)) {
                    return rawType;
                }
                ArrayList<TypeName> typeArgumentNames = new ArrayList<TypeName>();
                for (TypeMirror typeMirror : t.getTypeArguments()) {
                    typeArgumentNames.add(TypeName.get(typeMirror, typeVariables));
                }
                return enclosing instanceof ParameterizedTypeName ? ((ParameterizedTypeName)enclosing).nestedClass(rawType.simpleName(), typeArgumentNames) : new ParameterizedTypeName(null, rawType, typeArgumentNames);
            }

            @Override
            public TypeName visitError(ErrorType t, Void p) {
                return this.visitDeclared((DeclaredType)t, p);
            }

            @Override
            public ArrayTypeName visitArray(ArrayType t, Void p) {
                return ArrayTypeName.get(t, (Map<TypeParameterElement, TypeVariableName>)typeVariables);
            }

            @Override
            public TypeName visitTypeVariable(javax.lang.model.type.TypeVariable t, Void p) {
                return TypeVariableName.get(t, (Map<TypeParameterElement, TypeVariableName>)typeVariables);
            }

            @Override
            public TypeName visitWildcard(WildcardType t, Void p) {
                return WildcardTypeName.get(t, (Map<TypeParameterElement, TypeVariableName>)typeVariables);
            }

            @Override
            public TypeName visitNoType(NoType t, Void p) {
                if (t.getKind() == TypeKind.VOID) {
                    return VOID;
                }
                return (TypeName)super.visitUnknown(t, p);
            }

            @Override
            protected TypeName defaultAction(TypeMirror e, Void p) {
                throw new IllegalArgumentException("Unexpected type mirror: " + e);
            }
        }, null);
    }

    public static TypeName get(Type type) {
        return TypeName.get(type, new LinkedHashMap<Type, TypeVariableName>());
    }

    static TypeName get(Type type, Map<Type, TypeVariableName> map) {
        if (type instanceof Class) {
            Class classType = (Class)type;
            if (type == Void.TYPE) {
                return VOID;
            }
            if (type == Boolean.TYPE) {
                return BOOLEAN;
            }
            if (type == Byte.TYPE) {
                return BYTE;
            }
            if (type == Short.TYPE) {
                return SHORT;
            }
            if (type == Integer.TYPE) {
                return INT;
            }
            if (type == Long.TYPE) {
                return LONG;
            }
            if (type == Character.TYPE) {
                return CHAR;
            }
            if (type == Float.TYPE) {
                return FLOAT;
            }
            if (type == Double.TYPE) {
                return DOUBLE;
            }
            if (classType.isArray()) {
                return ArrayTypeName.of(TypeName.get(classType.getComponentType(), map));
            }
            return ClassName.get(classType);
        }
        if (type instanceof ParameterizedType) {
            return ParameterizedTypeName.get((ParameterizedType)type, map);
        }
        if (type instanceof java.lang.reflect.WildcardType) {
            return WildcardTypeName.get((java.lang.reflect.WildcardType)type, map);
        }
        if (type instanceof TypeVariable) {
            return TypeVariableName.get((TypeVariable)type, map);
        }
        if (type instanceof GenericArrayType) {
            return ArrayTypeName.get((GenericArrayType)type, map);
        }
        throw new IllegalArgumentException("unexpected type: " + type);
    }

    static List<TypeName> list(Type[] types) {
        return TypeName.list(types, new LinkedHashMap<Type, TypeVariableName>());
    }

    static List<TypeName> list(Type[] types, Map<Type, TypeVariableName> map) {
        ArrayList<TypeName> result = new ArrayList<TypeName>(types.length);
        for (Type type : types) {
            result.add(TypeName.get(type, map));
        }
        return result;
    }

    static TypeName arrayComponent(TypeName type) {
        return type instanceof ArrayTypeName ? ((ArrayTypeName)type).componentType : null;
    }

    static ArrayTypeName asArray(TypeName type) {
        return type instanceof ArrayTypeName ? (ArrayTypeName)type : null;
    }
}

