/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.annotation.processing;

import io.polaris.core.annotation.Internal;
import io.polaris.core.javapoet.ArrayTypeName;
import io.polaris.core.javapoet.ClassName;
import io.polaris.core.javapoet.ParameterizedTypeName;
import io.polaris.core.javapoet.TypeName;
import io.polaris.core.javapoet.TypeVariableName;
import io.polaris.core.javapoet.WildcardTypeName;
import java.beans.Introspector;
import java.util.List;

@Internal
public class AnnotationProcessorUtils {
    public static String decapitalize(String name) {
        return Introspector.decapitalize(name);
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String toGetterName(String name, TypeName typeName) {
        if (TypeName.BOOLEAN.equals(typeName)) {
            return "is" + AnnotationProcessorUtils.capitalize(name);
        }
        return "get" + AnnotationProcessorUtils.capitalize(name);
    }

    public static String toSetterName(String name) {
        return "set" + AnnotationProcessorUtils.capitalize(name);
    }

    public static String camelToKebabCase(CharSequence name) {
        return AnnotationProcessorUtils.toDelimiterCase(name, '-', false);
    }

    public static String camelToKebabUpperCase(CharSequence name) {
        return AnnotationProcessorUtils.toDelimiterCase(name, '-', true);
    }

    public static String camelToUnderlineCase(CharSequence name) {
        return AnnotationProcessorUtils.toDelimiterCase(name, '_', false);
    }

    public static String camelToUnderlineUpperCase(CharSequence name) {
        return AnnotationProcessorUtils.toDelimiterCase(name, '_', true);
    }

    public static String kebabToPascalCase(CharSequence name) {
        return AnnotationProcessorUtils.toCamelCase(name, '-', false);
    }

    public static String underlineToPascalCase(CharSequence name) {
        return AnnotationProcessorUtils.toCamelCase(name, '_', false);
    }

    public static String kebabToCamelCase(CharSequence name) {
        return AnnotationProcessorUtils.toCamelCase(name, '-', false);
    }

    public static String underlineToCamelCase(CharSequence name) {
        return AnnotationProcessorUtils.toCamelCase(name, '_', false);
    }

    public static String toPascalCase(CharSequence name, char delimiter) {
        return AnnotationProcessorUtils.toCamelCase(name, delimiter, true);
    }

    public static String toCamelCase(CharSequence name, char delimiter) {
        return AnnotationProcessorUtils.toCamelCase(name, delimiter, false);
    }

    public static String toDelimiterCase(CharSequence name, char delimiter) {
        return AnnotationProcessorUtils.toDelimiterCase(name, delimiter, false);
    }

    public static String toDelimiterCase(CharSequence name, char delimiter, boolean upper) {
        if (name == null) {
            return null;
        }
        int len = name.length();
        StringBuilder sb = new StringBuilder(len);
        boolean isBound = true;
        if (upper) {
            for (int i = 0; i < len; ++i) {
                char c = name.charAt(i);
                if (c == delimiter) {
                    if (isBound) continue;
                    sb.append(delimiter);
                    isBound = true;
                    continue;
                }
                if (Character.isUpperCase(c)) {
                    if (!isBound) {
                        sb.append(delimiter);
                    }
                    sb.append(c);
                    isBound = false;
                    continue;
                }
                sb.append(Character.toUpperCase(c));
                isBound = false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                char c = name.charAt(i);
                if (c == delimiter) {
                    if (isBound) continue;
                    sb.append(delimiter);
                    isBound = true;
                    continue;
                }
                if (Character.isUpperCase(c)) {
                    if (!isBound) {
                        sb.append(delimiter);
                    }
                    sb.append(Character.toLowerCase(c));
                    isBound = false;
                    continue;
                }
                sb.append(c);
                isBound = false;
            }
        }
        return sb.toString();
    }

    public static String toCamelCase(CharSequence name, char delimiter, boolean upperFirst) {
        if (name == null) {
            return null;
        }
        int len = name.length();
        StringBuilder sb = new StringBuilder(len);
        int start = 0;
        char first = name.charAt(start);
        if (upperFirst && first != delimiter) {
            sb.append(Character.toUpperCase(first));
            start = 1;
        }
        boolean upperCase = false;
        for (int i = start; i < len; ++i) {
            char c = name.charAt(i);
            if (c == delimiter) {
                upperCase = true;
                continue;
            }
            if (upperCase) {
                sb.append(Character.toUpperCase(c));
                upperCase = false;
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static TypeName rawType(TypeName typeName) {
        List<TypeName> bounds;
        List<TypeName> upperBounds;
        if (typeName.isPrimitive() || typeName.isBoxedPrimitive() || typeName == TypeName.OBJECT || typeName == TypeName.VOID) {
            return typeName;
        }
        if (typeName instanceof ClassName) {
            return typeName;
        }
        if (typeName instanceof ParameterizedTypeName) {
            return ((ParameterizedTypeName)typeName).rawType;
        }
        if (typeName instanceof ArrayTypeName) {
            TypeName componentType = ((ArrayTypeName)typeName).componentType;
            return ArrayTypeName.of(AnnotationProcessorUtils.rawType(componentType));
        }
        if (typeName instanceof WildcardTypeName && !(upperBounds = ((WildcardTypeName)typeName).upperBounds).isEmpty()) {
            return AnnotationProcessorUtils.rawType(upperBounds.get(0));
        }
        if (typeName instanceof TypeVariableName && !(bounds = ((TypeVariableName)typeName).bounds).isEmpty()) {
            return AnnotationProcessorUtils.rawType(bounds.get(0));
        }
        return ClassName.OBJECT;
    }
}

