/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.annotation.processing;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import io.polaris.core.annotation.processing.BaseProcessor;
import io.polaris.core.jdbc.ColumnMeta;
import io.polaris.core.jdbc.ExpressionMeta;
import io.polaris.core.jdbc.IEntityMeta;
import io.polaris.core.jdbc.annotation.Table;
import io.polaris.core.jdbc.annotation.processing.JdbcBeanInfo;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"io.polaris.core.jdbc.annotation.Table"})
public class JdbcAnnotationProcessor
extends BaseProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(Table.class);
        set.forEach(element -> {
            if (!(element instanceof TypeElement)) {
                return;
            }
            JdbcBeanInfo beanInfo = new JdbcBeanInfo((TypeElement)element);
            this.generateMetaClass(beanInfo);
            this.generateSqlClass(beanInfo);
        });
        return true;
    }

    private void generateMetaClass(JdbcBeanInfo beanInfo) {
        ClassName className = beanInfo.getMetaClassName();
        ClassName entityMetaClassName = ClassName.get(IEntityMeta.class);
        ClassName columnMetaClassName = ClassName.get(ColumnMeta.class);
        ClassName expressionMetaClassName = ClassName.get(ExpressionMeta.class);
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((ClassName)className).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)entityMetaClassName);
        ClassName fieldsClassName = className.nestedClass("FieldName");
        TypeSpec.Builder fieldsClassBuilder = TypeSpec.classBuilder((ClassName)fieldsClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        for (JdbcBeanInfo.FieldInfo fieldInfo : beanInfo.getFields()) {
            fieldsClassBuilder.addField(FieldSpec.builder((TypeName)ClassName.get(String.class), (String)fieldInfo.getFieldName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{fieldInfo.getFieldName()}).build());
        }
        for (JdbcBeanInfo.ExpressionInfo expressionInfo : beanInfo.getExpressions()) {
            fieldsClassBuilder.addField(FieldSpec.builder((TypeName)ClassName.get(String.class), (String)expressionInfo.getFieldName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{expressionInfo.getFieldName()}).build());
        }
        classBuilder.addType(fieldsClassBuilder.build());
        ClassName columnsClassName = className.nestedClass("ColumnName");
        TypeSpec.Builder columnsClassBuilder = TypeSpec.classBuilder((ClassName)columnsClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        for (JdbcBeanInfo.FieldInfo fieldInfo : beanInfo.getFields()) {
            columnsClassBuilder.addField(FieldSpec.builder((TypeName)ClassName.get(String.class), (String)fieldInfo.getFieldName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{fieldInfo.getColumnName()}).build());
        }
        for (JdbcBeanInfo.ExpressionInfo expressionInfo : beanInfo.getExpressions()) {
            columnsClassBuilder.addField(FieldSpec.builder((TypeName)ClassName.get(String.class), (String)expressionInfo.getFieldName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{expressionInfo.getExpression()}).build());
        }
        classBuilder.addType(columnsClassBuilder.build());
        ParameterizedTypeName columnMetaMapTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), columnMetaClassName});
        ParameterizedTypeName expressionMetaMapTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), expressionMetaClassName});
        classBuilder.addField(FieldSpec.builder((TypeName)ClassName.get(String.class), (String)"SCHEMA", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC, Modifier.STATIC}).initializer("$S", new Object[]{beanInfo.getTableSchema()}).build());
        classBuilder.addField(FieldSpec.builder((TypeName)ClassName.get(String.class), (String)"CATALOG", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC, Modifier.STATIC}).initializer("$S", new Object[]{beanInfo.getTableCatalog()}).build());
        classBuilder.addField(FieldSpec.builder((TypeName)ClassName.get(String.class), (String)"TABLE", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC, Modifier.STATIC}).initializer("$S", new Object[]{beanInfo.getTableName()}).build());
        classBuilder.addField(FieldSpec.builder((TypeName)ClassName.get(String.class), (String)"ALIAS", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC, Modifier.STATIC}).initializer("$S", new Object[]{beanInfo.getTableAlias()}).build());
        classBuilder.addField(FieldSpec.builder((TypeName)columnMetaMapTypeName, (String)"COLUMNS", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC, Modifier.STATIC}).build());
        classBuilder.addField(FieldSpec.builder((TypeName)expressionMetaMapTypeName, (String)"EXPRESSIONS", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC, Modifier.STATIC}).build());
        CodeBlock.Builder codeBlock = CodeBlock.builder().addStatement("$T map = new $T<>()", new Object[]{columnMetaMapTypeName, ClassName.get(LinkedHashMap.class)});
        for (JdbcBeanInfo.FieldInfo fieldInfo : beanInfo.getFields()) {
            codeBlock.addStatement("map.put($S,$T.builder().schema($S).catalog($S).tableName($S).fieldName($S).fieldType($T.class).columnName($S).jdbcType($S).jdbcTypeValue($L).updateDefault($S).insertDefault($S).nullable($L).insertable($L).updatable($L).version($L).logicDeleted($L).createTime($L).updateTime($L).primaryKey($L).autoIncrement($L).seqName($S).build())", new Object[]{fieldInfo.getFieldName(), columnMetaClassName, beanInfo.getTableSchema(), beanInfo.getTableCatalog(), beanInfo.getTableName(), fieldInfo.getFieldName(), fieldInfo.getFieldRawTypeName(), fieldInfo.getColumnName(), fieldInfo.getJdbcTypeName(), fieldInfo.getJdbcTypeValue(), fieldInfo.getUpdateDefault(), fieldInfo.getInsertDefault(), fieldInfo.isNullable(), fieldInfo.isInsertable(), fieldInfo.isUpdatable(), fieldInfo.isVersion(), fieldInfo.isLogicDeleted(), fieldInfo.isCreateTime(), fieldInfo.isUpdateTime(), fieldInfo.isId(), fieldInfo.isAutoIncrement(), fieldInfo.getSeqName()});
        }
        classBuilder.addStaticBlock(codeBlock.addStatement("COLUMNS = $T.unmodifiableMap(map)", new Object[]{ClassName.get(Collections.class)}).build());
        codeBlock = CodeBlock.builder().addStatement("$T map = new $T<>()", new Object[]{expressionMetaMapTypeName, ClassName.get(LinkedHashMap.class)});
        for (JdbcBeanInfo.ExpressionInfo expressionInfo : beanInfo.getExpressions()) {
            codeBlock.addStatement("map.put($S,$T.builder().schema($S).catalog($S).tableName($S).fieldName($S).fieldType($T.class).expression($S).jdbcType($S).jdbcTypeValue($L).tableAliasPlaceholder($S).selectable($L).build())", new Object[]{expressionInfo.getFieldName(), expressionMetaClassName, beanInfo.getTableSchema(), beanInfo.getTableCatalog(), beanInfo.getTableName(), expressionInfo.getFieldName(), expressionInfo.getFieldRawTypeName(), expressionInfo.getExpression(), expressionInfo.getJdbcTypeName(), expressionInfo.getJdbcTypeValue(), expressionInfo.getTableAliasPlaceholder(), expressionInfo.isSelectable()});
        }
        classBuilder.addStaticBlock(codeBlock.addStatement("EXPRESSIONS = $T.unmodifiableMap(map)", new Object[]{ClassName.get(Collections.class)}).build());
        JavaFile javaFile = JavaFile.builder((String)className.packageName(), (TypeSpec)classBuilder.build()).build();
        try {
            javaFile.writeTo(this.filer);
        }
        catch (IOException iOException) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, iOException.toString());
            iOException.printStackTrace();
        }
    }

    private void generateSqlClass(JdbcBeanInfo beanInfo) {
        String fieldName;
        String fieldName2;
        if (!beanInfo.isSqlGenerated()) {
            return;
        }
        TypeName beanTypeName = beanInfo.getBeanTypeName();
        ClassName beanClassName = beanInfo.getBeanClassName();
        ClassName sqlClassName = beanInfo.getSqlClassName();
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((ClassName)sqlClassName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        ClassName classNameTextNode = ClassName.get((String)"io.polaris.core.jdbc.sql.node", (String)"TextNode", (String[])new String[0]);
        ClassName classNameBaseSelect = ClassName.get((String)"io.polaris.core.jdbc.sql.statement", (String)"SelectStatement", (String[])new String[0]);
        ClassName classNameBaseInsert = ClassName.get((String)"io.polaris.core.jdbc.sql.statement", (String)"InsertStatement", (String[])new String[0]);
        ClassName classNameBaseUpdate = ClassName.get((String)"io.polaris.core.jdbc.sql.statement", (String)"UpdateStatement", (String[])new String[0]);
        ClassName classNameBaseDelete = ClassName.get((String)"io.polaris.core.jdbc.sql.statement", (String)"DeleteStatement", (String[])new String[0]);
        ClassName classNameSegment = ClassName.get((String)"io.polaris.core.jdbc.sql.statement", (String)"Segment", (String[])new String[0]);
        ClassName classNameBaseCol = ClassName.get((String)"io.polaris.core.jdbc.sql.statement.segment", (String)"SelectSegment", (String[])new String[0]);
        ClassName classNameBaseTable = ClassName.get((String)"io.polaris.core.jdbc.sql.statement.segment", (String)"TableSegment", (String[])new String[0]);
        ClassName classNameBaseJoin = ClassName.get((String)"io.polaris.core.jdbc.sql.statement.segment", (String)"JoinSegment", (String[])new String[0]);
        ClassName classNameBaseGroupBy = ClassName.get((String)"io.polaris.core.jdbc.sql.statement.segment", (String)"GroupBySegment", (String[])new String[0]);
        ClassName classNameBaseOrderBy = ClassName.get((String)"io.polaris.core.jdbc.sql.statement.segment", (String)"OrderBySegment", (String[])new String[0]);
        ClassName classNameBaseAnd = ClassName.get((String)"io.polaris.core.jdbc.sql.statement.segment", (String)"AndSegment", (String[])new String[0]);
        ClassName classNameBaseOr = ClassName.get((String)"io.polaris.core.jdbc.sql.statement.segment", (String)"OrSegment", (String[])new String[0]);
        ClassName classNameBaseCriterion = ClassName.get((String)"io.polaris.core.jdbc.sql.statement.segment", (String)"CriterionSegment", (String[])new String[0]);
        ClassName classNameJoinBuilder = ClassName.get((String)"io.polaris.core.jdbc.sql.statement.segment", (String)"JoinBuilder", (String[])new String[0]);
        ClassName classNameColumnSegment = ClassName.get((String)"io.polaris.core.jdbc.sql.statement.segment", (String)"ColumnSegment", (String[])new String[0]);
        ClassName classNameSelect = sqlClassName.nestedClass("Select");
        ClassName classNameInsert = sqlClassName.nestedClass("Insert");
        ClassName classNameUpdate = sqlClassName.nestedClass("Update");
        ClassName classNameDelete = sqlClassName.nestedClass("Delete");
        ClassName classNameSelectCol = sqlClassName.nestedClass("SelectCol");
        ClassName classNameJoin = sqlClassName.nestedClass("Join");
        ClassName classNameGroupBy = sqlClassName.nestedClass("GroupBy");
        ClassName classNameOrderBy = sqlClassName.nestedClass("OrderBy");
        ClassName classNameAnd = sqlClassName.nestedClass("And");
        ClassName classNameOr = sqlClassName.nestedClass("Or");
        TypeSpec.Builder nestedBuilder = TypeSpec.classBuilder((ClassName)classNameSelect).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).superclass((TypeName)ParameterizedTypeName.get((ClassName)classNameBaseSelect, (TypeName[])new TypeName[]{classNameSelect}));
        nestedBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super($T.class)", new Object[]{beanClassName}).build());
        nestedBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)ClassName.get(String.class), (String)"alias", (Modifier[])new Modifier[0]).build()).addStatement("super($T.class, alias)", new Object[]{beanClassName}).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder((String)"buildSelect").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameSelectCol, (TypeName[])new TypeName[]{classNameSelect})).addStatement("return new $T<>(getThis(), getTable())", new Object[]{classNameSelectCol}).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder((String)"buildWhere").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameAnd, (TypeName[])new TypeName[]{classNameSelect})).addStatement("return new $T<>(getThis(), getTable())", new Object[]{classNameAnd}).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder((String)"buildGroupBy").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameGroupBy, (TypeName[])new TypeName[]{classNameSelect})).addStatement("return new $T<>(getThis(), getTable())", new Object[]{classNameGroupBy}).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder((String)"buildOrderBy").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameOrderBy, (TypeName[])new TypeName[]{classNameSelect})).addStatement("return new $T<>(getThis(), getTable())", new Object[]{classNameOrderBy}).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder((String)"select").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameSelectCol, (TypeName[])new TypeName[]{classNameSelect})).addStatement("return super.select()", new Object[0]).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder((String)"where").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameAnd, (TypeName[])new TypeName[]{classNameSelect})).addStatement("return super.where()", new Object[0]).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder((String)"groupBy").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameGroupBy, (TypeName[])new TypeName[]{classNameSelect})).addStatement("return super.groupBy()", new Object[0]).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder((String)"having").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameAnd, (TypeName[])new TypeName[]{classNameSelect})).addStatement("return super.having()", new Object[0]).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder((String)"orderBy").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameOrderBy, (TypeName[])new TypeName[]{classNameSelect})).addStatement("return super.orderBy()", new Object[0]).build());
        for (JdbcBeanInfo.FieldInfo field : beanInfo.getFields()) {
            fieldName2 = field.getFieldName();
            nestedBuilder.addMethod(MethodSpec.methodBuilder((String)fieldName2).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)classNameSelect).addStatement("return select($S)", new Object[]{fieldName2}).build());
            nestedBuilder.addMethod(MethodSpec.methodBuilder((String)fieldName2).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)classNameSelect).addParameter(ParameterSpec.builder((TypeName)ClassName.get(String.class), (String)"alias", (Modifier[])new Modifier[0]).build()).addStatement("return select($S, alias)", new Object[]{fieldName2}).build());
        }
        for (JdbcBeanInfo.ExpressionInfo expression : beanInfo.getExpressions()) {
            fieldName2 = expression.getFieldName();
            nestedBuilder.addMethod(MethodSpec.methodBuilder((String)fieldName2).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)classNameSelect).addStatement("return select($S)", new Object[]{fieldName2}).build());
            nestedBuilder.addMethod(MethodSpec.methodBuilder((String)fieldName2).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)classNameSelect).addParameter(ParameterSpec.builder((TypeName)ClassName.get(String.class), (String)"alias", (Modifier[])new Modifier[0]).build()).addStatement("return select($S, alias)", new Object[]{fieldName2}).build());
        }
        classBuilder.addType(nestedBuilder.build());
        nestedBuilder = TypeSpec.classBuilder((ClassName)classNameInsert).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).superclass((TypeName)ParameterizedTypeName.get((ClassName)classNameBaseInsert, (TypeName[])new TypeName[]{classNameInsert}));
        nestedBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super($T.class)", new Object[]{beanClassName}).build());
        nestedBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)ClassName.get(String.class), (String)"alias", (Modifier[])new Modifier[0]).build()).addStatement("super($T.class, alias)", new Object[]{beanClassName}).build());
        for (JdbcBeanInfo.FieldInfo field : beanInfo.getFields()) {
            fieldName2 = field.getFieldName();
            nestedBuilder.addMethod(MethodSpec.methodBuilder((String)fieldName2).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameColumnSegment, (TypeName[])new TypeName[]{classNameInsert, WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT)})).addStatement("return column($S)", new Object[]{fieldName2}).build());
            nestedBuilder.addMethod(MethodSpec.methodBuilder((String)fieldName2).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)classNameInsert).addParameter(ParameterSpec.builder((TypeName)TypeName.OBJECT, (String)"value", (Modifier[])new Modifier[0]).build()).addStatement("return column($S, value)", new Object[]{fieldName2}).build());
            nestedBuilder.addMethod(MethodSpec.methodBuilder((String)fieldName2).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)classNameInsert).addParameter(ParameterSpec.builder((TypeName)TypeName.OBJECT, (String)"value", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(BiPredicate.class), (TypeName[])new TypeName[]{ClassName.get(String.class), TypeName.OBJECT}), (String)"predicate", (Modifier[])new Modifier[0]).build()).addStatement("return column($S, value, predicate)", new Object[]{fieldName2}).build());
            nestedBuilder.addMethod(MethodSpec.methodBuilder((String)fieldName2).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)classNameInsert).addParameter(ParameterSpec.builder((TypeName)TypeName.OBJECT, (String)"value", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Supplier.class), (TypeName[])new TypeName[]{ClassName.get(Boolean.class)}), (String)"predicate", (Modifier[])new Modifier[0]).build()).addStatement("return column($S, value, predicate)", new Object[]{fieldName2}).build());
        }
        classBuilder.addType(nestedBuilder.build());
        nestedBuilder = TypeSpec.classBuilder((ClassName)classNameUpdate).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).superclass((TypeName)ParameterizedTypeName.get((ClassName)classNameBaseUpdate, (TypeName[])new TypeName[]{classNameUpdate}));
        nestedBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super($T.class)", new Object[]{beanClassName}).build());
        nestedBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)ClassName.get(String.class), (String)"alias", (Modifier[])new Modifier[0]).build()).addStatement("super($T.class, alias)", new Object[]{beanClassName}).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder((String)"buildWhere").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameAnd, (TypeName[])new TypeName[]{classNameUpdate})).addStatement("return new $T<>(getThis(), getTable())", new Object[]{classNameAnd}).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder((String)"where").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameAnd, (TypeName[])new TypeName[]{classNameUpdate})).addStatement("return super.where()", new Object[0]).build());
        for (JdbcBeanInfo.FieldInfo field : beanInfo.getFields()) {
            fieldName2 = field.getFieldName();
            nestedBuilder.addMethod(MethodSpec.methodBuilder((String)fieldName2).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameColumnSegment, (TypeName[])new TypeName[]{classNameUpdate, WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT)})).addStatement("return column($S)", new Object[]{fieldName2}).build());
            nestedBuilder.addMethod(MethodSpec.methodBuilder((String)fieldName2).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)classNameUpdate).addParameter(ParameterSpec.builder((TypeName)TypeName.OBJECT, (String)"value", (Modifier[])new Modifier[0]).build()).addStatement("return column($S, value)", new Object[]{fieldName2}).build());
            nestedBuilder.addMethod(MethodSpec.methodBuilder((String)fieldName2).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)classNameUpdate).addParameter(ParameterSpec.builder((TypeName)TypeName.OBJECT, (String)"value", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(BiPredicate.class), (TypeName[])new TypeName[]{ClassName.get(String.class), TypeName.OBJECT}), (String)"predicate", (Modifier[])new Modifier[0]).build()).addStatement("return column($S, value, predicate)", new Object[]{fieldName2}).build());
            nestedBuilder.addMethod(MethodSpec.methodBuilder((String)fieldName2).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)classNameUpdate).addParameter(ParameterSpec.builder((TypeName)TypeName.OBJECT, (String)"value", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Supplier.class), (TypeName[])new TypeName[]{ClassName.get(Boolean.class)}), (String)"predicate", (Modifier[])new Modifier[0]).build()).addStatement("return column($S, value, predicate)", new Object[]{fieldName2}).build());
        }
        classBuilder.addType(nestedBuilder.build());
        nestedBuilder = TypeSpec.classBuilder((ClassName)classNameDelete).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).superclass((TypeName)ParameterizedTypeName.get((ClassName)classNameBaseDelete, (TypeName[])new TypeName[]{classNameDelete}));
        nestedBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super($T.class)", new Object[]{beanClassName}).build());
        nestedBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)ClassName.get(String.class), (String)"alias", (Modifier[])new Modifier[0]).build()).addStatement("super($T.class, alias)", new Object[]{beanClassName}).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder((String)"buildWhere").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameAnd, (TypeName[])new TypeName[]{classNameDelete})).addStatement("return new $T<>(getThis(), getTable())", new Object[]{classNameAnd}).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder((String)"where").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameAnd, (TypeName[])new TypeName[]{classNameDelete})).addStatement("return super.where()", new Object[0]).build());
        classBuilder.addType(nestedBuilder.build());
        nestedBuilder = TypeSpec.classBuilder((ClassName)classNameSelectCol).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addTypeVariable(TypeVariableName.get((String)"O", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)classNameSegment, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})})).superclass((TypeName)ParameterizedTypeName.get((ClassName)classNameBaseCol, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O"), ParameterizedTypeName.get((ClassName)classNameSelectCol, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})}));
        nestedBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)TypeVariableName.get((String)"O"), (String)"owner", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)classNameBaseTable, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)ParameterizedTypeName.get((ClassName)classNameBaseTable, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT)}))}), (String)"table", (Modifier[])new Modifier[0]).build()).addStatement("super(owner, table)", new Object[0]).build());
        for (JdbcBeanInfo.FieldInfo field : beanInfo.getFields()) {
            fieldName2 = field.getFieldName();
            nestedBuilder.addMethod(MethodSpec.methodBuilder((String)fieldName2).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameSelectCol, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})).addStatement("return column($S)", new Object[]{fieldName2}).build());
        }
        for (JdbcBeanInfo.ExpressionInfo expression : beanInfo.getExpressions()) {
            fieldName2 = expression.getFieldName();
            nestedBuilder.addMethod(MethodSpec.methodBuilder((String)fieldName2).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameSelectCol, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})).addStatement("return column($S)", new Object[]{fieldName2}).build());
        }
        classBuilder.addType(nestedBuilder.build());
        nestedBuilder = TypeSpec.classBuilder((ClassName)classNameJoin).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addTypeVariable(TypeVariableName.get((String)"O", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)classNameBaseSelect, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})})).superclass((TypeName)ParameterizedTypeName.get((ClassName)classNameBaseJoin, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O"), ParameterizedTypeName.get((ClassName)classNameJoin, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})}));
        nestedBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)TypeVariableName.get((String)"O"), (String)"owner", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)classNameTextNode, (String)"conj", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT)}), (String)"entityClass", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ClassName.get(String.class), (String)"alias", (Modifier[])new Modifier[0]).build()).addStatement("super(owner, conj, entityClass, alias)", new Object[0]).build());
        nestedBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)TypeVariableName.get((String)"O"), (String)"owner", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)classNameTextNode, (String)"conj", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)classNameBaseSelect, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT)}), (String)"select", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ClassName.get(String.class), (String)"alias", (Modifier[])new Modifier[0]).build()).addStatement("super(owner, conj, select, alias)", new Object[0]).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addTypeVariable(TypeVariableName.get((String)"O", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)classNameBaseSelect, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})})).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameJoinBuilder, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O"), ParameterizedTypeName.get((ClassName)classNameJoin, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})})).addStatement("return (statement, conj, alias) -> new $T<>(statement, conj, $T.class, alias)", new Object[]{classNameJoin, beanClassName}).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder((String)"buildSelect").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameSelectCol, (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)classNameJoin, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})})).addStatement("return new $T<>(getThis(), getTable())", new Object[]{classNameSelectCol}).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder((String)"buildWhere").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameAnd, (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)classNameJoin, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})})).addStatement("return new $T<>(getThis(), getTable())", new Object[]{classNameAnd}).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder((String)"buildGroupBy").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameGroupBy, (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)classNameJoin, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})})).addStatement("return new $T<>(getThis(), getTable())", new Object[]{classNameGroupBy}).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder((String)"buildOrderBy").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameOrderBy, (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)classNameJoin, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})})).addStatement("return new $T<>(getThis(), getTable())", new Object[]{classNameOrderBy}).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder((String)"on").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameAnd, (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)classNameJoin, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})})).addStatement("return super.on()", new Object[0]).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder((String)"where").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameAnd, (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)classNameJoin, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})})).addStatement("return super.where()", new Object[0]).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder((String)"select").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameSelectCol, (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)classNameJoin, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})})).addStatement("return super.select()", new Object[0]).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder((String)"groupBy").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameGroupBy, (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)classNameJoin, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})})).addStatement("return super.groupBy()", new Object[0]).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder((String)"having").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameAnd, (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)classNameJoin, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})})).addStatement("return super.having()", new Object[0]).build());
        nestedBuilder.addMethod(MethodSpec.methodBuilder((String)"orderBy").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameOrderBy, (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)classNameJoin, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})})).addStatement("return super.orderBy()", new Object[0]).build());
        for (JdbcBeanInfo.FieldInfo field : beanInfo.getFields()) {
            fieldName2 = field.getFieldName();
            nestedBuilder.addMethod(MethodSpec.methodBuilder((String)fieldName2).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameJoin, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})).addStatement("return select($S)", new Object[]{fieldName2}).build());
            nestedBuilder.addMethod(MethodSpec.methodBuilder((String)fieldName2).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameJoin, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})).addParameter(ParameterSpec.builder((TypeName)ClassName.get(String.class), (String)"alias", (Modifier[])new Modifier[0]).build()).addStatement("return select($S, alias)", new Object[]{fieldName2}).build());
        }
        for (JdbcBeanInfo.ExpressionInfo expression : beanInfo.getExpressions()) {
            fieldName2 = expression.getFieldName();
            nestedBuilder.addMethod(MethodSpec.methodBuilder((String)fieldName2).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameJoin, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})).addStatement("return select($S)", new Object[]{fieldName2}).build());
            nestedBuilder.addMethod(MethodSpec.methodBuilder((String)fieldName2).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameJoin, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})).addParameter(ParameterSpec.builder((TypeName)ClassName.get(String.class), (String)"alias", (Modifier[])new Modifier[0]).build()).addStatement("return select($S, alias)", new Object[]{fieldName2}).build());
        }
        classBuilder.addType(nestedBuilder.build());
        nestedBuilder = TypeSpec.classBuilder((ClassName)classNameGroupBy).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addTypeVariable(TypeVariableName.get((String)"O", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)classNameSegment, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})})).superclass((TypeName)ParameterizedTypeName.get((ClassName)classNameBaseGroupBy, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O"), ParameterizedTypeName.get((ClassName)classNameGroupBy, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})}));
        nestedBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)TypeVariableName.get((String)"O"), (String)"owner", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)classNameBaseTable, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT)}), (String)"table", (Modifier[])new Modifier[0]).build()).addStatement("super(owner, table)", new Object[0]).build());
        for (JdbcBeanInfo.FieldInfo field : beanInfo.getFields()) {
            fieldName2 = field.getFieldName();
            nestedBuilder.addMethod(MethodSpec.methodBuilder((String)fieldName2).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameGroupBy, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})).addStatement("return column($S)", new Object[]{fieldName2}).build());
        }
        for (JdbcBeanInfo.ExpressionInfo expression : beanInfo.getExpressions()) {
            fieldName2 = expression.getFieldName();
            nestedBuilder.addMethod(MethodSpec.methodBuilder((String)fieldName2).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameGroupBy, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})).addStatement("return column($S)", new Object[]{fieldName2}).build());
        }
        classBuilder.addType(nestedBuilder.build());
        nestedBuilder = TypeSpec.classBuilder((ClassName)classNameOrderBy).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addTypeVariable(TypeVariableName.get((String)"O", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)classNameSegment, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})})).superclass((TypeName)ParameterizedTypeName.get((ClassName)classNameBaseOrderBy, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O"), ParameterizedTypeName.get((ClassName)classNameOrderBy, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})}));
        nestedBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)TypeVariableName.get((String)"O"), (String)"owner", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)classNameBaseTable, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT)}), (String)"table", (Modifier[])new Modifier[0]).build()).addStatement("super(owner, table)", new Object[0]).build());
        for (JdbcBeanInfo.FieldInfo field : beanInfo.getFields()) {
            fieldName2 = field.getFieldName();
            nestedBuilder.addMethod(MethodSpec.methodBuilder((String)fieldName2).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameOrderBy, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})).addStatement("return column($S)", new Object[]{fieldName2}).build());
        }
        for (JdbcBeanInfo.ExpressionInfo expression : beanInfo.getExpressions()) {
            fieldName2 = expression.getFieldName();
            nestedBuilder.addMethod(MethodSpec.methodBuilder((String)fieldName2).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameOrderBy, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})).addStatement("return column($S)", new Object[]{fieldName2}).build());
        }
        classBuilder.addType(nestedBuilder.build());
        ParameterizedTypeName andWithO = ParameterizedTypeName.get((ClassName)classNameAnd, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")});
        TypeSpec.Builder nestedBuilder2 = TypeSpec.classBuilder((ClassName)classNameAnd).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addTypeVariable(TypeVariableName.get((String)"O", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)classNameSegment, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})})).superclass((TypeName)ParameterizedTypeName.get((ClassName)classNameBaseAnd, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O"), andWithO}));
        nestedBuilder2.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(TypeVariableName.get((String)"T", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)classNameBaseTable, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT)})})).addParameter(ParameterSpec.builder((TypeName)TypeVariableName.get((String)"O"), (String)"owner", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)TypeVariableName.get((String)"T"), (String)"table", (Modifier[])new Modifier[0]).build()).addStatement("super(owner, table)", new Object[0]).build());
        nestedBuilder2.addMethod(MethodSpec.methodBuilder((String)"and").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameAnd, (TypeName[])new TypeName[]{andWithO})).addStatement("$T x = new $T<>(getThis(), getTable())", new Object[]{ParameterizedTypeName.get((ClassName)classNameAnd, (TypeName[])new TypeName[]{andWithO}), classNameAnd}).addStatement("addCriterion(new $T<>(getThis(), x))", new Object[]{classNameBaseCriterion}).addStatement("return x", new Object[0]).build());
        nestedBuilder2.addMethod(MethodSpec.methodBuilder((String)"or").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameOr, (TypeName[])new TypeName[]{andWithO})).addStatement("$T x = new $T<>(getThis(), getTable())", new Object[]{ParameterizedTypeName.get((ClassName)classNameOr, (TypeName[])new TypeName[]{andWithO}), classNameOr}).addStatement("addCriterion(new $T<>(getThis(), x))", new Object[]{classNameBaseCriterion}).addStatement("return x", new Object[0]).build());
        for (JdbcBeanInfo.FieldInfo field : beanInfo.getFields()) {
            fieldName = field.getFieldName();
            nestedBuilder2.addMethod(MethodSpec.methodBuilder((String)fieldName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameBaseCriterion, (TypeName[])new TypeName[]{andWithO, WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT)})).addStatement("return column($S)", new Object[]{fieldName}).build());
        }
        for (JdbcBeanInfo.ExpressionInfo expression : beanInfo.getExpressions()) {
            fieldName = expression.getFieldName();
            nestedBuilder2.addMethod(MethodSpec.methodBuilder((String)fieldName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameBaseCriterion, (TypeName[])new TypeName[]{andWithO, WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT)})).addStatement("return column($S)", new Object[]{fieldName}).build());
        }
        classBuilder.addType(nestedBuilder2.build());
        ParameterizedTypeName orWithO = ParameterizedTypeName.get((ClassName)classNameOr, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")});
        nestedBuilder2 = TypeSpec.classBuilder((ClassName)classNameOr).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addTypeVariable(TypeVariableName.get((String)"O", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)classNameSegment, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})})).superclass((TypeName)ParameterizedTypeName.get((ClassName)classNameBaseOr, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O"), orWithO}));
        nestedBuilder2.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(TypeVariableName.get((String)"T", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)classNameBaseTable, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT)})})).addParameter(ParameterSpec.builder((TypeName)TypeVariableName.get((String)"O"), (String)"owner", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)TypeVariableName.get((String)"T"), (String)"table", (Modifier[])new Modifier[0]).build()).addStatement("super(owner, table)", new Object[0]).build());
        nestedBuilder2.addMethod(MethodSpec.methodBuilder((String)"and").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameAnd, (TypeName[])new TypeName[]{orWithO})).addStatement("$T x = new $T<>(getThis(), getTable())", new Object[]{ParameterizedTypeName.get((ClassName)classNameAnd, (TypeName[])new TypeName[]{orWithO}), classNameAnd}).addStatement("addCriterion(new $T<>(getThis(), x))", new Object[]{classNameBaseCriterion}).addStatement("return x", new Object[0]).build());
        nestedBuilder2.addMethod(MethodSpec.methodBuilder((String)"or").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameOr, (TypeName[])new TypeName[]{orWithO})).addStatement("$T x = new $T<>(getThis(), getTable())", new Object[]{ParameterizedTypeName.get((ClassName)classNameOr, (TypeName[])new TypeName[]{orWithO}), classNameOr}).addStatement("addCriterion(new $T<>(getThis(), x))", new Object[]{classNameBaseCriterion}).addStatement("return x", new Object[0]).build());
        for (JdbcBeanInfo.FieldInfo field : beanInfo.getFields()) {
            fieldName = field.getFieldName();
            nestedBuilder2.addMethod(MethodSpec.methodBuilder((String)fieldName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameBaseCriterion, (TypeName[])new TypeName[]{orWithO, WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT)})).addStatement("return column($S)", new Object[]{fieldName}).build());
        }
        for (JdbcBeanInfo.ExpressionInfo expression : beanInfo.getExpressions()) {
            fieldName = expression.getFieldName();
            nestedBuilder2.addMethod(MethodSpec.methodBuilder((String)fieldName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameBaseCriterion, (TypeName[])new TypeName[]{orWithO, WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT)})).addStatement("return column($S)", new Object[]{fieldName}).build());
        }
        classBuilder.addType(nestedBuilder2.build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"join").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addTypeVariable(TypeVariableName.get((String)"O", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)classNameBaseSelect, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})})).returns((TypeName)ParameterizedTypeName.get((ClassName)classNameJoinBuilder, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O"), ParameterizedTypeName.get((ClassName)classNameJoin, (TypeName[])new TypeName[]{TypeVariableName.get((String)"O")})})).addStatement("return $T.builder()", new Object[]{classNameJoin}).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"select").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)classNameSelect).addStatement("return new $T()", new Object[]{classNameSelect}).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"select").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)classNameSelect).addParameter((TypeName)ClassName.get(String.class), "alias", new Modifier[0]).addStatement("return new $T(alias)", new Object[]{classNameSelect}).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"insert").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)classNameInsert).addStatement("return new $T()", new Object[]{classNameInsert}).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"insert").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)classNameInsert).addParameter((TypeName)ClassName.get(String.class), "alias", new Modifier[0]).addStatement("return new $T(alias)", new Object[]{classNameInsert}).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"update").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)classNameUpdate).addStatement("return new $T()", new Object[]{classNameUpdate}).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"update").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)classNameUpdate).addParameter((TypeName)ClassName.get(String.class), "alias", new Modifier[0]).addStatement("return new $T(alias)", new Object[]{classNameUpdate}).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"delete").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)classNameDelete).addStatement("return new $T()", new Object[]{classNameDelete}).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"delete").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)classNameDelete).addParameter((TypeName)ClassName.get(String.class), "alias", new Modifier[0]).addStatement("return new $T(alias)", new Object[]{classNameDelete}).build());
        JavaFile javaFile = JavaFile.builder((String)sqlClassName.packageName(), (TypeSpec)classBuilder.build()).build();
        try {
            javaFile.writeTo(this.filer);
        }
        catch (IOException t) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, t.toString());
            t.printStackTrace();
        }
    }
}

