/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.annotation.processing;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import io.polaris.core.annotation.Access;
import io.polaris.core.annotation.processing.AccessBeanInfo;
import io.polaris.core.annotation.processing.BaseProcessor;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"io.polaris.core.annotation.Access"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class AccessProcessor
extends BaseProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(Access.class);
        set.forEach(element -> {
            if (!(element instanceof TypeElement)) {
                return;
            }
            AccessBeanInfo beanInfo = new AccessBeanInfo((TypeElement)element);
            if (beanInfo.isAccessFluent()) {
                this.generateFluentClass(beanInfo);
            }
            if (beanInfo.isAccessFields()) {
                this.generateFieldsClass(beanInfo);
            }
            if (beanInfo.isAccessGetters()) {
                this.generateGettersClass(beanInfo);
            }
            if (beanInfo.isAccessSetters()) {
                this.generateSettersClass(beanInfo);
            }
            if (beanInfo.isAccessMap()) {
                this.generateMapClass(beanInfo);
            }
        });
        return true;
    }

    private void generateFieldsClass(AccessBeanInfo beanInfo) {
        ClassName className = beanInfo.getFieldsClassName();
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((ClassName)className).addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (AccessBeanInfo.FieldInfo field : beanInfo.getFields()) {
            if (!field.isAccessField()) continue;
            classBuilder.addField(FieldSpec.builder((TypeName)ClassName.get(String.class), (String)field.getFieldName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{field.getFieldName()}).build());
        }
        JavaFile javaFile = JavaFile.builder((String)className.packageName(), (TypeSpec)classBuilder.build()).build();
        try {
            javaFile.writeTo(this.filer);
        }
        catch (IOException t) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, t.toString());
        }
    }

    private void generateGettersClass(AccessBeanInfo beanInfo) {
        ClassName className = beanInfo.getGettersClassName();
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((ClassName)className).addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (AccessBeanInfo.FieldInfo field : beanInfo.getFields()) {
            if (!field.isAccessGetter()) continue;
            classBuilder.addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{beanInfo.getBeanTypeName(), field.getTypeName().box()}), (String)field.getGetterName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$L::$L", new Object[]{beanInfo.getBeanTypeName(), field.getGetterName()}).build());
        }
        JavaFile javaFile = JavaFile.builder((String)className.packageName(), (TypeSpec)classBuilder.build()).build();
        try {
            javaFile.writeTo(this.filer);
        }
        catch (IOException t) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, t.toString());
        }
    }

    private void generateSettersClass(AccessBeanInfo beanInfo) {
        ClassName className = beanInfo.getSettersClassName();
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((ClassName)className).addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (AccessBeanInfo.FieldInfo field : beanInfo.getFields()) {
            if (!field.isAccessSetter()) continue;
            classBuilder.addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(BiConsumer.class), (TypeName[])new TypeName[]{beanInfo.getBeanTypeName(), field.getTypeName().box()}), (String)field.getSetterName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$L::$L", new Object[]{beanInfo.getBeanTypeName(), field.getSetterName()}).build());
        }
        JavaFile javaFile = JavaFile.builder((String)className.packageName(), (TypeSpec)classBuilder.build()).build();
        try {
            javaFile.writeTo(this.filer);
        }
        catch (IOException t) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, t.toString());
        }
    }

    private void generateMapClass(AccessBeanInfo beanInfo) {
        ClassName className = beanInfo.getMapClassName();
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((ClassName)className).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(Object.class)})).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(AbstractMap.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(Object.class)})).addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(Type.class)}), (String)"types", (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.FINAL, Modifier.PRIVATE}).build()).addField(FieldSpec.builder((TypeName)beanInfo.getBeanTypeName(), (String)"bean", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PRIVATE}).build()).addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ParameterizedTypeName.get((ClassName)ClassName.get(Supplier.class), (TypeName[])new TypeName[]{ClassName.get(Object.class)})}), (String)"getters", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PRIVATE}).build()).addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{ClassName.get(Object.class)})}), (String)"setters", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PRIVATE}).build()).addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(BiFunction.class), (TypeName[])new TypeName[]{ClassName.get(Type.class), ClassName.get(Object.class), ClassName.get(Object.class)}), (String)"converter", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PRIVATE}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)beanInfo.getBeanTypeName(), (String)"bean", (Modifier[])new Modifier[]{Modifier.FINAL}).build()).addStatement("this(bean, (t,o)->$T.convert(t,o))", new Object[]{ClassName.get((String)"io.polaris.core.converter", (String)"Converters", (String[])new String[0])}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)beanInfo.getBeanTypeName(), (String)"bean", (Modifier[])new Modifier[]{Modifier.FINAL}).build()).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(BiFunction.class), (TypeName[])new TypeName[]{ClassName.get(Type.class), ClassName.get(Object.class), ClassName.get(Object.class)}), (String)"converter", (Modifier[])new Modifier[]{Modifier.FINAL}).build()).addStatement("this.bean = bean", new Object[0]).addStatement("this.converter = converter", new Object[0]).addStatement("this.getters = new $T()", new Object[]{TypeName.get(HashMap.class)}).addStatement("this.setters = new $T()", new Object[]{TypeName.get(HashMap.class)}).addStatement("this.init()", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"of").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)className).addParameter(ParameterSpec.builder((TypeName)beanInfo.getBeanTypeName(), (String)"bean", (Modifier[])new Modifier[]{Modifier.FINAL}).build()).addStatement("return new $T(bean)", new Object[]{className}).build()).addMethod(MethodSpec.methodBuilder((String)"get").returns(beanInfo.getBeanTypeName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return this.bean", new Object[0]).build());
        CodeBlock.Builder staticInit = CodeBlock.builder().addStatement("types = new $T()", new Object[]{TypeName.get(HashMap.class)});
        for (AccessBeanInfo.FieldInfo field : beanInfo.getFields()) {
            boolean accessGetter = field.isAccessGetter();
            boolean accessSetter = field.isAccessSetter();
            if (!accessGetter && !accessSetter) continue;
            staticInit.add(CodeBlock.builder().beginControlFlow("try", new Object[0]).addStatement("$T t = $T.class.getDeclaredField($S).getGenericType()", new Object[]{ClassName.get(Type.class), field.getDeclaredClassName(), field.getFieldName()}).addStatement("types.put($S, t)", new Object[]{field.getFieldName()}).nextControlFlow("catch($T ignored)", new Object[]{ClassName.get(Exception.class)}).endControlFlow().build());
        }
        classBuilder.addStaticBlock(staticInit.build());
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"init").addModifiers(new Modifier[]{Modifier.PRIVATE});
        for (AccessBeanInfo.FieldInfo field : beanInfo.getFields()) {
            CodeBlock.Builder getterSetterCode = CodeBlock.builder().beginControlFlow("", new Object[0]);
            boolean accessGetter = field.isAccessGetter();
            boolean accessSetter = field.isAccessSetter();
            if (!accessGetter && !accessSetter) continue;
            if (accessGetter) {
                getterSetterCode.addStatement("$T getter = () -> this.bean.$L()", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Supplier.class), (TypeName[])new TypeName[]{ClassName.get(Object.class)}), field.getGetterName()}).addStatement("this.getters.put($S,getter)", new Object[]{field.getFieldName()});
            }
            if (accessSetter) {
                getterSetterCode.addStatement("$T setter = o-> this.bean.$L(($T)o)", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{ClassName.get(Object.class)}), field.getSetterName(), field.getTypeName().box()}).addStatement("this.setters.put($S,setter)", new Object[]{field.getFieldName()});
            }
            methodBuilder.addCode(getterSetterCode.endControlFlow().build());
        }
        classBuilder.addMethod(methodBuilder.build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"getType").addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).returns((TypeName)ClassName.get(Type.class)).addParameter(ParameterSpec.builder((TypeName)ClassName.get(String.class), (String)"key", (Modifier[])new Modifier[0]).build()).addStatement("return types.get(key)", new Object[0]).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"get").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get(Object.class)).addParameter(ParameterSpec.builder((TypeName)ClassName.get(Object.class), (String)"key", (Modifier[])new Modifier[0]).build()).addCode(CodeBlock.builder().beginControlFlow("if (!(key instanceof String))", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().build()).addStatement("$T supplier = this.getters.get((String) key)", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Supplier.class), (TypeName[])new TypeName[]{ClassName.get(Object.class)})}).addCode(CodeBlock.builder().beginControlFlow("if (supplier == null)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().build()).addStatement("return supplier.get()", new Object[0]).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"put").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get(Object.class)).addParameter(ParameterSpec.builder((TypeName)ClassName.get(String.class), (String)"key", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ClassName.get(Object.class), (String)"value", (Modifier[])new Modifier[0]).build()).addStatement("Object old = this.get(key)", new Object[0]).addStatement("$T consumer = this.setters.get(key)", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{ClassName.get(Object.class)})}).addCode(CodeBlock.builder().beginControlFlow("if (consumer != null)", new Object[0]).addStatement("value = this.converter.apply(types.get(key), value)", new Object[0]).addStatement("this.setters.get(key).accept(value)", new Object[0]).endControlFlow().build()).addStatement("return old", new Object[0]).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"putAll").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.VOID).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)ClassName.get(String.class)), WildcardTypeName.subtypeOf((TypeName)ClassName.get(Object.class))}), (String)"m", (Modifier[])new Modifier[0]).build()).addStatement("m.forEach((k, v) -> put(k,v))", new Object[0]).build());
        methodBuilder = MethodSpec.methodBuilder((String)"size").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.INT);
        methodBuilder.addStatement("return this.getters.size()", new Object[0]);
        classBuilder.addMethod(methodBuilder.build());
        methodBuilder = MethodSpec.methodBuilder((String)"isEmpty").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN);
        methodBuilder.addStatement("return this.getters.isEmpty()", new Object[0]);
        classBuilder.addMethod(methodBuilder.build());
        methodBuilder = MethodSpec.methodBuilder((String)"containsKey").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).addParameter(ParameterSpec.builder((TypeName)ClassName.get(Object.class), (String)"key", (Modifier[])new Modifier[0]).build());
        methodBuilder.addStatement("return this.getters.containsKey(key)", new Object[0]);
        classBuilder.addMethod(methodBuilder.build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"keySet").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Set.class), (TypeName[])new TypeName[]{ClassName.get(String.class)})).addStatement("return this.getters.keySet()", new Object[0]).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"values").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Collection.class), (TypeName[])new TypeName[]{ClassName.get(Object.class)})).addStatement("return super.values()", new Object[0]).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"entrySet").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Set.class), (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get(Map.Entry.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(Object.class)})})).addStatement("$T set = new $T()", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Set.class), (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get(Map.Entry.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(Object.class)})}), ParameterizedTypeName.get((ClassName)ClassName.get(HashSet.class), (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get(Map.Entry.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(Object.class)})})}).beginControlFlow("for($T e: getters.entrySet())", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Map.Entry.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ParameterizedTypeName.get((ClassName)ClassName.get(Supplier.class), (TypeName[])new TypeName[]{ClassName.get(Object.class)})})}).addStatement("String key = e.getKey()", new Object[0]).addStatement("set.add(new $T(key, e.getValue().get()))", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(AbstractMap.SimpleEntry.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(Object.class)})}).endControlFlow().addStatement("return set", new Object[0]).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"containsValue").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).addParameter(ParameterSpec.builder((TypeName)ClassName.get(Object.class), (String)"value", (Modifier[])new Modifier[0]).build()).addStatement("return super.containsValue(value)", new Object[0]).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"remove").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.get(Object.class)).addParameter(ParameterSpec.builder((TypeName)ClassName.get(Object.class), (String)"key", (Modifier[])new Modifier[0]).build()).addStatement("throw new $T()", new Object[]{ClassName.get(UnsupportedOperationException.class)}).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"clear").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.VOID).addStatement("throw new $T()", new Object[]{ClassName.get(UnsupportedOperationException.class)}).build());
        JavaFile javaFile = JavaFile.builder((String)className.packageName(), (TypeSpec)classBuilder.build()).build();
        try {
            javaFile.writeTo(this.filer);
        }
        catch (IOException t) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, t.toString());
        }
    }

    private void generateFluentClass(AccessBeanInfo beanInfo) {
        ClassName className = beanInfo.getFluentClassName();
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((ClassName)className).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(FieldSpec.builder((TypeName)beanInfo.getBeanTypeName(), (String)"bean", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PRIVATE}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)beanInfo.getBeanTypeName(), (String)"bean", (Modifier[])new Modifier[]{Modifier.FINAL}).build()).addStatement("this.bean = bean;", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"of").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)className).addParameter(ParameterSpec.builder((TypeName)beanInfo.getBeanTypeName(), (String)"bean", (Modifier[])new Modifier[]{Modifier.FINAL}).build()).addStatement("return new $T(bean)", new Object[]{className}).build()).addMethod(MethodSpec.methodBuilder((String)"get").returns(beanInfo.getBeanTypeName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return this.bean", new Object[0]).build());
        Object methodBuilder = MethodSpec.methodBuilder((String)"copy").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(TypeName.VOID).addParameter(ParameterSpec.builder((TypeName)beanInfo.getBeanTypeName(), (String)"orig", (Modifier[])new Modifier[]{Modifier.FINAL}).build()).addParameter(ParameterSpec.builder((TypeName)beanInfo.getBeanTypeName(), (String)"dest", (Modifier[])new Modifier[]{Modifier.FINAL}).build());
        for (AccessBeanInfo.FieldInfo field : beanInfo.getFields()) {
            if (!field.isAccessGetter() || !field.isAccessSetter()) continue;
            methodBuilder.addStatement("dest.$L(orig.$L())", new Object[]{field.getSetterName(), field.getGetterName()});
        }
        classBuilder.addMethod(methodBuilder.build());
        methodBuilder = MethodSpec.methodBuilder((String)"from").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)className).addParameter(ParameterSpec.builder((TypeName)beanInfo.getBeanTypeName(), (String)"orig", (Modifier[])new Modifier[]{Modifier.FINAL}).build());
        for (AccessBeanInfo.FieldInfo field : beanInfo.getFields()) {
            if (!field.isAccessGetter() || !field.isAccessSetter()) continue;
            methodBuilder.addStatement("this.bean.$L(orig.$L())", new Object[]{field.getSetterName(), field.getGetterName()});
        }
        classBuilder.addMethod(methodBuilder.addStatement("return this", new Object[0]).build());
        methodBuilder = MethodSpec.methodBuilder((String)"from").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)className).addParameter(ParameterSpec.builder((TypeName)className, (String)"orig", (Modifier[])new Modifier[]{Modifier.FINAL}).build());
        for (AccessBeanInfo.FieldInfo field : beanInfo.getFields()) {
            if (!field.isAccessGetter() || !field.isAccessSetter()) continue;
            methodBuilder.addStatement("this.bean.$L(orig.$L())", new Object[]{field.getSetterName(), field.getFieldName()});
        }
        classBuilder.addMethod(methodBuilder.addStatement("return this", new Object[0]).build());
        methodBuilder = MethodSpec.methodBuilder((String)"to").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)className).addParameter(ParameterSpec.builder((TypeName)beanInfo.getBeanTypeName(), (String)"dest", (Modifier[])new Modifier[]{Modifier.FINAL}).build());
        for (AccessBeanInfo.FieldInfo field : beanInfo.getFields()) {
            if (!field.isAccessGetter() || !field.isAccessSetter()) continue;
            methodBuilder.addStatement("dest.$L(this.bean.$L())", new Object[]{field.getSetterName(), field.getGetterName()});
        }
        classBuilder.addMethod(methodBuilder.addStatement("return this", new Object[0]).build());
        methodBuilder = MethodSpec.methodBuilder((String)"to").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)className).addParameter(ParameterSpec.builder((TypeName)className, (String)"dest", (Modifier[])new Modifier[]{Modifier.FINAL}).build());
        for (AccessBeanInfo.FieldInfo field : beanInfo.getFields()) {
            if (!field.isAccessGetter() || !field.isAccessSetter()) continue;
            methodBuilder.addStatement("dest.$L(this.bean.$L())", new Object[]{field.getFieldName(), field.getGetterName()});
        }
        classBuilder.addMethod(methodBuilder.addStatement("return this", new Object[0]).build());
        for (AccessBeanInfo.FieldInfo field : beanInfo.getFields()) {
            if (field.isAccessGetter()) {
                classBuilder.addMethod(MethodSpec.methodBuilder((String)field.getFieldName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(field.getTypeName()).addStatement("return this.bean.$L()", new Object[]{field.getGetterName()}).build());
            }
            if (!field.isAccessSetter()) continue;
            classBuilder.addMethod(MethodSpec.methodBuilder((String)field.getFieldName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)className).addParameter(ParameterSpec.builder((TypeName)field.getTypeName(), (String)field.getFieldName(), (Modifier[])new Modifier[]{Modifier.FINAL}).build()).addStatement("this.bean.$L($L)", new Object[]{field.getSetterName(), field.getFieldName()}).addStatement("return this", new Object[0]).build());
        }
        JavaFile javaFile = JavaFile.builder((String)className.packageName(), (TypeSpec)classBuilder.build()).build();
        try {
            javaFile.writeTo(this.filer);
        }
        catch (IOException t) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, t.toString());
        }
    }
}

