/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.annotation.processing;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import io.polaris.core.annotation.processing.AnnotationProcessorUtils;
import io.polaris.core.jdbc.annotation.Column;
import io.polaris.core.jdbc.annotation.Id;
import io.polaris.core.jdbc.annotation.Table;
import java.lang.reflect.Field;
import java.sql.Types;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;

public class JdbcBeanInfo {
    private TypeElement element;
    private String tableName;
    private String tableAlias;
    private String tableCatalog;
    private String tableSchema;
    private String metaSuffix;
    private TypeName beanTypeName;
    private ClassName beanClassName;
    private ClassName metaClassName;
    private List<FieldInfo> fields = new ArrayList<FieldInfo>();
    private boolean sqlGenerated;
    private String sqlSuffix;
    private ClassName sqlClassName;

    public JdbcBeanInfo(TypeElement element) {
        this.element = element;
        this.init();
    }

    private void init() {
        Table access = this.element.getAnnotation(Table.class);
        if (access == null) {
            return;
        }
        this.tableName = access.value();
        this.tableAlias = access.alias();
        this.tableCatalog = access.catalog();
        this.tableSchema = access.schema();
        this.metaSuffix = access.metaSuffix();
        this.sqlGenerated = access.sqlGenerated();
        this.sqlSuffix = access.sqlSuffix();
        this.beanTypeName = TypeName.get((TypeMirror)this.element.asType());
        this.beanClassName = ClassName.get((TypeElement)this.element);
        String simpleName = this.beanClassName.packageName().isEmpty() ? this.beanClassName.reflectionName() : this.beanClassName.reflectionName().substring(this.beanClassName.packageName().length() + 1);
        this.metaClassName = ClassName.get((String)this.beanClassName.packageName(), (String)(simpleName + this.metaSuffix), (String[])new String[0]);
        this.sqlClassName = ClassName.get((String)this.beanClassName.packageName(), (String)(simpleName + this.sqlSuffix), (String[])new String[0]);
        this.visitFieldElement(this.element);
    }

    private void visitFieldElement(TypeElement element) {
        HashSet<String> retrieved = new HashSet<String>();
        while (!Object.class.getName().equals(element.toString())) {
            TypeName declaredTypeName = TypeName.get((TypeMirror)element.asType());
            ClassName declaredClassName = ClassName.get((TypeElement)element);
            for (Element element2 : element.getEnclosedElements()) {
                Column column;
                String fieldName;
                VariableElement variableElement;
                if (!(element2 instanceof VariableElement) || (variableElement = (VariableElement)element2).getKind() != ElementKind.FIELD || variableElement.getModifiers().contains((Object)Modifier.STATIC) || retrieved.contains(fieldName = variableElement.getSimpleName().toString())) continue;
                retrieved.add(fieldName);
                if (variableElement.getModifiers().contains((Object)Modifier.TRANSIENT) || (column = variableElement.getAnnotation(Column.class)) != null && column.ignored()) continue;
                FieldInfo fieldInfo = new FieldInfo();
                fieldInfo.declaredTypeName = declaredTypeName;
                fieldInfo.declaredClassName = declaredClassName;
                fieldInfo.fieldTypeName = TypeName.get((TypeMirror)variableElement.asType());
                fieldInfo.fieldRawTypeName = AnnotationProcessorUtils.rawType(fieldInfo.fieldTypeName);
                fieldInfo.readColumn(fieldName, column, variableElement.getAnnotation(Id.class));
                this.fields.add(fieldInfo);
            }
            TypeMirror typeMirror = element.getSuperclass();
            if (typeMirror instanceof NoType) break;
            element = (TypeElement)((DeclaredType)typeMirror).asElement();
        }
    }

    public TypeElement getElement() {
        return this.element;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public String getTableCatalog() {
        return this.tableCatalog;
    }

    public String getTableSchema() {
        return this.tableSchema;
    }

    public String getMetaSuffix() {
        return this.metaSuffix;
    }

    public TypeName getBeanTypeName() {
        return this.beanTypeName;
    }

    public ClassName getBeanClassName() {
        return this.beanClassName;
    }

    public ClassName getMetaClassName() {
        return this.metaClassName;
    }

    public List<FieldInfo> getFields() {
        return this.fields;
    }

    public boolean isSqlGenerated() {
        return this.sqlGenerated;
    }

    public String getSqlSuffix() {
        return this.sqlSuffix;
    }

    public ClassName getSqlClassName() {
        return this.sqlClassName;
    }

    public void setElement(TypeElement element) {
        this.element = element;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setTableAlias(String tableAlias) {
        this.tableAlias = tableAlias;
    }

    public void setTableCatalog(String tableCatalog) {
        this.tableCatalog = tableCatalog;
    }

    public void setTableSchema(String tableSchema) {
        this.tableSchema = tableSchema;
    }

    public void setMetaSuffix(String metaSuffix) {
        this.metaSuffix = metaSuffix;
    }

    public void setBeanTypeName(TypeName beanTypeName) {
        this.beanTypeName = beanTypeName;
    }

    public void setBeanClassName(ClassName beanClassName) {
        this.beanClassName = beanClassName;
    }

    public void setMetaClassName(ClassName metaClassName) {
        this.metaClassName = metaClassName;
    }

    public void setFields(List<FieldInfo> fields) {
        this.fields = fields;
    }

    public void setSqlGenerated(boolean sqlGenerated) {
        this.sqlGenerated = sqlGenerated;
    }

    public void setSqlSuffix(String sqlSuffix) {
        this.sqlSuffix = sqlSuffix;
    }

    public void setSqlClassName(ClassName sqlClassName) {
        this.sqlClassName = sqlClassName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcBeanInfo)) {
            return false;
        }
        JdbcBeanInfo other = (JdbcBeanInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.sqlGenerated != other.sqlGenerated) {
            return false;
        }
        TypeElement this$element = this.element;
        TypeElement other$element = other.element;
        if (this$element == null ? other$element != null : !this$element.equals(other$element)) {
            return false;
        }
        String this$tableName = this.tableName;
        String other$tableName = other.tableName;
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$tableAlias = this.tableAlias;
        String other$tableAlias = other.tableAlias;
        if (this$tableAlias == null ? other$tableAlias != null : !this$tableAlias.equals(other$tableAlias)) {
            return false;
        }
        String this$tableCatalog = this.tableCatalog;
        String other$tableCatalog = other.tableCatalog;
        if (this$tableCatalog == null ? other$tableCatalog != null : !this$tableCatalog.equals(other$tableCatalog)) {
            return false;
        }
        String this$tableSchema = this.tableSchema;
        String other$tableSchema = other.tableSchema;
        if (this$tableSchema == null ? other$tableSchema != null : !this$tableSchema.equals(other$tableSchema)) {
            return false;
        }
        String this$metaSuffix = this.metaSuffix;
        String other$metaSuffix = other.metaSuffix;
        if (this$metaSuffix == null ? other$metaSuffix != null : !this$metaSuffix.equals(other$metaSuffix)) {
            return false;
        }
        TypeName this$beanTypeName = this.beanTypeName;
        TypeName other$beanTypeName = other.beanTypeName;
        if (this$beanTypeName == null ? other$beanTypeName != null : !this$beanTypeName.equals(other$beanTypeName)) {
            return false;
        }
        ClassName this$beanClassName = this.beanClassName;
        ClassName other$beanClassName = other.beanClassName;
        if (this$beanClassName == null ? other$beanClassName != null : !this$beanClassName.equals(other$beanClassName)) {
            return false;
        }
        ClassName this$metaClassName = this.metaClassName;
        ClassName other$metaClassName = other.metaClassName;
        if (this$metaClassName == null ? other$metaClassName != null : !this$metaClassName.equals(other$metaClassName)) {
            return false;
        }
        List<FieldInfo> this$fields = this.fields;
        List<FieldInfo> other$fields = other.fields;
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        String this$sqlSuffix = this.sqlSuffix;
        String other$sqlSuffix = other.sqlSuffix;
        if (this$sqlSuffix == null ? other$sqlSuffix != null : !this$sqlSuffix.equals(other$sqlSuffix)) {
            return false;
        }
        ClassName this$sqlClassName = this.sqlClassName;
        ClassName other$sqlClassName = other.sqlClassName;
        return !(this$sqlClassName == null ? other$sqlClassName != null : !this$sqlClassName.equals(other$sqlClassName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JdbcBeanInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.sqlGenerated ? 79 : 97);
        TypeElement $element = this.element;
        result = result * 59 + ($element == null ? 43 : $element.hashCode());
        String $tableName = this.tableName;
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $tableAlias = this.tableAlias;
        result = result * 59 + ($tableAlias == null ? 43 : $tableAlias.hashCode());
        String $tableCatalog = this.tableCatalog;
        result = result * 59 + ($tableCatalog == null ? 43 : $tableCatalog.hashCode());
        String $tableSchema = this.tableSchema;
        result = result * 59 + ($tableSchema == null ? 43 : $tableSchema.hashCode());
        String $metaSuffix = this.metaSuffix;
        result = result * 59 + ($metaSuffix == null ? 43 : $metaSuffix.hashCode());
        TypeName $beanTypeName = this.beanTypeName;
        result = result * 59 + ($beanTypeName == null ? 43 : $beanTypeName.hashCode());
        ClassName $beanClassName = this.beanClassName;
        result = result * 59 + ($beanClassName == null ? 43 : $beanClassName.hashCode());
        ClassName $metaClassName = this.metaClassName;
        result = result * 59 + ($metaClassName == null ? 43 : $metaClassName.hashCode());
        List<FieldInfo> $fields = this.fields;
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        String $sqlSuffix = this.sqlSuffix;
        result = result * 59 + ($sqlSuffix == null ? 43 : $sqlSuffix.hashCode());
        ClassName $sqlClassName = this.sqlClassName;
        result = result * 59 + ($sqlClassName == null ? 43 : $sqlClassName.hashCode());
        return result;
    }

    public String toString() {
        return "JdbcBeanInfo(element=" + this.element + ", tableName=" + this.tableName + ", tableAlias=" + this.tableAlias + ", tableCatalog=" + this.tableCatalog + ", tableSchema=" + this.tableSchema + ", metaSuffix=" + this.metaSuffix + ", beanTypeName=" + this.beanTypeName + ", beanClassName=" + this.beanClassName + ", metaClassName=" + this.metaClassName + ", fields=" + this.fields + ", sqlGenerated=" + this.sqlGenerated + ", sqlSuffix=" + this.sqlSuffix + ", sqlClassName=" + this.sqlClassName + ")";
    }

    public static class FieldInfo {
        private TypeName declaredTypeName;
        private ClassName declaredClassName;
        private String fieldName;
        private TypeName fieldTypeName;
        private TypeName fieldRawTypeName;
        private boolean id = false;
        private boolean autoIncrement = false;
        private String seqName;
        private int jdbcTypeValue;
        private String jdbcTypeName;
        private String columnName;
        private boolean nullable = false;
        private boolean insertable = true;
        private boolean updatable = true;
        private String updateDefault;
        private String insertDefault;
        private boolean version = false;
        private boolean logicDeleted = false;
        private boolean createTime = false;
        private boolean updateTime = false;

        public void readColumn(String fieldName, Column column, Id id) {
            this.fieldName = fieldName;
            if (column != null) {
                this.columnName = column.value().trim();
                this.jdbcTypeName = column.jdbcType().trim().toUpperCase();
                this.nullable = column.nullable();
                this.insertable = column.insertable();
                this.updatable = column.updatable();
                this.updateDefault = column.updateDefault();
                this.insertDefault = column.insertDefault();
                this.version = column.version();
                this.logicDeleted = column.logicDeleted();
                this.createTime = column.createTime();
                this.updateTime = column.updateTime();
            }
            if (this.jdbcTypeName != null && this.jdbcTypeName.length() > 0) {
                try {
                    Field declaredField = Types.class.getDeclaredField(this.jdbcTypeName);
                    this.jdbcTypeValue = declaredField.getInt(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (id != null) {
                this.id = true;
                this.autoIncrement = id.auto();
                this.seqName = id.seqName();
            }
            if (this.columnName == null || this.columnName.length() == 0) {
                this.columnName = AnnotationProcessorUtils.camelToUnderlineUpperCase(this.fieldName);
            }
        }

        public TypeName getDeclaredTypeName() {
            return this.declaredTypeName;
        }

        public ClassName getDeclaredClassName() {
            return this.declaredClassName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public TypeName getFieldTypeName() {
            return this.fieldTypeName;
        }

        public TypeName getFieldRawTypeName() {
            return this.fieldRawTypeName;
        }

        public boolean isId() {
            return this.id;
        }

        public boolean isAutoIncrement() {
            return this.autoIncrement;
        }

        public String getSeqName() {
            return this.seqName;
        }

        public int getJdbcTypeValue() {
            return this.jdbcTypeValue;
        }

        public String getJdbcTypeName() {
            return this.jdbcTypeName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public boolean isInsertable() {
            return this.insertable;
        }

        public boolean isUpdatable() {
            return this.updatable;
        }

        public String getUpdateDefault() {
            return this.updateDefault;
        }

        public String getInsertDefault() {
            return this.insertDefault;
        }

        public boolean isVersion() {
            return this.version;
        }

        public boolean isLogicDeleted() {
            return this.logicDeleted;
        }

        public boolean isCreateTime() {
            return this.createTime;
        }

        public boolean isUpdateTime() {
            return this.updateTime;
        }

        public void setDeclaredTypeName(TypeName declaredTypeName) {
            this.declaredTypeName = declaredTypeName;
        }

        public void setDeclaredClassName(ClassName declaredClassName) {
            this.declaredClassName = declaredClassName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public void setFieldTypeName(TypeName fieldTypeName) {
            this.fieldTypeName = fieldTypeName;
        }

        public void setFieldRawTypeName(TypeName fieldRawTypeName) {
            this.fieldRawTypeName = fieldRawTypeName;
        }

        public void setId(boolean id) {
            this.id = id;
        }

        public void setAutoIncrement(boolean autoIncrement) {
            this.autoIncrement = autoIncrement;
        }

        public void setSeqName(String seqName) {
            this.seqName = seqName;
        }

        public void setJdbcTypeValue(int jdbcTypeValue) {
            this.jdbcTypeValue = jdbcTypeValue;
        }

        public void setJdbcTypeName(String jdbcTypeName) {
            this.jdbcTypeName = jdbcTypeName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public void setNullable(boolean nullable) {
            this.nullable = nullable;
        }

        public void setInsertable(boolean insertable) {
            this.insertable = insertable;
        }

        public void setUpdatable(boolean updatable) {
            this.updatable = updatable;
        }

        public void setUpdateDefault(String updateDefault) {
            this.updateDefault = updateDefault;
        }

        public void setInsertDefault(String insertDefault) {
            this.insertDefault = insertDefault;
        }

        public void setVersion(boolean version) {
            this.version = version;
        }

        public void setLogicDeleted(boolean logicDeleted) {
            this.logicDeleted = logicDeleted;
        }

        public void setCreateTime(boolean createTime) {
            this.createTime = createTime;
        }

        public void setUpdateTime(boolean updateTime) {
            this.updateTime = updateTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldInfo)) {
                return false;
            }
            FieldInfo other = (FieldInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.id != other.id) {
                return false;
            }
            if (this.autoIncrement != other.autoIncrement) {
                return false;
            }
            if (this.jdbcTypeValue != other.jdbcTypeValue) {
                return false;
            }
            if (this.nullable != other.nullable) {
                return false;
            }
            if (this.insertable != other.insertable) {
                return false;
            }
            if (this.updatable != other.updatable) {
                return false;
            }
            if (this.version != other.version) {
                return false;
            }
            if (this.logicDeleted != other.logicDeleted) {
                return false;
            }
            if (this.createTime != other.createTime) {
                return false;
            }
            if (this.updateTime != other.updateTime) {
                return false;
            }
            TypeName this$declaredTypeName = this.declaredTypeName;
            TypeName other$declaredTypeName = other.declaredTypeName;
            if (this$declaredTypeName == null ? other$declaredTypeName != null : !this$declaredTypeName.equals(other$declaredTypeName)) {
                return false;
            }
            ClassName this$declaredClassName = this.declaredClassName;
            ClassName other$declaredClassName = other.declaredClassName;
            if (this$declaredClassName == null ? other$declaredClassName != null : !this$declaredClassName.equals(other$declaredClassName)) {
                return false;
            }
            String this$fieldName = this.fieldName;
            String other$fieldName = other.fieldName;
            if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
                return false;
            }
            TypeName this$fieldTypeName = this.fieldTypeName;
            TypeName other$fieldTypeName = other.fieldTypeName;
            if (this$fieldTypeName == null ? other$fieldTypeName != null : !this$fieldTypeName.equals(other$fieldTypeName)) {
                return false;
            }
            TypeName this$fieldRawTypeName = this.fieldRawTypeName;
            TypeName other$fieldRawTypeName = other.fieldRawTypeName;
            if (this$fieldRawTypeName == null ? other$fieldRawTypeName != null : !this$fieldRawTypeName.equals(other$fieldRawTypeName)) {
                return false;
            }
            String this$seqName = this.seqName;
            String other$seqName = other.seqName;
            if (this$seqName == null ? other$seqName != null : !this$seqName.equals(other$seqName)) {
                return false;
            }
            String this$jdbcTypeName = this.jdbcTypeName;
            String other$jdbcTypeName = other.jdbcTypeName;
            if (this$jdbcTypeName == null ? other$jdbcTypeName != null : !this$jdbcTypeName.equals(other$jdbcTypeName)) {
                return false;
            }
            String this$columnName = this.columnName;
            String other$columnName = other.columnName;
            if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
                return false;
            }
            String this$updateDefault = this.updateDefault;
            String other$updateDefault = other.updateDefault;
            if (this$updateDefault == null ? other$updateDefault != null : !this$updateDefault.equals(other$updateDefault)) {
                return false;
            }
            String this$insertDefault = this.insertDefault;
            String other$insertDefault = other.insertDefault;
            return !(this$insertDefault == null ? other$insertDefault != null : !this$insertDefault.equals(other$insertDefault));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FieldInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.id ? 79 : 97);
            result = result * 59 + (this.autoIncrement ? 79 : 97);
            result = result * 59 + this.jdbcTypeValue;
            result = result * 59 + (this.nullable ? 79 : 97);
            result = result * 59 + (this.insertable ? 79 : 97);
            result = result * 59 + (this.updatable ? 79 : 97);
            result = result * 59 + (this.version ? 79 : 97);
            result = result * 59 + (this.logicDeleted ? 79 : 97);
            result = result * 59 + (this.createTime ? 79 : 97);
            result = result * 59 + (this.updateTime ? 79 : 97);
            TypeName $declaredTypeName = this.declaredTypeName;
            result = result * 59 + ($declaredTypeName == null ? 43 : $declaredTypeName.hashCode());
            ClassName $declaredClassName = this.declaredClassName;
            result = result * 59 + ($declaredClassName == null ? 43 : $declaredClassName.hashCode());
            String $fieldName = this.fieldName;
            result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
            TypeName $fieldTypeName = this.fieldTypeName;
            result = result * 59 + ($fieldTypeName == null ? 43 : $fieldTypeName.hashCode());
            TypeName $fieldRawTypeName = this.fieldRawTypeName;
            result = result * 59 + ($fieldRawTypeName == null ? 43 : $fieldRawTypeName.hashCode());
            String $seqName = this.seqName;
            result = result * 59 + ($seqName == null ? 43 : $seqName.hashCode());
            String $jdbcTypeName = this.jdbcTypeName;
            result = result * 59 + ($jdbcTypeName == null ? 43 : $jdbcTypeName.hashCode());
            String $columnName = this.columnName;
            result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
            String $updateDefault = this.updateDefault;
            result = result * 59 + ($updateDefault == null ? 43 : $updateDefault.hashCode());
            String $insertDefault = this.insertDefault;
            result = result * 59 + ($insertDefault == null ? 43 : $insertDefault.hashCode());
            return result;
        }

        public String toString() {
            return "JdbcBeanInfo.FieldInfo(declaredTypeName=" + this.declaredTypeName + ", declaredClassName=" + this.declaredClassName + ", fieldName=" + this.fieldName + ", fieldTypeName=" + this.fieldTypeName + ", fieldRawTypeName=" + this.fieldRawTypeName + ", id=" + this.id + ", autoIncrement=" + this.autoIncrement + ", seqName=" + this.seqName + ", jdbcTypeValue=" + this.jdbcTypeValue + ", jdbcTypeName=" + this.jdbcTypeName + ", columnName=" + this.columnName + ", nullable=" + this.nullable + ", insertable=" + this.insertable + ", updatable=" + this.updatable + ", updateDefault=" + this.updateDefault + ", insertDefault=" + this.insertDefault + ", version=" + this.version + ", logicDeleted=" + this.logicDeleted + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + ")";
        }
    }
}

