/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc;

public class ColumnMeta
implements Cloneable {
    private final String catalog;
    private final String schema;
    private final String tableName;
    private final String fieldName;
    private final Class<?> fieldType;
    private final String columnName;
    private final String jdbcType;
    private final int jdbcTypeValue;
    private final boolean primaryKey;
    private final boolean autoIncrement;
    private final String seqName;
    private final boolean nullable;
    private final boolean insertable;
    private final boolean updatable;
    private final String updateDefault;
    private final String insertDefault;
    private final boolean version;
    private final boolean logicDeleted;
    private final boolean createTime;
    private final boolean updateTime;

    public ColumnMeta(String catalog, String schema, String tableName, String fieldName, Class<?> fieldType, String columnName, String jdbcType, int jdbcTypeValue, boolean primaryKey, boolean autoIncrement, String seqName, boolean nullable, boolean insertable, boolean updatable, String updateDefault, String insertDefault, boolean version, boolean logicDeleted, boolean createTime, boolean updateTime) {
        this.catalog = catalog;
        this.schema = schema;
        this.tableName = tableName;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.columnName = columnName;
        this.jdbcType = jdbcType;
        this.jdbcTypeValue = jdbcTypeValue;
        this.primaryKey = primaryKey;
        this.autoIncrement = autoIncrement;
        this.seqName = seqName;
        this.nullable = nullable;
        this.insertable = insertable;
        this.updatable = updatable;
        this.updateDefault = updateDefault;
        this.insertDefault = insertDefault;
        this.version = version;
        this.logicDeleted = logicDeleted;
        this.createTime = createTime;
        this.updateTime = updateTime;
    }

    public ColumnMeta clone() {
        try {
            ColumnMeta clone = (ColumnMeta)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public static ColumnMetaBuilder builder() {
        return new ColumnMetaBuilder();
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Class<?> getFieldType() {
        return this.fieldType;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getJdbcType() {
        return this.jdbcType;
    }

    public int getJdbcTypeValue() {
        return this.jdbcTypeValue;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public String getSeqName() {
        return this.seqName;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public String getUpdateDefault() {
        return this.updateDefault;
    }

    public String getInsertDefault() {
        return this.insertDefault;
    }

    public boolean isVersion() {
        return this.version;
    }

    public boolean isLogicDeleted() {
        return this.logicDeleted;
    }

    public boolean isCreateTime() {
        return this.createTime;
    }

    public boolean isUpdateTime() {
        return this.updateTime;
    }

    public String toString() {
        return "ColumnMeta(catalog=" + this.catalog + ", schema=" + this.schema + ", tableName=" + this.tableName + ", fieldName=" + this.fieldName + ", fieldType=" + this.fieldType + ", columnName=" + this.columnName + ", jdbcType=" + this.jdbcType + ", jdbcTypeValue=" + this.jdbcTypeValue + ", primaryKey=" + this.primaryKey + ", autoIncrement=" + this.autoIncrement + ", seqName=" + this.seqName + ", nullable=" + this.nullable + ", insertable=" + this.insertable + ", updatable=" + this.updatable + ", updateDefault=" + this.updateDefault + ", insertDefault=" + this.insertDefault + ", version=" + this.version + ", logicDeleted=" + this.logicDeleted + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnMeta)) {
            return false;
        }
        ColumnMeta other = (ColumnMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.jdbcTypeValue != other.jdbcTypeValue) {
            return false;
        }
        if (this.primaryKey != other.primaryKey) {
            return false;
        }
        if (this.autoIncrement != other.autoIncrement) {
            return false;
        }
        if (this.nullable != other.nullable) {
            return false;
        }
        if (this.insertable != other.insertable) {
            return false;
        }
        if (this.updatable != other.updatable) {
            return false;
        }
        if (this.version != other.version) {
            return false;
        }
        if (this.logicDeleted != other.logicDeleted) {
            return false;
        }
        if (this.createTime != other.createTime) {
            return false;
        }
        if (this.updateTime != other.updateTime) {
            return false;
        }
        String this$catalog = this.catalog;
        String other$catalog = other.catalog;
        if (this$catalog == null ? other$catalog != null : !this$catalog.equals(other$catalog)) {
            return false;
        }
        String this$schema = this.schema;
        String other$schema = other.schema;
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$tableName = this.tableName;
        String other$tableName = other.tableName;
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$fieldName = this.fieldName;
        String other$fieldName = other.fieldName;
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        Class<?> this$fieldType = this.fieldType;
        Class<?> other$fieldType = other.fieldType;
        if (this$fieldType == null ? other$fieldType != null : !this$fieldType.equals(other$fieldType)) {
            return false;
        }
        String this$columnName = this.columnName;
        String other$columnName = other.columnName;
        if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
            return false;
        }
        String this$jdbcType = this.jdbcType;
        String other$jdbcType = other.jdbcType;
        if (this$jdbcType == null ? other$jdbcType != null : !this$jdbcType.equals(other$jdbcType)) {
            return false;
        }
        String this$seqName = this.seqName;
        String other$seqName = other.seqName;
        if (this$seqName == null ? other$seqName != null : !this$seqName.equals(other$seqName)) {
            return false;
        }
        String this$updateDefault = this.updateDefault;
        String other$updateDefault = other.updateDefault;
        if (this$updateDefault == null ? other$updateDefault != null : !this$updateDefault.equals(other$updateDefault)) {
            return false;
        }
        String this$insertDefault = this.insertDefault;
        String other$insertDefault = other.insertDefault;
        return !(this$insertDefault == null ? other$insertDefault != null : !this$insertDefault.equals(other$insertDefault));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ColumnMeta;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.jdbcTypeValue;
        result = result * 59 + (this.primaryKey ? 79 : 97);
        result = result * 59 + (this.autoIncrement ? 79 : 97);
        result = result * 59 + (this.nullable ? 79 : 97);
        result = result * 59 + (this.insertable ? 79 : 97);
        result = result * 59 + (this.updatable ? 79 : 97);
        result = result * 59 + (this.version ? 79 : 97);
        result = result * 59 + (this.logicDeleted ? 79 : 97);
        result = result * 59 + (this.createTime ? 79 : 97);
        result = result * 59 + (this.updateTime ? 79 : 97);
        String $catalog = this.catalog;
        result = result * 59 + ($catalog == null ? 43 : $catalog.hashCode());
        String $schema = this.schema;
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $tableName = this.tableName;
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $fieldName = this.fieldName;
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        Class<?> $fieldType = this.fieldType;
        result = result * 59 + ($fieldType == null ? 43 : $fieldType.hashCode());
        String $columnName = this.columnName;
        result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
        String $jdbcType = this.jdbcType;
        result = result * 59 + ($jdbcType == null ? 43 : $jdbcType.hashCode());
        String $seqName = this.seqName;
        result = result * 59 + ($seqName == null ? 43 : $seqName.hashCode());
        String $updateDefault = this.updateDefault;
        result = result * 59 + ($updateDefault == null ? 43 : $updateDefault.hashCode());
        String $insertDefault = this.insertDefault;
        result = result * 59 + ($insertDefault == null ? 43 : $insertDefault.hashCode());
        return result;
    }

    public static class ColumnMetaBuilder {
        private String catalog;
        private String schema;
        private String tableName;
        private String fieldName;
        private Class<?> fieldType;
        private String columnName;
        private String jdbcType;
        private int jdbcTypeValue;
        private boolean primaryKey;
        private boolean autoIncrement;
        private String seqName;
        private boolean nullable;
        private boolean insertable;
        private boolean updatable;
        private String updateDefault;
        private String insertDefault;
        private boolean version;
        private boolean logicDeleted;
        private boolean createTime;
        private boolean updateTime;

        ColumnMetaBuilder() {
        }

        public ColumnMetaBuilder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public ColumnMetaBuilder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public ColumnMetaBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public ColumnMetaBuilder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public ColumnMetaBuilder fieldType(Class<?> fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        public ColumnMetaBuilder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public ColumnMetaBuilder jdbcType(String jdbcType) {
            this.jdbcType = jdbcType;
            return this;
        }

        public ColumnMetaBuilder jdbcTypeValue(int jdbcTypeValue) {
            this.jdbcTypeValue = jdbcTypeValue;
            return this;
        }

        public ColumnMetaBuilder primaryKey(boolean primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public ColumnMetaBuilder autoIncrement(boolean autoIncrement) {
            this.autoIncrement = autoIncrement;
            return this;
        }

        public ColumnMetaBuilder seqName(String seqName) {
            this.seqName = seqName;
            return this;
        }

        public ColumnMetaBuilder nullable(boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        public ColumnMetaBuilder insertable(boolean insertable) {
            this.insertable = insertable;
            return this;
        }

        public ColumnMetaBuilder updatable(boolean updatable) {
            this.updatable = updatable;
            return this;
        }

        public ColumnMetaBuilder updateDefault(String updateDefault) {
            this.updateDefault = updateDefault;
            return this;
        }

        public ColumnMetaBuilder insertDefault(String insertDefault) {
            this.insertDefault = insertDefault;
            return this;
        }

        public ColumnMetaBuilder version(boolean version) {
            this.version = version;
            return this;
        }

        public ColumnMetaBuilder logicDeleted(boolean logicDeleted) {
            this.logicDeleted = logicDeleted;
            return this;
        }

        public ColumnMetaBuilder createTime(boolean createTime) {
            this.createTime = createTime;
            return this;
        }

        public ColumnMetaBuilder updateTime(boolean updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public ColumnMeta build() {
            return new ColumnMeta(this.catalog, this.schema, this.tableName, this.fieldName, this.fieldType, this.columnName, this.jdbcType, this.jdbcTypeValue, this.primaryKey, this.autoIncrement, this.seqName, this.nullable, this.insertable, this.updatable, this.updateDefault, this.insertDefault, this.version, this.logicDeleted, this.createTime, this.updateTime);
        }

        public String toString() {
            return "ColumnMeta.ColumnMetaBuilder(catalog=" + this.catalog + ", schema=" + this.schema + ", tableName=" + this.tableName + ", fieldName=" + this.fieldName + ", fieldType=" + this.fieldType + ", columnName=" + this.columnName + ", jdbcType=" + this.jdbcType + ", jdbcTypeValue=" + this.jdbcTypeValue + ", primaryKey=" + this.primaryKey + ", autoIncrement=" + this.autoIncrement + ", seqName=" + this.seqName + ", nullable=" + this.nullable + ", insertable=" + this.insertable + ", updatable=" + this.updatable + ", updateDefault=" + this.updateDefault + ", insertDefault=" + this.insertDefault + ", version=" + this.version + ", logicDeleted=" + this.logicDeleted + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + ")";
        }
    }
}

