/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.concurrent.zookeeper;

import io.polaris.core.env.GlobalStdEnv;
import io.polaris.core.string.Strings;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.retry.RetryForever;
import org.apache.curator.retry.RetryOneTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkClients {
    private static final Logger log = LoggerFactory.getLogger(ZkClients.class);
    public static final String ZOOKEEPER_NAMESPACE = "system.zookeeper.namespace";
    public static final String ZOOKEEPER_ADDRESS = "system.zookeeper.address";
    public static final String CURATOR_RETRY = "system.zookeeper.curator.retry";
    private static final Map<String, CuratorFramework> factories = new ConcurrentHashMap<String, CuratorFramework>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CuratorFramework getClient(String zkAddress) {
        if (Strings.isBlank((CharSequence)zkAddress)) {
            throw new IllegalArgumentException(zkAddress);
        }
        log.debug("\u83b7\u53d6 ZK \u5ba2\u6237\u7aef\u8fde\u63a5. zkAddress: {}", (Object)zkAddress);
        CuratorFramework client = factories.get(zkAddress);
        if (client == null || client.getState() != CuratorFrameworkState.STARTED) {
            Map<String, CuratorFramework> map = factories;
            synchronized (map) {
                client = factories.get(zkAddress);
                if (client == null || client.getState() != CuratorFrameworkState.STARTED) {
                    client = CuratorFrameworkFactory.newClient((String)zkAddress, (RetryPolicy)ZkClients.getRetryPolicy());
                    client.start();
                    log.info("\u521d\u59cb\u5316 ZK \u5ba2\u6237\u7aef\u8fde\u63a5\u5e76\u542f\u52a8. zkAddress: {}", (Object)zkAddress);
                    factories.put(zkAddress, client);
                }
            }
        }
        return client;
    }

    public static CuratorFramework getClient() {
        return ZkClients.getClient(ZkClients.getAddress());
    }

    public static String getAddress() {
        return GlobalStdEnv.get((String)ZOOKEEPER_ADDRESS);
    }

    public static String getNamespace() {
        return GlobalStdEnv.get((String)ZOOKEEPER_NAMESPACE);
    }

    public static RetryPolicy getRetryPolicy() {
        try {
            int retry = Integer.parseInt(GlobalStdEnv.get((String)CURATOR_RETRY, (String)"3"));
            return ZkClients.retryPolicy(retry);
        }
        catch (Exception e) {
            return ZkClients.maxRetryPolicy();
        }
    }

    public static RetryPolicy retryPolicy(int retry) {
        if (retry <= 0) {
            return new RetryOneTime(100);
        }
        return new ExponentialBackoffRetry(100, retry);
    }

    public static RetryPolicy maxRetryPolicy() {
        return new ExponentialBackoffRetry(100, 29);
    }

    public static RetryPolicy retryForeverPolicy() {
        return new RetryForever(2000);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.warn("\u8fd0\u884cJVM\u865a\u62df\u673a\u505c\u6b62\u94a9\u5b50: ZkClients.close()");
            factories.forEach((k, v) -> v.close());
        }));
    }
}

