/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.concurrent.zookeeper;

import io.polaris.concurrent.zookeeper.ConnProps;
import io.polaris.core.string.Strings;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.retry.RetryForever;
import org.apache.curator.retry.RetryOneTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkClientCache {
    private static final Logger log = LoggerFactory.getLogger(ZkClientCache.class);
    private static final Map<ConnProps, CuratorFramework> factories = new ConcurrentHashMap<ConnProps, CuratorFramework>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CuratorFramework getClient(ConnProps props) {
        String address = props.getAddress();
        int retry = props.getRetry();
        if (Strings.isBlank((CharSequence)address)) {
            throw new IllegalArgumentException(address);
        }
        log.debug("\u83b7\u53d6\u5ba2\u6237\u7aef\u8fde\u63a5. address: {}", (Object)address);
        CuratorFramework client = factories.get(props);
        if (client == null || client.getState() != CuratorFrameworkState.STARTED) {
            Map<ConnProps, CuratorFramework> map = factories;
            synchronized (map) {
                client = factories.get(props);
                if (client == null || client.getState() != CuratorFrameworkState.STARTED) {
                    client = CuratorFrameworkFactory.newClient((String)address, (RetryPolicy)ZkClientCache.retryPolicy(retry));
                    client.start();
                    log.info("\u521d\u59cb\u5316\u5ba2\u6237\u7aef\u8fde\u63a5\u5e76\u542f\u52a8. address: {}", (Object)address);
                    factories.put(props, client);
                }
            }
        }
        return client;
    }

    public static RetryPolicy retryPolicy(int retry) {
        if (retry < 0) {
            return ZkClientCache.retryForeverPolicy();
        }
        if (retry == 0) {
            return new RetryOneTime(100);
        }
        return new ExponentialBackoffRetry(100, retry);
    }

    public static RetryPolicy retryForeverPolicy() {
        return new RetryForever(2000);
    }

    public static void closeAll() {
        Set<Map.Entry<ConnProps, CuratorFramework>> set = factories.entrySet();
        Iterator<Map.Entry<ConnProps, CuratorFramework>> it = set.iterator();
        while (it.hasNext()) {
            Map.Entry<ConnProps, CuratorFramework> next = it.next();
            try {
                next.getValue().close();
            }
            catch (Throwable e) {
                log.error("", e);
            }
            it.remove();
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.warn("\u8fd0\u884cJVM\u865a\u62df\u673a\u505c\u6b62\u94a9\u5b50: \u5173\u95edZookeeper\u5ba2\u6237\u7aef\u8fde\u63a5");
            ZkClientCache.closeAll();
        }));
    }
}

