/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.concurrent.zookeeper;

import io.polaris.concurrent.zookeeper.ConnProps;
import io.polaris.concurrent.zookeeper.ZkClientCache;
import io.polaris.core.io.IO;
import io.polaris.core.os.OS;
import io.polaris.core.string.Strings;
import io.polaris.core.time.Dates;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeepAliveClient {
    private static final Logger log = LoggerFactory.getLogger(KeepAliveClient.class);
    private final ConnProps props;
    private final String namespace;
    private final String regPath;
    private final String vmProcessUid;
    private final long vmStartTime;
    private CuratorFramework client;

    public KeepAliveClient(ConnProps props, String regPath, Collection<String> hostPatterns) {
        this(props, null, regPath, hostPatterns);
    }

    public KeepAliveClient(ConnProps props, String regPath) {
        this(props, null, regPath, null);
    }

    public KeepAliveClient(ConnProps props, String namespace, String regPath) {
        this(props, namespace, regPath, null);
    }

    public KeepAliveClient(ConnProps props, String namespace, String regPath, Collection<String> hostPatterns) {
        this.props = props;
        this.namespace = namespace;
        this.regPath = regPath.startsWith("/") ? regPath : "/" + regPath;
        if (hostPatterns != null) {
            String[] regex = hostPatterns.toArray(new String[0]);
            this.vmProcessUid = OS.getPriorOrFirstIp((String[])regex) + "#" + OS.getPid();
        } else {
            this.vmProcessUid = OS.getFirstIp() + "#" + OS.getPid();
        }
        this.vmStartTime = OS.getVmStartTime();
    }

    public void startup() {
        log.info("\u521d\u59cb\u5316\u8fde\u63a5...");
        CuratorFramework client = ZkClientCache.getClient(this.props);
        this.client = Strings.isNotBlank((CharSequence)this.namespace) ? client.usingNamespace(this.namespace) : client;
    }

    public boolean registerNode() {
        return this.registerNode(this.vmProcessUid);
    }

    public boolean registerNode(String node) {
        CuratorFramework zkClient = this.client;
        boolean regSuccess = false;
        int tryTimes = 3;
        String path = this.regPath + "/" + node;
        for (int i = 0; i < tryTimes; ++i) {
            try {
                log.info("namespace:{}, state:{}", (Object)zkClient.getNamespace(), (Object)zkClient.getState());
                log.info("\u6ce8\u518c\u4e34\u65f6\u8282\u70b9{}...", (Object)path);
                ((ACLBackgroundPathAndBytesable)zkClient.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(path);
                zkClient.setData().forPath(path, (this.vmProcessUid + "@" + Dates.YYYY_MM_DD_HH_MM_SS_SSS.format(Instant.now())).getBytes());
                regSuccess = true;
                break;
            }
            catch (Exception e) {
                log.debug("\u901a\u4fe1\u5f02\u5e38", (Throwable)e);
                continue;
            }
        }
        if (!regSuccess) {
            log.error("\u6ce8\u518c\u8282\u70b9{}\u5931\u8d25!", (Object)path);
        }
        return regSuccess;
    }

    public List<String> getAllRegisterNodes() throws Exception {
        List list = (List)this.client.getChildren().forPath(this.regPath);
        return Collections.unmodifiableList(list);
    }

    public void shutdown() {
        CuratorFramework zkClient = this.client;
        IO.close((AutoCloseable)zkClient);
        this.client = null;
    }

    public ConnProps getProps() {
        return this.props;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getRegPath() {
        return this.regPath;
    }

    public String getVmProcessUid() {
        return this.vmProcessUid;
    }

    public long getVmStartTime() {
        return this.vmStartTime;
    }

    public CuratorFramework getClient() {
        return this.client;
    }
}

