/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.bytecode.javassist;

import io.polaris.bytecode.javassist.ContextClassPool;
import io.polaris.core.string.Strings;
import java.util.ArrayList;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;

public class JavassistBuilder {
    private String className;
    private String superClassName = "java.lang.Object";
    private final List<String> importPackages = new ArrayList<String>();
    private final List<String> interfaces = new ArrayList<String>();
    private final List<FieldBuilder> fields = new ArrayList<FieldBuilder>();
    private final List<ConstructorBuilder> constructors = new ArrayList<ConstructorBuilder>();
    private final List<MethodBuilder> methods = new ArrayList<MethodBuilder>();

    public static String getAvailableClassName(String baseName) {
        String className = baseName;
        int i = 0;
        while (true) {
            className = baseName + i;
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                break;
            }
            ++i;
        }
        return className;
    }

    public static JavassistBuilder newBuilder() {
        return new JavassistBuilder();
    }

    public static FieldBuilder newFieldBuilder() {
        return new FieldBuilder();
    }

    public static ConstructorBuilder newConstructorBuilder() {
        return new ConstructorBuilder();
    }

    public static MethodBuilder newMethodBuilder() {
        return new MethodBuilder();
    }

    public CtClass build() throws NotFoundException, CannotCompileException {
        return this.build(Thread.currentThread().getContextClassLoader());
    }

    public CtClass build(ClassLoader loader) throws NotFoundException, CannotCompileException {
        ClassPool pool = ContextClassPool.instance().getClassPool(loader);
        return this.build(pool);
    }

    public CtClass build(ClassPool pool) throws NotFoundException, CannotCompileException {
        CtClass ctClass = pool.makeClass(this.className, pool.get(this.superClassName));
        for (String importPackage : this.importPackages) {
            pool.importPackage(importPackage);
        }
        for (String anInterface : this.interfaces) {
            ctClass.addInterface(pool.get(anInterface));
        }
        for (FieldBuilder field : this.fields) {
            field.build(pool, ctClass);
        }
        for (ConstructorBuilder constructor : this.constructors) {
            constructor.build(pool, ctClass);
        }
        for (MethodBuilder method : this.methods) {
            method.build(pool, ctClass);
        }
        return ctClass;
    }

    public JavassistBuilder className(String className) {
        this.className = className;
        return this;
    }

    public JavassistBuilder superClassName(String superClassName) {
        this.superClassName = superClassName;
        return this;
    }

    public JavassistBuilder addImport(String ... imports) {
        for (String s : imports) {
            this.importPackages.add(s);
        }
        return this;
    }

    public JavassistBuilder addImport(Iterable<String> imports) {
        for (String s : imports) {
            this.importPackages.add(s);
        }
        return this;
    }

    public JavassistBuilder addInterface(String ... args) {
        for (String s : args) {
            this.interfaces.add(s);
        }
        return this;
    }

    public JavassistBuilder addInterface(Iterable<String> args) {
        for (String s : args) {
            this.interfaces.add(s);
        }
        return this;
    }

    public JavassistBuilder addField(FieldBuilder ... args) {
        for (FieldBuilder arg : args) {
            this.fields.add(arg);
        }
        return this;
    }

    public JavassistBuilder addField(Iterable<FieldBuilder> args) {
        for (FieldBuilder arg : args) {
            this.fields.add(arg);
        }
        return this;
    }

    public JavassistBuilder addConstructor(ConstructorBuilder ... args) {
        for (ConstructorBuilder arg : args) {
            this.constructors.add(arg);
        }
        return this;
    }

    public JavassistBuilder addConstructor(Iterable<ConstructorBuilder> args) {
        for (ConstructorBuilder arg : args) {
            this.constructors.add(arg);
        }
        return this;
    }

    public JavassistBuilder addMethod(MethodBuilder ... args) {
        for (MethodBuilder arg : args) {
            this.methods.add(arg);
        }
        return this;
    }

    public JavassistBuilder addMethod(Iterable<MethodBuilder> args) {
        for (MethodBuilder arg : args) {
            this.methods.add(arg);
        }
        return this;
    }

    public static class ConstructorBuilder {
        private String src;
        private List<String> parameterTypes = new ArrayList<String>();
        private List<String> exceptionTypes = new ArrayList<String>();
        private String body;

        public void build(ClassPool pool, CtClass ctClass) throws CannotCompileException, NotFoundException {
            if (!Strings.isBlank((CharSequence)this.src)) {
                CtConstructor constructor = CtNewConstructor.make((String)this.src, (CtClass)ctClass);
                ctClass.addConstructor(constructor);
            } else {
                int i;
                CtClass[] parameters = new CtClass[this.parameterTypes.size()];
                CtClass[] exceptions = new CtClass[this.exceptionTypes.size()];
                for (i = 0; i < parameters.length; ++i) {
                    parameters[i] = pool.get(this.parameterTypes.get(i));
                }
                for (i = 0; i < exceptions.length; ++i) {
                    exceptions[i] = pool.get(this.exceptionTypes.get(i));
                }
                CtConstructor constructor = CtNewConstructor.make((CtClass[])parameters, (CtClass[])exceptions, (String)this.body, (CtClass)ctClass);
                ctClass.addConstructor(constructor);
            }
        }

        public ConstructorBuilder src(String val) {
            this.src = val;
            return this;
        }

        public ConstructorBuilder addParameter(String ... types) {
            for (String type : types) {
                this.parameterTypes.add(type);
            }
            return this;
        }

        public ConstructorBuilder clearParameters() {
            this.parameterTypes.clear();
            return this;
        }

        public ConstructorBuilder addException(String ... types) {
            for (String type : types) {
                this.exceptionTypes.add(type);
            }
            return this;
        }

        public ConstructorBuilder clearExceptions() {
            this.exceptionTypes.clear();
            return this;
        }

        public ConstructorBuilder body(String body) {
            this.body = body;
            return this;
        }
    }

    public static class FieldBuilder {
        private String src;
        private String name;
        private String type;
        private int modifier;
        private boolean withSetter;
        private boolean withGetter;

        public void build(ClassPool pool, CtClass ctClass) throws CannotCompileException, NotFoundException {
            CtClass fieldType;
            CtField ctField;
            if (!Strings.isBlank((CharSequence)this.src)) {
                ctField = CtField.make((String)this.src, (CtClass)ctClass);
                ctField.getType();
            } else {
                fieldType = pool.get(this.type);
                ctField = new CtField(fieldType, this.name, ctClass);
                ctField.setModifiers(this.modifier);
            }
            ctClass.addField(ctField);
            fieldType = ctField.getType();
            String name = ctField.getName();
            if (this.withSetter) {
                CtMethod setter = CtNewMethod.setter((String)("set" + Strings.capitalize((String)name)), (CtField)ctField);
                ctClass.addMethod(setter);
            }
            if (this.withGetter) {
                CtMethod getter;
                if (fieldType.getSimpleName().equals("boolean")) {
                    getter = CtNewMethod.getter((String)("is" + Strings.capitalize((String)name)), (CtField)ctField);
                    ctClass.addMethod(getter);
                } else {
                    getter = CtNewMethod.getter((String)("get" + Strings.capitalize((String)name)), (CtField)ctField);
                    ctClass.addMethod(getter);
                }
            }
        }

        public FieldBuilder withSetter() {
            this.withSetter = true;
            return this;
        }

        public FieldBuilder withGetter() {
            this.withGetter = true;
            return this;
        }

        public FieldBuilder withSetter(boolean withSetter) {
            this.withSetter = withSetter;
            return this;
        }

        public FieldBuilder withGetter(boolean withGetter) {
            this.withGetter = withGetter;
            return this;
        }

        public FieldBuilder src(String val) {
            this.src = val;
            return this;
        }

        public FieldBuilder name(String val) {
            this.name = val;
            return this;
        }

        public FieldBuilder type(String val) {
            this.type = val;
            return this;
        }

        public FieldBuilder modifier(int val) {
            this.modifier = val;
            return this;
        }
    }

    public static class MethodBuilder {
        private String src;
        private CtClass returnType;
        private String name;
        private List<String> parameterTypes = new ArrayList<String>();
        private List<String> exceptionTypes = new ArrayList<String>();
        private String body;
        private boolean varargs;

        public void build(ClassPool pool, CtClass ctClass) throws CannotCompileException, NotFoundException {
            if (!Strings.isBlank((CharSequence)this.src)) {
                CtMethod ctMethod = CtNewMethod.make((String)this.src, (CtClass)ctClass);
                ctClass.addMethod(ctMethod);
                if (this.varargs) {
                    ctMethod.setModifiers(ctMethod.getModifiers() | 0x80);
                }
            } else {
                int i;
                CtClass[] parameters = new CtClass[this.parameterTypes.size()];
                CtClass[] exceptions = new CtClass[this.exceptionTypes.size()];
                for (i = 0; i < parameters.length; ++i) {
                    parameters[i] = pool.get(this.parameterTypes.get(i));
                }
                for (i = 0; i < exceptions.length; ++i) {
                    exceptions[i] = pool.get(this.exceptionTypes.get(i));
                }
                CtMethod ctMethod = CtNewMethod.make((CtClass)this.returnType, (String)this.name, (CtClass[])parameters, (CtClass[])exceptions, (String)this.body, (CtClass)ctClass);
                if (this.varargs) {
                    ctMethod.setModifiers(ctMethod.getModifiers() | 0x80);
                }
                ctClass.addMethod(ctMethod);
            }
        }

        public MethodBuilder src(String src) {
            this.src = src;
            return this;
        }

        public MethodBuilder varargs() {
            this.varargs = true;
            return this;
        }

        public MethodBuilder varargs(boolean val) {
            this.varargs = val;
            return this;
        }

        public MethodBuilder returnType(CtClass returnType) {
            this.returnType = returnType;
            return this;
        }

        public MethodBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MethodBuilder addParameter(String ... types) {
            for (String type : types) {
                this.parameterTypes.add(type);
            }
            return this;
        }

        public MethodBuilder clearParameters() {
            this.parameterTypes.clear();
            return this;
        }

        public MethodBuilder addException(String ... types) {
            for (String type : types) {
                this.exceptionTypes.add(type);
            }
            return this;
        }

        public MethodBuilder clearExceptions() {
            this.exceptionTypes.clear();
            return this;
        }

        public MethodBuilder body(String body) {
            this.body = body;
            return this;
        }
    }
}

