/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.builder.code.dto;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import io.polaris.builder.code.dto.TableDto;
import io.polaris.core.map.Maps;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.SerializationUtils;

@XStreamAlias(value="schema")
public class SchemaDto
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XStreamAlias(value="name")
    @XStreamAsAttribute
    private String name;
    @XStreamAlias(value="tables")
    @XStreamImplicit(itemFieldName="table", keyFieldName="name")
    private Map<String, TableDto> tables = Maps.newUpperCaseLinkedHashMap();

    public TableDto getTable(String name) {
        return this.tables.get(name);
    }

    public void addTable(TableDto table) {
        this.tables.put(table.getName(), table);
    }

    public SchemaDto clone() {
        return (SchemaDto)SerializationUtils.clone((Serializable)this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaDto)) {
            return false;
        }
        SchemaDto other = (SchemaDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, TableDto> this$tables = this.tables;
        Map<String, TableDto> other$tables = other.tables;
        return !(this$tables == null ? other$tables != null : !((Object)this$tables).equals(other$tables));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchemaDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, TableDto> $tables = this.tables;
        result = result * 59 + ($tables == null ? 43 : ((Object)$tables).hashCode());
        return result;
    }

    public String toString() {
        return "SchemaDto(name=" + this.name + ")";
    }
}

